/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tools;

import appeng.api.parts.IPartHost;
import appeng.block.AEBaseTileBlock;
import appeng.parts.PartPlacement;
import appeng.util.Platform;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.util.GTToolHarvestHelper;
import gregtech.common.items.behaviors.BehaviourSwitchMode;
import gregtech.common.items.behaviors.BehaviourWrench;
import gregtech.common.tools.GTTool;
import ic2.api.tile.IWrenchable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;

public class ToolWrench
extends GTTool {
    public static final List<String> mEffectiveList = Arrays.asList(EntityIronGolem.class.getName(), "EntityTowerGuardian");
    private ItemStack wrenchableDrop = null;
    private float wrenchableDropRate = 0.0f;
    private boolean LastEventFromThis = false;

    @Override
    public float getNormalDamageAgainstEntity(float aOriginalDamage, Entity aEntity, ItemStack aStack, EntityPlayer aPlayer) {
        String tName = aEntity.getClass().getName();
        return mEffectiveList.contains(tName = tName.substring(tName.lastIndexOf(46) + 1)) || tName.contains("Golem") ? aOriginalDamage * 2.0f : aOriginalDamage;
    }

    @Override
    public int getToolDamagePerBlockBreak() {
        return 50;
    }

    @Override
    public int getToolDamagePerDropConversion() {
        return 100;
    }

    @Override
    public int getToolDamagePerContainerCraft() {
        return 800;
    }

    @Override
    public int getToolDamagePerEntityAttack() {
        return 200;
    }

    @Override
    public int getBaseQuality() {
        return 0;
    }

    @Override
    public float getBaseDamage() {
        return 3.0f;
    }

    @Override
    public int getHurtResistanceTime(int aOriginalHurtResistance, Entity aEntity) {
        return aOriginalHurtResistance * 2;
    }

    @Override
    public float getSpeedMultiplier() {
        return 1.0f;
    }

    @Override
    public float getMaxDurabilityMultiplier() {
        return 1.0f;
    }

    @Override
    public String getCraftingSound() {
        return SoundResource.IC2_TOOLS_WRENCH.toString();
    }

    @Override
    public String getEntityHitSound() {
        return null;
    }

    @Override
    public String getMiningSound() {
        return SoundResource.IC2_TOOLS_WRENCH.toString();
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public boolean isCrowbar() {
        return false;
    }

    @Override
    public boolean isWrench() {
        return true;
    }

    @Override
    public boolean isMinableBlock(Block block, byte aMetaData) {
        return GTToolHarvestHelper.isAppropriateTool(block, aMetaData, "wrench") || GTToolHarvestHelper.isAppropriateMaterial(block, Material.field_76233_E) || block instanceof AEBaseTileBlock || GTToolHarvestHelper.isSpecialBlock(block, Blocks.field_150462_ai, Blocks.field_150342_X) || BehaviourWrench.isVanillaRotatable(block) || GTToolHarvestHelper.isIC2Wrenchable(block);
    }

    @Override
    public ItemStack getBrokenItem(ItemStack aStack) {
        return null;
    }

    @Override
    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? Textures.ItemIcons.WRENCH : null;
    }

    @Override
    public short[] getRGBa(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? MetaGeneratedTool.getPrimaryMaterial((ItemStack)aStack).mRGBa : null;
    }

    @Override
    public void onStatsAddedToTool(MetaGeneratedTool aItem, int aID) {
        aItem.addItemBehavior(aID, new BehaviourSwitchMode());
        aItem.addItemBehavior(aID, new BehaviourWrench(100));
    }

    @Override
    public IChatComponent getDeathMessage(EntityLivingBase aPlayer, EntityLivingBase aEntity) {
        return new ChatComponentText(EnumChatFormatting.GREEN + aPlayer.func_70005_c_() + EnumChatFormatting.WHITE + " threw a Monkey Wrench into the Plans of " + EnumChatFormatting.RED + aEntity.func_70005_c_() + EnumChatFormatting.WHITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBreakBlock(@Nonnull EntityPlayer player, int x, int y, int z, @Nonnull Block block, byte metadata, TileEntity tile, @Nonnull BlockEvent.BreakEvent event) {
        if (tile instanceof IWrenchable) {
            IWrenchable wrenchable = (IWrenchable)tile;
            if (!wrenchable.wrenchCanRemove(player)) {
                event.setCanceled(true);
                return;
            }
            this.wrenchableDrop = wrenchable.getWrenchDrop(player);
            this.wrenchableDropRate = wrenchable.getWrenchDropRate();
        }
        if (block instanceof AEBaseTileBlock) {
            AEBaseTileBlock aeBaseTileBlock = (AEBaseTileBlock)block;
            if (this.LastEventFromThis) {
                return;
            }
            boolean sneak = player.func_70093_af();
            try {
                this.LastEventFromThis = true;
                player.func_70095_a(true);
                MovingObjectPosition movObjPosition = Platform.rayTrace((EntityPlayer)player, (boolean)true, (boolean)false);
                if (movObjPosition == null) {
                    event.setCanceled(true);
                    return;
                }
                int sideHit = movObjPosition.field_72310_e;
                if (tile instanceof IPartHost) {
                    if (sneak && PartPlacement.place((ItemStack)player.func_70694_bm(), (int)x, (int)y, (int)z, (int)sideHit, (EntityPlayer)player, (World)player.field_70170_p, (PartPlacement.PlaceType)PartPlacement.PlaceType.INTERACT_FIRST_PASS, (int)0)) {
                        event.setCanceled(true);
                    }
                    return;
                }
                if (aeBaseTileBlock.func_149727_a(event.world, x, y, z, player, sideHit, (float)x, (float)y, (float)z)) {
                    event.setCanceled(true);
                }
            }
            finally {
                this.LastEventFromThis = false;
                player.func_70095_a(sneak);
            }
        }
    }

    @Override
    public int convertBlockDrops(List<ItemStack> drops, ItemStack Stack, EntityPlayer player, Block block, int x, int y, int z, byte metaData, int fortune, boolean silkTouch, BlockEvent.HarvestDropsEvent event) {
        ItemStack drop = null;
        int modified = 0;
        if (this.wrenchableDrop != null) {
            drop = this.wrenchableDrop;
            this.wrenchableDrop = null;
            modified = this.wrenchableDropRate == 1.0f ? 3 : 10;
            this.wrenchableDropRate = 0.0f;
        } else if (block == Blocks.field_150342_X || block == Blocks.field_150477_bB) {
            drop = new ItemStack(block);
            modified = 1;
        }
        if (drop != null) {
            event.dropChance = 1.0f;
            drops.clear();
            drops.add(drop);
        }
        return modified;
    }

    @Override
    public byte getMaxMode() {
        return 2;
    }

    @Override
    public String getToolTypeName() {
        return "wrench";
    }
}

