/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multiblock;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.NumericWidget;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.multitileentity.enums.GT_MultiTileCasing;
import gregtech.api.multitileentity.multiblock.base.ComplexParallelController;
import gregtech.api.multitileentity.multiblock.base.MultiBlockPart;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GT_StructureUtilityMuTE;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.multiblock.logic.LaserEngraverProcessingLogic;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class LaserEngraver
extends ComplexParallelController<LaserEngraver, LaserEngraverProcessingLogic> {
    private static IStructureDefinition<LaserEngraver> STRUCTURE_DEFINITION = null;
    protected static final String STRUCTURE_MAIN = "Main";
    protected static final String STRUCTURE_PIECE_T1 = "T1";
    protected static final String STRUCTURE_PIECE_T2 = "T2";
    protected static final String STRUCTURE_PIECE_T3 = "T3";
    protected static final String STRUCTURE_PIECE_T4 = "T4";
    protected static final String STRUCTURE_PIECE_T5 = "T5";
    protected static final String STRUCTURE_PIECE_T6 = "T6";
    protected static final int PROCESS_WINDOW_BASE_ID = 100;
    protected static final Vec3Impl STRUCTURE_OFFSET_T1 = new Vec3Impl(3, 1, 0);
    protected static final Vec3Impl STRUCTURE_OFFSET_T2 = new Vec3Impl(1, 3, 0);
    protected static final Vec3Impl STRUCTURE_OFFSET_T3 = new Vec3Impl(-6, 0, -5);
    protected static final Vec3Impl STRUCTURE_OFFSET_T4 = new Vec3Impl(18, 0, 0);
    protected static final Vec3Impl STRUCTURE_OFFSET_T5 = new Vec3Impl(-18, 0, 9);
    protected static final Vec3Impl STRUCTURE_OFFSET_T6 = new Vec3Impl(18, 0, 0);
    protected static final int MAX_PROCESSES = 6;
    protected RecipeMap<?> recipeMap;
    private UUID LaserEngraver;

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.laserengraver";
    }

    @Override
    public Vec3Impl getStartingStructureOffset() {
        return STRUCTURE_OFFSET_T1;
    }

    @Override
    public boolean checkMachine() {
        this.buildState.startBuilding(this.getStartingStructureOffset());
        if (!this.checkPiece(STRUCTURE_PIECE_T1, this.buildState.getCurrentOffset())) {
            return this.buildState.failBuilding();
        }
        if (this.maxComplexParallels > 1) {
            this.buildState.addOffset(STRUCTURE_OFFSET_T2);
            if (!this.checkPiece(STRUCTURE_PIECE_T2, this.buildState.getCurrentOffset())) {
                return this.buildState.failBuilding();
            }
        }
        if (this.maxComplexParallels > 2) {
            this.buildState.addOffset(STRUCTURE_OFFSET_T3);
            if (!this.checkPiece(STRUCTURE_PIECE_T3, this.buildState.getCurrentOffset())) {
                return this.buildState.failBuilding();
            }
        }
        if (this.maxComplexParallels > 3) {
            this.buildState.addOffset(STRUCTURE_OFFSET_T4);
            if (!this.checkPiece(STRUCTURE_PIECE_T4, this.buildState.getCurrentOffset())) {
                return this.buildState.failBuilding();
            }
        }
        if (this.maxComplexParallels > 4) {
            this.buildState.addOffset(STRUCTURE_OFFSET_T5);
            if (!this.checkPiece(STRUCTURE_PIECE_T5, this.buildState.getCurrentOffset())) {
                return this.buildState.failBuilding();
            }
        }
        if (this.maxComplexParallels > 5) {
            this.buildState.addOffset(STRUCTURE_OFFSET_T6);
            if (!this.checkPiece(STRUCTURE_PIECE_T6, this.buildState.getCurrentOffset())) {
                return this.buildState.failBuilding();
            }
        }
        this.buildState.stopBuilding();
        return super.checkMachine();
    }

    public void construct(ItemStack trigger, boolean hintsOnly) {
        this.buildState.startBuilding(this.getStartingStructureOffset());
        this.buildPiece(STRUCTURE_PIECE_T1, trigger, hintsOnly, this.buildState.getCurrentOffset());
        if (this.maxComplexParallels > 1) {
            this.buildState.addOffset(STRUCTURE_OFFSET_T2);
            this.buildPiece(STRUCTURE_PIECE_T2, trigger, hintsOnly, this.buildState.getCurrentOffset());
        }
        if (this.maxComplexParallels > 2) {
            this.buildState.addOffset(STRUCTURE_OFFSET_T3);
            this.buildPiece(STRUCTURE_PIECE_T3, trigger, hintsOnly, this.buildState.getCurrentOffset());
        }
        if (this.maxComplexParallels > 3) {
            this.buildState.addOffset(STRUCTURE_OFFSET_T4);
            this.buildPiece(STRUCTURE_PIECE_T4, trigger, hintsOnly, this.buildState.getCurrentOffset());
        }
        if (this.maxComplexParallels > 4) {
            this.buildState.addOffset(STRUCTURE_OFFSET_T5);
            this.buildPiece(STRUCTURE_PIECE_T5, trigger, hintsOnly, this.buildState.getCurrentOffset());
        }
        if (this.maxComplexParallels > 5) {
            this.buildState.addOffset(STRUCTURE_OFFSET_T6);
            this.buildPiece(STRUCTURE_PIECE_T6, trigger, hintsOnly, this.buildState.getCurrentOffset());
        }
        this.buildState.stopBuilding();
    }

    @Override
    public IStructureDefinition<LaserEngraver> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_T1, StructureUtility.transpose((String[][])new String[][]{{"ACADA", "AAAAA", "AAAAA"}, {"GGA~A", "H   I", "GGAAA"}, {"AAAAA", "ABBBA", "AAAAA"}})).addShape(STRUCTURE_PIECE_T2, (String[][])new String[][]{{"       ", "       ", "       ", "       ", "       ", "       "}, {"  K    ", "  K    ", "  K    ", "       ", "       ", "       "}, {"  K    ", "       ", "       ", "       ", "       ", "       "}, {"  K    ", "       ", "       ", "       ", "       ", "       "}, {"  K    ", "       ", "       ", "       ", "       ", "       "}, {"  K    ", "FBF FBF", " G   G ", " G   G ", " G   G ", "FBF FBF"}, {" KKKKK ", "BIB BIB", "G G G G", "G G G G", "G G G G", "BHB BHB"}, {" K   K ", "FBF FBF", " G   G ", " G   G ", " G   G ", "FBF FBF"}, {" K   K ", "       ", "       ", "       ", "       ", "       "}, {" K   K ", "FBF FBF", " G   G ", " G   G ", " G   G ", "FBF FBF"}, {" KKKKK ", "BIB BIB", "G G G G", "G G G G", "G G G G", "BHB BHB"}, {"       ", "FBF FBF", " G   G ", " G   G ", " G   G ", "FBF FBF"}}).addShape(STRUCTURE_PIECE_T3, (String[][])new String[][]{{"              ", "   BBBBB  FBF ", "   BGGGB   G  ", "   BGGGB   G  ", "   BMLMB   G  ", "   BBBBB  FBF "}, {"     KKKKKKK  ", "  BBAAABB BIB ", "  B     B G G ", "  B     B G G ", "  B     B G G ", "  BBBBBBB BHB "}, {"     K        ", "  BABBBAB FBF ", "  G     G  G  ", "  G     G  G  ", "  M HHH M  G  ", "  BBBBBBB FBF "}, {"KKKKKK        ", "  BABIBAB     ", "  G     G     ", "  G     G     ", "  L HHH L     ", "  BBBBBBB     "}, {"     K        ", "  BABBBAB FBF ", "  G     G  G  ", "  G     G  G  ", "  M HHH M  G  ", "  BBBBBBB FBF "}, {"     KKKKKKK  ", "  BBAAABB BIB ", "  B     B G G ", "  B     B G G ", "  B     B G G ", "  BBBBBBB BHB "}, {"              ", "   BBBBB  FBF ", "   BGGGB   G  ", "   BGGGB   G  ", "   BMLMB   G  ", "   BBBBB  FBF "}}).addShape(STRUCTURE_PIECE_T4, (String[][])new String[][]{{"             ", "FBF  BBBBB   ", " G   BGGGB   ", " G   BGGGB   ", " G   BNLNB   ", "FBF  BBBBB   "}, {" KKKKKKK     ", "BIB BBAAABB  ", "G G B     B  ", "G G B     B  ", "G G B     B  ", "BHB BBBBBBB  "}, {"       K     ", "FBF BABBBAB  ", " G  G     G  ", " G  G     G  ", " G  N HHH N  ", "FBF BBBBBBB  "}, {"       KKKKKK", "    BABIBAB  ", "    G     G  ", "    G     G  ", "    L HHH L  ", "    BBBBBBB  "}, {"       K     ", "FBF BABBBAB  ", " G  G     G  ", " G  G     G  ", " G  N HHH N  ", "FBF BBBBBBB  "}, {" KKKKKKK     ", "BIB BBAAABB  ", "G G B     B  ", "G G B     B  ", "G G B     B  ", "BHB BBBBBBB  "}, {"             ", "FBF  BBBBB   ", " G   BGGGB   ", " G   BGGGB   ", " G   BNLNB   ", "FBF  BBBBB   "}}).addShape(STRUCTURE_PIECE_T5, (String[][])new String[][]{{"              ", "   BBBBB  FBF ", "   BGGGB   G  ", "   BGGGB   G  ", "   BOLOB   G  ", "   BBBBB  FBF "}, {"     KKKKKKK  ", "  BBAAABB BIB ", "  B     B G G ", "  B     B G G ", "  B     B G G ", "  BBBBBBB BHB "}, {"     K        ", "  BABBBAB FBF ", "  G     G  G  ", "  G     G  G  ", "  O HHH O  G  ", "  BBBBBBB FBF "}, {"     K        ", "  BABIBAB     ", "  G     G     ", "  G     G     ", "  L HHH L     ", "  BBBBBBB     "}, {"     K        ", "  BABBBAB FBF ", "  G     G  G  ", "  G     G  G  ", "  O HHH O  G  ", "  BBBBBBB FBF "}, {"     KKKKKKK  ", "  BBAAABB BIB ", "  B     B G G ", "  B     B G G ", "  B     B G G ", "  BBBBBBB BHB "}, {"     K        ", "   BBBBB  FBF ", "   BGGGB   G  ", "   BGGGB   G  ", "   BOLOB   G  ", "   BBBBB  FBF "}, {"     K  ", "       ", "       ", "       ", "       "}, {"     K  ", "       ", "       ", "       ", "       "}, {"     K  ", "       ", "       ", "       ", "       "}}).addShape(STRUCTURE_PIECE_T6, (String[][])new String[][]{{"             ", "FBF  BBBBB   ", " G   BGGGB   ", " G   BGGGB   ", " G   BPLPB   ", "FBF  BBBBB   "}, {" KKKKKKK     ", "BIB BBAAABB  ", "G G B     B  ", "G G B     B  ", "G G B     B  ", "BHB BBBBBBB  "}, {"       K     ", "FBF BABBBAB  ", " G  G     G  ", " G  G     G  ", " G  P HHH P  ", "FBF BBBBBBB  "}, {"       K     ", "    BABIBAB  ", "    G     G  ", "    G     G  ", "    L HHH L  ", "    BBBBBBB  "}, {"       K     ", "FBF BABBBAB  ", " G  G     G  ", " G  G     G  ", " G  P HHH P  ", "FBF BBBBBBB  "}, {" KKKKKKK     ", "BIB BBAAABB  ", "G G B     B  ", "G G B     B  ", "G G B     B  ", "BHB BBBBBBB  "}, {"       K     ", "FBF  BBBBB   ", " G   BGGGB   ", " G   BGGGB   ", " G   BPLPB   ", "FBF  BBBBB   "}, {"       K  ", "       ", "       ", "       ", "       "}, {"       K  ", "       ", "       ", "       ", "       "}, {"       K  ", "       ", "       ", "       ", "       "}}).addElement('A', GT_StructureUtilityMuTE.ofMuTECasings(MultiBlockPart.FLUID_IN | MultiBlockPart.ITEM_IN | MultiBlockPart.FLUID_OUT | MultiBlockPart.ITEM_OUT | MultiBlockPart.ENERGY_IN, GT_MultiTileCasing.LaserEngraver.getCasing())).addElement('B', GT_StructureUtilityMuTE.ofMuTECasings(MultiBlockPart.FLUID_IN | MultiBlockPart.ITEM_IN | MultiBlockPart.FLUID_OUT | MultiBlockPart.ITEM_OUT | MultiBlockPart.ENERGY_IN, GT_MultiTileCasing.BlackLaserEngraverCasing.getCasing())).addElement('C', GT_StructureUtilityMuTE.ofMuTECasings(0, GT_StructureUtilityMuTE.CLEANROOM_CASINGS, GT_MultiTileCasing.LaserEngraver.getCasing())).addElement('D', GT_StructureUtilityMuTE.ofMuTECasings(0, GT_StructureUtilityMuTE.WIRELESS_CASINGS, GT_MultiTileCasing.LaserEngraver.getCasing())).addElement('E', GT_StructureUtilityMuTE.ofMuTECasings(0, GT_StructureUtilityMuTE.MOTOR_CASINGS)).addElement('F', GTStructureUtility.ofFrame(Materials.Naquadah)).addElement('H', GT_StructureUtilityMuTE.ofMuTECasings(0, GT_MultiTileCasing.Mirror.getCasing())).addElement('G', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofBlockUnlocalizedName((String)Mods.IndustrialCraft2.ID, (String)"blockAlloyGlass", (int)0, (boolean)true), StructureUtility.ofBlockUnlocalizedName((String)Mods.BartWorks.ID, (String)"BW_GlasBlocks", (int)0, (boolean)true), StructureUtility.ofBlockUnlocalizedName((String)Mods.BartWorks.ID, (String)"BW_GlasBlocks2", (int)0, (boolean)true), StructureUtility.ofBlockUnlocalizedName((String)Mods.Thaumcraft.ID, (String)"blockCosmeticOpaque", (int)2, (boolean)false)})).addElement('I', GT_StructureUtilityMuTE.ofMuTECasings(0, GT_StructureUtilityMuTE.EMITTER_CASINGS)).addElement('K', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)11)).addElement('L', GT_StructureUtilityMuTE.ofMuTECasings(0, GT_StructureUtilityMuTE.ROBOT_ARM_CASINGS)).addElement('M', GT_StructureUtilityMuTE.ofMuTECasings(0, GT_MultiTileCasing.LaserEngraverUpgrade1.getCasing())).addElement('N', GT_StructureUtilityMuTE.ofMuTECasings(0, GT_MultiTileCasing.LaserEngraverUpgrade2.getCasing())).addElement('O', GT_StructureUtilityMuTE.ofMuTECasings(0, GT_MultiTileCasing.LaserEngraverUpgrade3.getCasing())).addElement('P', GT_StructureUtilityMuTE.ofMuTECasings(0, GT_MultiTileCasing.LaserEngraverUpgrade4.getCasing())).build();
            this.buildState.stopBuilding();
        }
        return STRUCTURE_DEFINITION;
    }

    protected MultiChildWidget createMainPage(IWidgetBuilder<?> builder) {
        MultiChildWidget child = new MultiChildWidget();
        for (int i = 0; i < 6; ++i) {
            int processIndex = i;
            child.addChild(new ButtonWidget().setPlayClickSound(true).setOnClick((clickData, widget) -> {
                if (!widget.isClient()) {
                    widget.getContext().openSyncedWindow(100 + processIndex);
                }
            }).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD, GTUITextures.OVERLAY_BUTTON_WHITELIST}).setSize(18, 18).setEnabled(widget -> processIndex < this.maxComplexParallels).setPos(20 * (i % 4) + 18, 18 + i / 4 * 20));
        }
        child.addChild(new NumericWidget().setGetter(() -> this.maxComplexParallels).setSetter(parallel -> this.setMaxComplexParallels((int)parallel, true)).setBounds(1.0, 6.0).setTextColor(Color.WHITE.normal).setTextAlignment(Alignment.Center).addTooltip("Tier").setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}).setSize(18, 18).setPos(130, 85));
        return child;
    }

    @Override
    public short getCasingRegistryID() {
        return 0;
    }

    @Override
    public void readMultiTileNBT(NBTTagCompound nbt) {
        super.readMultiTileNBT(nbt);
        this.setMaxComplexParallels(nbt.func_74762_e("processors"), false);
    }

    @Override
    public void writeMultiTileNBT(NBTTagCompound nbt) {
        super.writeMultiTileNBT(nbt);
        nbt.func_74768_a("processors", this.maxComplexParallels);
    }

    @Override
    public int getCasingMeta() {
        return GT_MultiTileCasing.LaserEngraver.getId();
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Laser Engraver").addInfo("Used for Engraving").beginStructureBlock(3, 3, 5, true).addController("Front right center").toolTipFinisher(GTValues.AuthorTheEpicGamer274);
        return tt;
    }

    @Override
    @Nonnull
    protected LaserEngraverProcessingLogic createProcessingLogic() {
        return new LaserEngraverProcessingLogic();
    }
}

