/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchMagnet;
import gregtech.api.multitileentity.multiblock.casing.Glasses;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.blocks.BlockCasings10;
import gregtech.common.items.MetaGeneratedItem01;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class MTEIndustrialElectromagneticSeparator
extends MTEExtendedPowerMultiBlockBase<MTEIndustrialElectromagneticSeparator>
implements ISurvivalConstructable {
    final int MIN_CASING = 64;
    private MTEHatchMagnet mMagHatch = null;
    private MagnetTiers magnetTier = null;
    private static final int MACHINEMODE_SEPARATOR = 0;
    private static final int MACHINEMODE_POLARIZER = 1;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTEIndustrialElectromagneticSeparator> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", (String[][])new String[][]{{"  CCC  ", "       ", "       ", "       ", "       ", "  B~B  "}, {" CC CC ", "       ", "  BBB  ", "  AAA  ", "  BEB  ", " BBBBB "}, {"CC   CC", "       ", " BBBBB ", " A   A ", " BBBBB ", "BBBBBBB"}, {"C     C", "C     C", "CBBBBBC", "CA C AC", "CBBBBBC", "BBBBBBB"}, {"CC   CC", "       ", " BBBBB ", " A   A ", " BBBBB ", "BBBBBBB"}, {" CC CC ", "       ", "  BBB  ", "  AAA  ", "  BBB  ", " BBBBB "}, {"  CCC  ", "   C   ", "   C   ", "   C   ", "   C   ", "  BBB  "}}).addElement('A', Glasses.chainAllGlasses()).addElement('B', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTEIndustrialElectromagneticSeparator.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy.or(HatchElement.ExoticEnergy)).casingIndex(((BlockCasings10)GregTechAPI.sBlockCasings10).getTextureIndex(0)).dot(1).buildAndChain(StructureUtility.onElementPass(MTEIndustrialElectromagneticSeparator::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings10, (int)0)))})).addElement('C', GTStructureUtility.ofFrame(Materials.NeodymiumMagnetic)).addElement('E', GTStructureUtility.buildHatchAdder(MTEIndustrialElectromagneticSeparator.class).adder(MTEIndustrialElectromagneticSeparator::addMagHatch).hatchClass(MTEHatchMagnet.class).casingIndex(((BlockCasings10)GregTechAPI.sBlockCasings10).getTextureIndex(0)).dot(2).build()).build();
    private int mCasingAmount;

    public MTEIndustrialElectromagneticSeparator(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEIndustrialElectromagneticSeparator(String aName) {
        super(aName);
    }

    @Override
    public IStructureDefinition<MTEIndustrialElectromagneticSeparator> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEIndustrialElectromagneticSeparator(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        ITexture[] rTexture = side == aFacing ? (aActive ? new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 0)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_EMS_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_EMS_ACTIVE_GLOW).extFacing().glow().build()} : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 0)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_EMS).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_EMS_GLOW).extFacing().glow().build()}) : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 0))};
        return rTexture;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Electromagnetic Separator/Polarizer").addInfo("Use screwdriver to switch mode").addInfo("Insert an electromagnet into the electromagnet housing to use").addInfo("Better electromagnets give further bonuses").addInfo("With Tengam electromagnet, multiamp (NOT laser) hatches are allowed").beginStructureBlock(7, 6, 7, false).addController("Front Center").addCasingInfoMin("MagTech Casings", 64, false).addOtherStructurePart("Any glass", "x12").addOtherStructurePart("Magnetic Neodymium Frame Box", "x37").addOtherStructurePart("Electromagnet Housing", "1 Block Above/Behind Controller", 2).addInputBus("Any Casing", 1).addOutputBus("Any Casing", 1).addEnergyHatch("Any Casing", 1).addMaintenanceHatch("Any Casing", 1).toolTipFinisher(GTValues.AuthorFourIsTheNumber, GTValues.authorBaps);
        return tt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 3, 5, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 3, 5, 0, elementBudget, env, false, true);
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasingAmount = 0;
        this.mMagHatch = null;
        this.mExoticEnergyHatches.clear();
        this.mEnergyHatches.clear();
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 3, 5, 0)) {
            return false;
        }
        if (this.mCasingAmount < 64) {
            return false;
        }
        if (this.mMagHatch == null) {
            return false;
        }
        if (!this.mExoticEnergyHatches.isEmpty()) {
            if (!this.mEnergyHatches.isEmpty()) {
                return false;
            }
            if (this.mExoticEnergyHatches.size() > 1) {
                return false;
            }
            return ((MTEHatch)this.mExoticEnergyHatches.get(0)).maxWorkingAmperesIn() <= 64L;
        }
        return true;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                MTEIndustrialElectromagneticSeparator.this.findMagnet();
                if (MTEIndustrialElectromagneticSeparator.this.magnetTier != null) {
                    if (!MTEIndustrialElectromagneticSeparator.this.mExoticEnergyHatches.isEmpty() && !((MTEIndustrialElectromagneticSeparator)MTEIndustrialElectromagneticSeparator.this).magnetTier.supportsExotic) {
                        return SimpleCheckRecipeResult.ofFailure("electromagnet_insufficient");
                    }
                    this.euModifier = ((MTEIndustrialElectromagneticSeparator)MTEIndustrialElectromagneticSeparator.this).magnetTier.euModifier;
                    this.speedBoost = ((MTEIndustrialElectromagneticSeparator)MTEIndustrialElectromagneticSeparator.this).magnetTier.speedBoost;
                    return CheckRecipeResultRegistry.SUCCESSFUL;
                }
                return SimpleCheckRecipeResult.ofFailure("electromagnet_missing");
            }
        }.setMaxParallelSupplier(this::getMaxParallels);
    }

    private int getMaxParallels() {
        if (this.magnetTier != null) {
            return this.magnetTier.maxParallel;
        }
        return 0;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return this.machineMode == 1 ? RecipeMaps.polarizerRecipes : RecipeMaps.electroMagneticSeparatorRecipes;
    }

    @Override
    @Nonnull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(RecipeMaps.polarizerRecipes, RecipeMaps.electroMagneticSeparatorRecipes);
    }

    @Override
    public int getRecipeCatalystPriority() {
        return -10;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("polarizerMode")) {
            this.machineMode = aNBT.func_74767_n("polarizerMode") ? 1 : 0;
            aNBT.func_82580_o("polarizerMode");
        }
        super.loadNBTData(aNBT);
    }

    @Override
    public boolean supportsMachineModeSwitch() {
        return true;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.setMachineMode(this.nextMachineMode());
        PlayerUtils.messagePlayer(aPlayer, String.format(StatCollector.func_74838_a((String)"GT5U.MULTI_MACHINE_CHANGE"), this.getMachineModeName()));
    }

    @Override
    public void setMachineModeIcons() {
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_SEPARATOR);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_POLARIZER);
    }

    @Override
    public String getMachineModeName() {
        return StatCollector.func_74838_a((String)("GT5U.INDUSTRIAL_ELECTROMAGNETIC_SEPARATOR.mode." + this.machineMode));
    }

    @Override
    public void clearHatches() {
        super.clearHatches();
        this.mExoticEnergyHatches.clear();
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("mode", this.machineMode);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currentTip.add(StatCollector.func_74838_a((String)"GT5U.machines.oreprocessor1") + " " + EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)("GT5U.INDUSTRIAL_ELECTROMAGNETIC_SEPARATOR.mode." + tag.func_74762_e("mode"))) + EnumChatFormatting.RESET);
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        if (this.mExoticEnergyHatches.isEmpty()) {
            logic.setAvailableVoltage(GTUtility.roundUpVoltage(this.getMaxInputVoltage()));
            logic.setAvailableAmperage(1L);
        } else {
            super.setProcessingLogicPower(logic);
        }
    }

    private void findMagnet() {
        ItemStack aSlot;
        this.magnetTier = null;
        if (this.mMagHatch != null && (aSlot = this.mMagHatch.func_70301_a(0)) != null) {
            switch (aSlot.func_77960_j()) {
                case 32345: {
                    this.magnetTier = MagnetTiers.Iron;
                    break;
                }
                case 32346: {
                    this.magnetTier = MagnetTiers.Steel;
                    break;
                }
                case 32347: {
                    this.magnetTier = MagnetTiers.Neodymium;
                    break;
                }
                case 32348: {
                    this.magnetTier = MagnetTiers.Samarium;
                    break;
                }
                case 32349: {
                    this.magnetTier = MagnetTiers.Tengam;
                    break;
                }
                default: {
                    this.magnetTier = null;
                }
            }
        }
    }

    public static boolean isValidElectromagnet(ItemStack aMagnet) {
        return aMagnet != null && aMagnet.func_77973_b() instanceof MetaGeneratedItem01 && aMagnet.func_77960_j() >= 32345 && aMagnet.func_77960_j() <= 32349;
    }

    private boolean addMagHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity;
        if (aTileEntity != null && (aMetaTileEntity = aTileEntity.getMetaTileEntity()) instanceof MTEHatchMagnet) {
            ((MTEHatchMagnet)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            if (this.mMagHatch == null) {
                this.mMagHatch = (MTEHatchMagnet)aMetaTileEntity;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        boolean bl = this.batchMode = !this.batchMode;
        if (this.batchMode) {
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
        } else {
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
        }
        return true;
    }

    public static enum MagnetTiers {
        Iron(8, 0.8f, 1.1f, false),
        Steel(24, 0.75f, 1.25f, false),
        Neodymium(48, 0.7f, 1.5f, false),
        Samarium(96, 0.6f, 2.0f, false),
        Tengam(256, 0.5f, 2.5f, true);

        final int maxParallel;
        final float euModifier;
        final float speedBoost;
        final boolean supportsExotic;

        private MagnetTiers(int maxParallel, float euModifier, float speedBoost, boolean supportsExotic) {
            this.maxParallel = maxParallel;
            this.euModifier = euModifier;
            this.speedBoost = 1.0f / speedBoost;
            this.supportsExotic = supportsExotic;
        }

        public static String buildMagnetTooltip(MagnetTiers m) {
            String tooltip = "Used in Magnetic Flux Exhibitor/n " + EnumChatFormatting.LIGHT_PURPLE + "Speed: +" + Math.round(1.0f / m.speedBoost * 100.0f - 100.0f) + "%/n " + EnumChatFormatting.DARK_PURPLE + "EU Usage: " + Math.round(m.euModifier * 100.0f) + "%/n " + EnumChatFormatting.AQUA + "Parallel: " + m.maxParallel;
            if (m.supportsExotic) {
                tooltip = tooltip + "/n " + EnumChatFormatting.BOLD + EnumChatFormatting.GREEN + "Can Use Multiamp Hatches";
            }
            return tooltip;
        }
    }
}

