/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pollution;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.api.enums.Mods;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gregtech.common.pollution.PollutionConfig;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class PollutionTooltip {
    private static final String PRODUCES_POLLUTION_FORMAT = "Produces %d Pollution/Second";
    private static final String MULTI_POLLUTION_FORMAT = "A complete Multiblock produces %d Pollution/Second";

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void getTooltip(ItemTooltipEvent event) {
        String simpleName;
        if (event.itemStack == null) {
            return;
        }
        if (PollutionConfig.furnacesPollute) {
            String furnacePollution = String.format(PRODUCES_POLLUTION_FORMAT, PollutionConfig.furnacePollutionAmount);
            if (GTUtility.areStacksEqual(event.itemStack, new ItemStack(Blocks.field_150460_al)) || GTUtility.areStacksEqual(event.itemStack, GTModHandler.getModItem("IC2", "blockMachine", 1L, 1))) {
                event.toolTip.add(furnacePollution);
            }
            if (Mods.Thaumcraft.isModLoaded() && GTUtility.areStacksEqual(event.itemStack, GTModHandler.getModItem("Thaumcraft", "blockStoneDevice", 1L, 0))) {
                event.toolTip.add(furnacePollution);
            }
            if (Mods.ThaumicBases.isModLoaded() && GTUtility.areStacksEqual(event.itemStack, GTModHandler.getModItem("thaumicbases", "advAlchFurnace", 1L, 0))) {
                event.toolTip.add(furnacePollution);
            }
        }
        if (Mods.Railcraft.isModLoaded() && PollutionConfig.railcraftPollutes) {
            if (GTUtility.areStacksEqual(event.itemStack, GTModHandler.getModItem("Railcraft", "machine.beta", 1L, 5)) || GTUtility.areStacksEqual(event.itemStack, GTModHandler.getModItem("Railcraft", "machine.beta", 1L, 6))) {
                event.toolTip.add(String.format("Produces %d Pollution/Second per firebox", PollutionConfig.fireboxPollutionAmount));
            }
            if (GTUtility.areStacksEqual(event.itemStack, GTModHandler.getModItem("Railcraft", "cart.bore", 1L, 0))) {
                event.toolTip.add(String.format(PRODUCES_POLLUTION_FORMAT, PollutionConfig.tunnelBorePollutionAmount));
            }
            if (GTUtility.areStacksEqual(event.itemStack, GTModHandler.getModItem("Railcraft", "machine.alpha", 1L, 7))) {
                event.toolTip.add(String.format(MULTI_POLLUTION_FORMAT, PollutionConfig.cokeOvenPollutionAmount));
            }
            if (GTUtility.areStacksEqual(event.itemStack, GTModHandler.getModItem("Railcraft", "machine.alpha", 1L, 12))) {
                event.toolTip.add(String.format(MULTI_POLLUTION_FORMAT, PollutionConfig.advancedCokeOvenPollutionAmount));
            }
            if (GTUtility.areStacksEqual(event.itemStack, GTModHandler.getModItem("Railcraft", "machine.beta", 1L, 7))) {
                event.toolTip.add(String.format(PRODUCES_POLLUTION_FORMAT, PollutionConfig.hobbyistEnginePollutionAmount));
            }
        }
        if (Mods.GalacticraftCore.isModLoaded() && PollutionConfig.rocketsPollute && event.itemStack.func_77973_b() != null && (simpleName = event.itemStack.func_77973_b().getClass().getSimpleName()).contains("Rocket")) {
            for (char d : simpleName.toCharArray()) {
                if (!Character.isDigit(d)) continue;
                int tier = Character.getNumericValue(d);
                event.toolTip.add(String.format("Produces %d Pollution/Second when ignited", PollutionConfig.rocketPollutionAmount * tier / 100));
                event.toolTip.add(String.format("Produces %d Pollution/Second when flying", PollutionConfig.rocketPollutionAmount * tier));
                break;
            }
        }
    }
}

