/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import alexiil.mods.load.MinecraftDisplayer;
import alexiil.mods.load.ProgressDisplayer;
import cpw.mods.fml.common.ProgressManager;
import gregtech.GTMod;
import gregtech.api.enums.Materials;
import gregtech.common.GTProxy;
import gregtech.loaders.postload.GTPostLoad;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public class GTCLSCompat {
    private static Class cpwProgressBar;
    private static Field progressBarStep;

    private GTCLSCompat() {
    }

    private static <T> void registerAndReportProgression(String materialsType, Collection<T> materials, ProgressManager.ProgressBar progressBar, Function<T, Object> getName, Consumer<T> action) {
        int sizeStep = materials.size();
        long progressionReportsEvery = 100L;
        long bakingMsgEvery = 1000L;
        long nextProgressionReportAt = 0L;
        long nextBakingMsgAt = 0L;
        int currentStep = 0;
        for (T m : materials) {
            long now = System.currentTimeMillis();
            if (nextProgressionReportAt < now) {
                nextProgressionReportAt = now + 100L;
                String materialName = getName.apply(m).toString();
                try {
                    ProgressDisplayer.displayProgress((String)materialName, (float)((float)currentStep / (float)sizeStep));
                }
                catch (IOException e) {
                    GTMod.GT_FML_LOGGER.error("While updating progression", (Throwable)e);
                }
                try {
                    progressBarStep.set(progressBar, currentStep);
                }
                catch (IllegalAccessException iae) {
                    GTMod.GT_FML_LOGGER.error("While updating intermediate progression steps number", (Throwable)iae);
                }
                progressBar.step(materialName);
            }
            if (nextBakingMsgAt < now) {
                nextBakingMsgAt = now + 1000L;
                GTMod.GT_FML_LOGGER.info(String.format("%s - Baking: %d%%", materialsType, currentStep * 100 / sizeStep));
            }
            action.accept(m);
            ++currentStep;
        }
        GTMod.GT_FML_LOGGER.info(String.format("%s - Baking: Done", materialsType));
        try {
            progressBarStep.set(progressBar, currentStep);
        }
        catch (IllegalAccessException iae) {
            GTMod.GT_FML_LOGGER.error("While updating final progression steps number", (Throwable)iae);
        }
    }

    public static void stepMaterialsCLS(Collection<GTProxy.OreDictEventContainer> mEvents, ProgressManager.ProgressBar progressBar) {
        MinecraftDisplayer.isRegisteringGTmaterials = true;
        GTCLSCompat.registerAndReportProgression("GregTech materials", mEvents, progressBar, m -> m.mMaterial, GTProxy::registerRecipes);
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        MinecraftDisplayer.isRegisteringGTmaterials = false;
    }

    public static void doActualRegistrationCLS(ProgressManager.ProgressBar progressBar, Set<Materials> replacedVanillaItemsSet) {
        MinecraftDisplayer.isReplacingVanillaMaterials = true;
        GTCLSCompat.registerAndReportProgression("Vanilla materials", replacedVanillaItemsSet, progressBar, m -> m.mDefaultLocalName, GTPostLoad::doActualRegistration);
    }

    public static void pushToDisplayProgress() {
        MinecraftDisplayer.isReplacingVanillaMaterials = false;
        try {
            ProgressDisplayer.displayProgress((String)"Post Initialization: loading GregTech", (float)MinecraftDisplayer.getLastPercent());
        }
        catch (IOException e) {
            GTMod.GT_FML_LOGGER.error("Exception caught when updating loading screen", (Throwable)e);
        }
    }

    static {
        try {
            cpwProgressBar = Class.forName("cpw.mods.fml.common.ProgressManager$ProgressBar");
        }
        catch (ClassNotFoundException ex) {
            GTMod.GT_FML_LOGGER.catching((Throwable)ex);
        }
        try {
            progressBarStep = cpwProgressBar.getDeclaredField("step");
            progressBarStep.setAccessible(true);
        }
        catch (NoSuchFieldException ex) {
            GTMod.GT_FML_LOGGER.catching((Throwable)ex);
        }
    }
}

