/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GTConfig;
import gregtech.api.util.GTItsNotMyFaultException;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.BlockOresAbstract;
import gregtech.common.blocks.TileEntityOres;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropTile;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import speiger.src.crops.api.ICropCardInfo;

public class GTBaseCrop
extends CropCard
implements ICropCardInfo {
    public static ArrayList<GTBaseCrop> sCropList = new ArrayList();
    private String mName = "";
    private String mDiscoveredBy = "Gregorius Techneticies";
    private String[] mAttributes;
    private int mTier = 0;
    private int mMaxSize = 0;
    private int mAfterHarvestSize = 0;
    private int mHarvestSize = 0;
    private final int[] mStats = new int[5];
    private final int mGrowthSpeed = 0;
    private ItemStack mDrop = null;
    private ItemStack[] mSpecialDrops = null;
    private Materials mBlock = null;
    private static boolean bIc2NeiLoaded = Mods.IC2CropPlugin.isModLoaded();

    public GTBaseCrop(int aID, String aCropName, String aDiscoveredBy, ItemStack aBaseSeed, int aTier, int aMaxSize, int aGrowthSpeed, int aAfterHarvestSize, int aHarvestSize, int aStatChemical, int aStatFood, int aStatDefensive, int aStatColor, int aStatWeed, String[] aAttributes, ItemStack aDrop, ItemStack[] aSpecialDrops) {
        new GTBaseCrop(aID, aCropName, aDiscoveredBy, aBaseSeed, aTier, aMaxSize, aGrowthSpeed, aAfterHarvestSize, aHarvestSize, aStatChemical, aStatFood, aStatDefensive, aStatColor, aStatWeed, aAttributes, null, aDrop, aSpecialDrops);
    }

    public GTBaseCrop(int aID, String aCropName, String aDiscoveredBy, ItemStack aBaseSeed, int aTier, int aMaxSize, int aGrowthSpeed, int aAfterHarvestSize, int aHarvestSize, int aStatChemical, int aStatFood, int aStatDefensive, int aStatColor, int aStatWeed, String[] aAttributes, Materials aBlock, ItemStack aDrop, ItemStack[] aSpecialDrops) {
        this.mName = aCropName;
        GTLanguageManager.addStringLocalization("gt.crop." + this.mName + ".name", this.mName);
        aID = GTConfig.addIDConfig((Object)ConfigCategories.IDs.crops, this.mName.replaceAll(" ", "_"), aID);
        if (aDiscoveredBy != null && !aDiscoveredBy.equals("")) {
            this.mDiscoveredBy = aDiscoveredBy;
        }
        if (aDrop != null && aID > 0 && aID < 256) {
            this.mDrop = GTUtility.copyOrNull(aDrop);
            this.mSpecialDrops = aSpecialDrops;
            this.mTier = Math.max(1, aTier);
            this.mMaxSize = Math.max(3, aMaxSize);
            this.mHarvestSize = Math.min(Math.max(aHarvestSize, 2), this.mMaxSize);
            this.mAfterHarvestSize = Math.min(Math.max(aAfterHarvestSize, 1), this.mMaxSize - 1);
            this.mStats[0] = aStatChemical;
            this.mStats[1] = aStatFood;
            this.mStats[2] = aStatDefensive;
            this.mStats[3] = aStatColor;
            this.mStats[4] = aStatWeed;
            this.mAttributes = aAttributes;
            this.mBlock = aBlock;
            if (!Crops.instance.registerCrop((CropCard)this, aID)) {
                throw new GTItsNotMyFaultException("Make sure the Crop ID is valid!");
            }
            if (aBaseSeed != null) {
                Crops.instance.registerBaseSeed(aBaseSeed, (CropCard)this, 1, 1, 1, 1);
            }
            sCropList.add(this);
        }
        if (bIc2NeiLoaded) {
            try {
                Class.forName("speiger.src.crops.api.CropPluginAPI").getMethod("registerCropInfo", Class.forName("speiger.src.crops.api.ICropCardInfo")).invoke((Object)Class.forName("speiger.src.crops.api.CropPluginAPI").getField("instance"), this);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                bIc2NeiLoaded = false;
            }
        }
    }

    public byte getSizeAfterHarvest(ICropTile crop) {
        return (byte)this.mAfterHarvestSize;
    }

    public int growthDuration(ICropTile aCrop) {
        return super.growthDuration(aCrop);
    }

    public int getrootslength(ICropTile crop) {
        return 5;
    }

    public String[] attributes() {
        return this.mAttributes;
    }

    public String discoveredBy() {
        return this.mDiscoveredBy;
    }

    public final boolean canGrow(ICropTile aCrop) {
        if (this.needsBlockBelow() && aCrop.getSize() == this.mMaxSize - 1) {
            return this.isBlockBelow(aCrop);
        }
        return aCrop.getSize() < this.maxSize();
    }

    public final boolean canBeHarvested(ICropTile aCrop) {
        return aCrop.getSize() >= this.mHarvestSize;
    }

    public boolean canCross(ICropTile aCrop) {
        return aCrop.getSize() + 2 > this.maxSize();
    }

    public int stat(int n) {
        if (n < 0 || n >= this.mStats.length) {
            return 0;
        }
        return this.mStats[n];
    }

    public String name() {
        return this.mName;
    }

    public String displayName() {
        return GTLanguageManager.getTranslation("gt.crop." + this.mName + ".name");
    }

    public int tier() {
        return this.mTier;
    }

    public int maxSize() {
        return this.mMaxSize;
    }

    public ItemStack getGain(ICropTile aCrop) {
        int tDrop = 0;
        if (this.mSpecialDrops != null && (tDrop = ThreadLocalRandom.current().nextInt(0, this.mSpecialDrops.length * 2 + 2)) < this.mSpecialDrops.length && this.mSpecialDrops[tDrop] != null) {
            return GTUtility.copyOrNull(this.mSpecialDrops[tDrop]);
        }
        return GTUtility.copyOrNull(this.mDrop);
    }

    public boolean rightclick(ICropTile aCrop, EntityPlayer aPlayer) {
        if (!this.canBeHarvested(aCrop)) {
            return false;
        }
        return aCrop.harvest(aPlayer instanceof EntityPlayerMP);
    }

    public int getOptimalHavestSize(ICropTile crop) {
        return this.maxSize();
    }

    public boolean needsBlockBelow() {
        return GTMod.gregtechproxy.mCropNeedBlock && this.mBlock != null;
    }

    public boolean isBlockBelow(ICropTile aCrop) {
        if (aCrop == null) {
            return false;
        }
        for (int i = 1; i < this.getrootslength(aCrop); ++i) {
            Block tBlock = aCrop.getWorld().func_147439_a(aCrop.getLocation().field_71574_a, aCrop.getLocation().field_71572_b - i, aCrop.getLocation().field_71573_c);
            if (tBlock instanceof BlockOresAbstract) {
                Materials tMaterial;
                TileEntity tTileEntity = aCrop.getWorld().func_147438_o(aCrop.getLocation().field_71574_a, aCrop.getLocation().field_71572_b - i, aCrop.getLocation().field_71573_c);
                if (!(tTileEntity instanceof TileEntityOres) || (tMaterial = GregTechAPI.sGeneratedMaterials[((TileEntityOres)tTileEntity).mMetaData % 1000]) == null || tMaterial == Materials._NULL) continue;
                return tMaterial == this.mBlock;
            }
            int tMetaID = aCrop.getWorld().func_72805_g(aCrop.getLocation().field_71574_a, aCrop.getLocation().field_71572_b - i, aCrop.getLocation().field_71573_c);
            if (!this.isBlockBelow(new ItemStack(tBlock, 1, tMetaID))) continue;
            return true;
        }
        return false;
    }

    public boolean isBlockBelow(ItemStack aItem) {
        if (!this.needsBlockBelow()) {
            return true;
        }
        ItemData tAssociation = GTOreDictUnificator.getAssociation(aItem);
        if (tAssociation == null) {
            return false;
        }
        if (tAssociation.mPrefix.toString().startsWith("ore") && tAssociation.mMaterial.mMaterial == this.mBlock) {
            return true;
        }
        return tAssociation.mPrefix == OrePrefixes.block && tAssociation.mMaterial.mMaterial == this.mBlock;
    }

    @Override
    public List<String> getCropInformation() {
        if (this.mBlock != null) {
            ArrayList<String> result = new ArrayList<String>(1);
            result.add(String.format("Requires %s Ore or Block of %s as soil block to reach full growth.", this.mBlock.mName, this.mBlock.mName));
            return result;
        }
        return null;
    }

    @Override
    public ItemStack getDisplayItem() {
        if (this.mSpecialDrops != null && this.mSpecialDrops[this.mSpecialDrops.length - 1] != null) {
            return GTUtility.copyOrNull(this.mSpecialDrops[this.mSpecialDrops.length - 1]);
        }
        return GTUtility.copyOrNull(this.mDrop);
    }
}

