/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.metatileentity.CoverableTileEntity;
import gregtech.api.net.GTPacket;
import gregtech.api.net.GTPacketTypes;
import gregtech.common.covers.CoverInfo;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class GTPacketRequestCoverData
extends GTPacket {
    protected int mX;
    protected short mY;
    protected int mZ;
    protected ForgeDirection side;
    protected int coverID;
    protected EntityPlayerMP mPlayer;

    public GTPacketRequestCoverData() {
    }

    public GTPacketRequestCoverData(CoverInfo info, ICoverable tile) {
        this.mX = tile.getXCoord();
        this.mY = tile.getYCoord();
        this.mZ = tile.getZCoord();
        this.side = info.getSide();
        this.coverID = info.getCoverID();
    }

    public GTPacketRequestCoverData(int mX, short mY, int mZ, ForgeDirection coverSide, int coverID) {
        this.mX = mX;
        this.mY = mY;
        this.mZ = mZ;
        this.side = coverSide;
        this.coverID = coverID;
    }

    public GTPacketRequestCoverData(ForgeDirection coverSide, int coverID, ICoverable tile) {
        this.mX = tile.getXCoord();
        this.mY = tile.getYCoord();
        this.mZ = tile.getZCoord();
        this.side = coverSide;
        this.coverID = coverID;
    }

    @Override
    public byte getPacketID() {
        return GTPacketTypes.REQUEST_COVER_DATA.id;
    }

    @Override
    public void encode(ByteBuf aOut) {
        aOut.writeInt(this.mX);
        aOut.writeShort((int)this.mY);
        aOut.writeInt(this.mZ);
        aOut.writeByte(this.side.ordinal());
        aOut.writeInt(this.coverID);
    }

    @Override
    public GTPacket decode(ByteArrayDataInput aData) {
        return new GTPacketRequestCoverData(aData.readInt(), aData.readShort(), aData.readInt(), ForgeDirection.getOrientation((int)aData.readByte()), aData.readInt());
    }

    @Override
    public void setINetHandler(INetHandler aHandler) {
        if (aHandler instanceof NetHandlerPlayServer) {
            this.mPlayer = ((NetHandlerPlayServer)aHandler).field_147369_b;
        }
    }

    @Override
    public void process(IBlockAccess aWorld) {
        CoverableTileEntity te;
        TileEntity tile;
        if (this.mPlayer == null) {
            return;
        }
        WorldServer world = DimensionManager.getWorld((int)this.mPlayer.field_71093_bK);
        if (world != null && (tile = world.func_147438_o(this.mX, (int)this.mY, this.mZ)) instanceof CoverableTileEntity && !(te = (CoverableTileEntity)tile).isDead() && te.getCoverIDAtSide(this.side) == this.coverID) {
            te.issueCoverUpdate(this.side);
        }
    }
}

