/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.multiblock.base;

import gregtech.api.logic.MuTEProcessingLogic;
import gregtech.api.multitileentity.interfaces.UpgradableModularMuTE;
import gregtech.api.multitileentity.multiblock.base.StackableController;
import gregtech.api.util.GT_StructureUtilityMuTE;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class StackableModularController<C extends StackableModularController<C, P>, P extends MuTEProcessingLogic<P>>
extends StackableController<C, P>
implements UpgradableModularMuTE {
    protected double durationMultiplier = 1.0;
    protected double euTickMultiplier = 1.0;
    private Map<GT_StructureUtilityMuTE.UpgradeCasings, int[]> mucMap;

    @NotNull
    protected Map<GT_StructureUtilityMuTE.UpgradeCasings, int[]> getMucMap() {
        if (this.mucMap == null) {
            this.mucMap = StackableModularController.createMucMap();
        }
        return this.mucMap;
    }

    @NotNull
    protected static Map<GT_StructureUtilityMuTE.UpgradeCasings, int[]> createMucMap() {
        HashMap<GT_StructureUtilityMuTE.UpgradeCasings, int[]> mucCount = new HashMap<GT_StructureUtilityMuTE.UpgradeCasings, int[]>();
        mucCount.put(GT_StructureUtilityMuTE.UpgradeCasings.Heater, new int[]{0, 0, 0, 0, 0});
        mucCount.put(GT_StructureUtilityMuTE.UpgradeCasings.Insulator, new int[]{0, 0, 0, 0, 0});
        return mucCount;
    }

    @Override
    public void increaseMucCount(GT_StructureUtilityMuTE.UpgradeCasings casingType, int tier) {
        Map<GT_StructureUtilityMuTE.UpgradeCasings, int[]> mucCounters = this.getMucMap();
        int[] casingCount = mucCounters.get((Object)casingType);
        switch (tier) {
            case 0: 
            case 1: 
            case 2: {
                casingCount[0] = casingCount[0] + 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                casingCount[1] = casingCount[1] + 1;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                casingCount[2] = casingCount[2] + 1;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                casingCount[3] = casingCount[3] + 1;
                break;
            }
            default: {
                casingCount[4] = casingCount[4] + 1;
            }
        }
    }

    @Override
    public void resetMucCount() {
        Map<GT_StructureUtilityMuTE.UpgradeCasings, int[]> mucCounters = this.getMucMap();
        mucCounters.forEach((type, casingCount) -> Arrays.fill(casingCount, 0));
    }

    protected abstract GT_StructureUtilityMuTE.UpgradeCasings getBaseMucType();

    protected abstract int getParallelFactor();

    protected void calculateParallels() {
        int parallelCount = 0;
        int parallelFactor = this.getParallelFactor();
        int[] parallelCasingList = this.mucMap.get((Object)this.getBaseMucType());
        for (int i = 0; i < 5; ++i) {
            if (i * 3 + 1 > this.tier) continue;
            parallelCount += parallelCasingList[i] * (i + 1) * parallelFactor;
        }
        this.maxParallel = parallelCount == 0 ? 1 : parallelCount;
    }

    protected abstract boolean calculateMucMultipliers();
}

