/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.list.array.TIntArrayList;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IConnectable;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IColoredTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.objects.GTItemStack;
import gregtech.api.util.CoverBehavior;
import gregtech.api.util.CoverBehaviorBase;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTUtil;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ISerializableObject;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.common.GTClient;
import gregtech.common.covers.CoverInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public abstract class MetaPipeEntity
implements IMetaTileEntity,
IConnectable {
    public final ItemStack[] mInventory;
    public byte mConnections = 0;
    protected boolean mCheckConnections = false;
    public String mName;
    public boolean doTickProfilingInThisTick = true;
    private IGregTechTileEntity mBaseMetaTileEntity;

    public MetaPipeEntity(int aID, String aBasicName, String aRegionalName, int aInvSlotCount) {
        this(aID, aBasicName, aRegionalName, aInvSlotCount, true);
    }

    public MetaPipeEntity(int aID, String aBasicName, String aRegionalName, int aInvSlotCount, boolean aAddInfo) {
        if (GregTechAPI.sPostloadStarted || !GregTechAPI.sPreloadStarted) {
            throw new IllegalAccessError("This Constructor has to be called in the load Phase");
        }
        if (GregTechAPI.METATILEENTITIES[aID] != null) {
            throw new IllegalArgumentException("MetaMachine-Slot Nr. " + aID + " is already occupied!");
        }
        GregTechAPI.METATILEENTITIES[aID] = this;
        this.mName = aBasicName.replaceAll(" ", "_").toLowerCase(Locale.ENGLISH);
        this.setBaseMetaTileEntity(new BaseMetaPipeEntity());
        this.getBaseMetaTileEntity().setMetaTileID((short)aID);
        GTLanguageManager.addStringLocalization("gt.blockmachines." + this.mName + ".name", aRegionalName);
        this.mInventory = new ItemStack[aInvSlotCount];
        if (aAddInfo && GTValues.GT.isClientSide()) {
            this.addInfo(aID);
        }
    }

    protected final void addInfo(int aID) {
        if (!GTValues.GT.isClientSide()) {
            return;
        }
        ItemStack tStack = new ItemStack(GregTechAPI.sBlockMachines, 1, aID);
        Objects.requireNonNull(tStack.func_77973_b()).func_77624_a(tStack, null, new ArrayList(), true);
    }

    public MetaPipeEntity(String aName, int aInvSlotCount) {
        this.mInventory = new ItemStack[aInvSlotCount];
        this.mName = aName;
    }

    public abstract float getThickNess();

    public abstract boolean renderInside(ForgeDirection var1);

    public boolean isDisplaySecondaryDescription() {
        return false;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        return Textures.BlockIcons.ERROR_RENDERING;
    }

    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, int connections, int colorIndex, boolean active, boolean redstoneLevel) {
        return Textures.BlockIcons.ERROR_RENDERING;
    }

    @Override
    public IGregTechTileEntity getBaseMetaTileEntity() {
        return this.mBaseMetaTileEntity;
    }

    @Override
    public void setBaseMetaTileEntity(IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.mBaseMetaTileEntity != null && aBaseMetaTileEntity == null) {
            this.mBaseMetaTileEntity.getMetaTileEntity().inValidate();
            this.mBaseMetaTileEntity.setMetaTileEntity(null);
        }
        this.mBaseMetaTileEntity = aBaseMetaTileEntity;
        if (this.mBaseMetaTileEntity != null) {
            this.mBaseMetaTileEntity.setMetaTileEntity(this);
        }
    }

    @Override
    public ItemStack getStackForm(long aAmount) {
        return new ItemStack(GregTechAPI.sBlockMachines, (int)aAmount, this.getBaseMetaTileEntity().getMetaTileID());
    }

    public boolean isCoverOnSide(BaseMetaPipeEntity aPipe, EntityLivingBase aEntity) {
        boolean tCovered;
        ForgeDirection side = ForgeDirection.UNKNOWN;
        double difference = aEntity.field_70163_u - (double)aPipe.field_145848_d;
        if (difference > 0.6 && difference < 0.99) {
            side = ForgeDirection.UP;
        }
        if (difference < -1.5 && difference > -1.99) {
            side = ForgeDirection.DOWN;
        }
        if ((difference = aEntity.field_70161_v - (double)aPipe.field_145849_e) < -0.05 && difference > -0.4) {
            side = ForgeDirection.NORTH;
        }
        if (difference > 1.05 && difference < 1.4) {
            side = ForgeDirection.SOUTH;
        }
        if ((difference = aEntity.field_70165_t - (double)aPipe.field_145851_c) < -0.05 && difference > -0.4) {
            side = ForgeDirection.WEST;
        }
        if (difference > 1.05 && difference < 1.4) {
            side = ForgeDirection.EAST;
        }
        boolean bl = tCovered = side != ForgeDirection.UNKNOWN && this.mBaseMetaTileEntity.getCoverIDAtSide(side) > 0;
        if (this.isConnectedAtSide(side)) {
            tCovered = true;
        }
        return tCovered;
    }

    @Override
    public void onServerStart() {
    }

    @Override
    public void onWorldSave(File aSaveDirectory) {
    }

    @Override
    public void onWorldLoad(File aSaveDirectory) {
    }

    @Override
    public void onConfigLoad() {
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
    }

    @Override
    public boolean allowCoverOnSide(ForgeDirection side, GTItemStack aCoverID) {
        return true;
    }

    @Deprecated
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
    }

    @Deprecated
    public boolean onWrenchRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer entityPlayer, float aX, float aY, float aZ) {
        return false;
    }

    @Deprecated
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return false;
    }

    @Deprecated
    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return false;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        this.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ);
    }

    @Override
    public boolean onWrenchRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        return this.onWrenchRightClick(side, wrenchingSide, aPlayer, aX, aY, aZ);
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        return this.onWireCutterRightClick(side, wrenchingSide, aPlayer, aX, aY, aZ);
    }

    @Override
    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        return this.onSolderingToolRightClick(side, wrenchingSide, aPlayer, aX, aY, aZ);
    }

    @Override
    public void onExplosion() {
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isClientSide() && GTClient.changeDetected == 4) {
            aBaseMetaTileEntity.issueTextureUpdate();
        }
    }

    @Override
    public void inValidate() {
    }

    @Override
    public void onRemoval() {
    }

    @Override
    public void initDefaultModes(NBTTagCompound aNBT) {
    }

    public void onOpenGUI() {
    }

    public void onCloseGUI() {
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        return false;
    }

    @Override
    public void onLeftclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
    }

    @Override
    public void onValueUpdate(byte aValue) {
    }

    @Override
    public byte getUpdateData() {
        return 0;
    }

    @Override
    public void doSound(byte aIndex, double aX, double aY, double aZ) {
    }

    @Override
    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
    }

    @Override
    public void stopSoundLoop(byte aValue, double aX, double aY, double aZ) {
    }

    @Override
    public final void sendSound(byte aIndex) {
        if (!this.getBaseMetaTileEntity().hasMufflerUpgrade()) {
            this.getBaseMetaTileEntity().sendBlockEvent((byte)4, aIndex);
        }
    }

    @Override
    public final void sendLoopStart(byte aIndex) {
        if (!this.getBaseMetaTileEntity().hasMufflerUpgrade()) {
            this.getBaseMetaTileEntity().sendBlockEvent((byte)5, aIndex);
        }
    }

    @Override
    public final void sendLoopEnd(byte aIndex) {
        if (!this.getBaseMetaTileEntity().hasMufflerUpgrade()) {
            this.getBaseMetaTileEntity().sendBlockEvent((byte)6, aIndex);
        }
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return false;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public boolean shouldDropItemAt(int index) {
        return true;
    }

    @Override
    public boolean setStackToZeroInsteadOfNull(int aIndex) {
        return false;
    }

    @Override
    public ArrayList<String> getSpecialDebugInfo(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, int aLogLevel, ArrayList<String> aList) {
        return aList;
    }

    @Override
    public boolean isLiquidInput(ForgeDirection side) {
        return false;
    }

    @Override
    public boolean isLiquidOutput(ForgeDirection side) {
        return false;
    }

    public FluidStack getFluid() {
        return null;
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    public int getTankPressure() {
        return 0;
    }

    public int getCapacity() {
        return 0;
    }

    public int getProgresstime() {
        return 0;
    }

    public int maxProgresstime() {
        return 0;
    }

    public int increaseProgress(int aProgress) {
        return 0;
    }

    @Override
    public void onMachineBlockUpdate() {
    }

    @Override
    public void receiveClientEvent(byte aEventID, byte aValue) {
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public byte getComparatorValue(ForgeDirection side) {
        return 0;
    }

    @Override
    public boolean acceptsRotationalEnergy(ForgeDirection side) {
        return false;
    }

    @Override
    public boolean injectRotationalEnergy(ForgeDirection side, long aSpeed, long aEnergy) {
        return false;
    }

    @Override
    public String getSpecialVoltageToolTip() {
        return null;
    }

    @Override
    public boolean isGivingInformation() {
        return false;
    }

    @Override
    public String[] getInfoData() {
        return new String[0];
    }

    public boolean isDigitalChest() {
        return false;
    }

    public ItemStack[] getStoredItemData() {
        return null;
    }

    public void setItemCount(int aCount) {
    }

    public int getMaxItemCount() {
        return 0;
    }

    public int func_70302_i_() {
        return this.mInventory.length;
    }

    public ItemStack func_70301_a(int slotIndex) {
        if (slotIndex >= 0 && slotIndex < this.mInventory.length) {
            return this.mInventory[slotIndex];
        }
        return null;
    }

    public void func_70299_a(int aIndex, ItemStack aStack) {
        if (aIndex >= 0 && aIndex < this.mInventory.length) {
            this.mInventory[aIndex] = aStack;
        }
    }

    public String func_145825_b() {
        if (GregTechAPI.METATILEENTITIES[this.getBaseMetaTileEntity().getMetaTileID()] != null) {
            return GregTechAPI.METATILEENTITIES[this.getBaseMetaTileEntity().getMetaTileID()].getMetaName();
        }
        return "";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int aIndex, ItemStack aStack) {
        return this.getBaseMetaTileEntity().isValidSlot(aIndex);
    }

    public ItemStack func_70298_a(int aIndex, int aAmount) {
        ItemStack tStack = this.func_70301_a(aIndex);
        ItemStack rStack = GTUtility.copyOrNull(tStack);
        if (tStack != null) {
            if (tStack.field_77994_a <= aAmount) {
                if (this.setStackToZeroInsteadOfNull(aIndex)) {
                    tStack.field_77994_a = 0;
                } else {
                    this.func_70299_a(aIndex, null);
                }
            } else {
                rStack = tStack.func_77979_a(aAmount);
                if (tStack.field_77994_a == 0 && !this.setStackToZeroInsteadOfNull(aIndex)) {
                    this.func_70299_a(aIndex, null);
                }
            }
        }
        return rStack;
    }

    public int[] func_94128_d(int ordinalSide) {
        TIntArrayList tList = new TIntArrayList();
        IGregTechTileEntity tTileEntity = this.getBaseMetaTileEntity();
        CoverInfo tileCoverInfo = tTileEntity.getCoverInfoAtSide(ForgeDirection.getOrientation((int)ordinalSide));
        boolean tSkip = tileCoverInfo.letsItemsIn(-2) || tileCoverInfo.letsItemsOut(-2);
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!this.isValidSlot(i) || !tSkip && !tileCoverInfo.letsItemsOut(i) && !tileCoverInfo.letsItemsIn(i)) continue;
            tList.add(i);
        }
        return tList.toArray();
    }

    public boolean func_102007_a(int slotIndex, ItemStack itemStack, int ordinalSide) {
        return this.isValidSlot(slotIndex) && itemStack != null && slotIndex < this.mInventory.length && (this.mInventory[slotIndex] == null || GTUtility.areStacksEqual(itemStack, this.mInventory[slotIndex])) && this.allowPutStack(this.getBaseMetaTileEntity(), slotIndex, ForgeDirection.getOrientation((int)ordinalSide), itemStack);
    }

    public boolean func_102008_b(int slotIndex, ItemStack itemStack, int ordinalSide) {
        return this.isValidSlot(slotIndex) && itemStack != null && slotIndex < this.mInventory.length && this.allowPullStack(this.getBaseMetaTileEntity(), slotIndex, ForgeDirection.getOrientation((int)ordinalSide), itemStack);
    }

    public boolean canFill(ForgeDirection side, Fluid aFluid) {
        return this.fill(side, new FluidStack(aFluid, 1), false) == 1;
    }

    public boolean canDrain(ForgeDirection side, Fluid aFluid) {
        return this.drain(side, new FluidStack(aFluid, 1), false) != null;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection side) {
        if (this.getCapacity() <= 0 && !this.getBaseMetaTileEntity().hasSteamEngineUpgrade()) {
            return new FluidTankInfo[0];
        }
        return new FluidTankInfo[]{this.getInfo()};
    }

    public int fill_default(ForgeDirection side, FluidStack aFluid, boolean doFill) {
        return this.fill(aFluid, doFill);
    }

    public int fill(ForgeDirection side, FluidStack aFluid, boolean doFill) {
        return this.fill_default(side, aFluid, doFill);
    }

    public FluidStack drain(ForgeDirection side, FluidStack aFluid, boolean doDrain) {
        if (this.getFluid() != null && aFluid != null && this.getFluid().isFluidEqual(aFluid)) {
            return this.drain(aFluid.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection side, int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    public int getFluidAmount() {
        return 0;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    @Override
    public String getMetaName() {
        return this.mName;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    @Override
    public boolean doTickProfilingMessageDuringThisTick() {
        return this.doTickProfilingInThisTick;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    @Override
    public boolean connectsToItemPipe(ForgeDirection side) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public float getExplosionResistance(ForgeDirection side) {
        return (this.mConnections & 0xC0) != 0 ? 50.0f : 5.0f;
    }

    @Override
    public ItemStack[] getRealInventory() {
        return this.mInventory;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70296_d() {
    }

    @Override
    public void onColorChangeServer(byte aColor) {
        this.setCheckConnections();
    }

    @Override
    public void onColorChangeClient(byte aColor) {
    }

    public void setCheckConnections() {
        this.mCheckConnections = true;
    }

    public long injectEnergyUnits(ForgeDirection side, long aVoltage, long aAmperage) {
        return 0L;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderInInventory(Block aBlock, int aMeta, RenderBlocks aRenderer) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderInWorld(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, RenderBlocks aRenderer) {
        return false;
    }

    @Override
    public void doExplosion(long aExplosionPower) {
        float tStrength = GTValues.getExplosionPowerForVoltage(aExplosionPower);
        int tX = this.getBaseMetaTileEntity().getXCoord();
        short tY = this.getBaseMetaTileEntity().getYCoord();
        int tZ = this.getBaseMetaTileEntity().getZCoord();
        World tWorld = this.getBaseMetaTileEntity().getWorld();
        tWorld.func_147449_b(tX, (int)tY, tZ, Blocks.field_150350_a);
        if (GregTechAPI.sMachineExplosions) {
            new WorldSpawnedEventBuilder.ExplosionEffectEventBuilder().setStrength(tStrength).setSmoking(true).setPosition((double)tX + 0.5, (double)tY + 0.5, (double)tZ + 0.5).setWorld(tWorld).run();
        }
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    @Override
    public void addCollisionBoxesToList(World aWorld, int aX, int aY, int aZ, AxisAlignedBB inputAABB, List<AxisAlignedBB> outputAABB, Entity collider) {
        AxisAlignedBB axisalignedbb1 = this.getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ);
        if (axisalignedbb1 != null && inputAABB.func_72326_a(axisalignedbb1)) {
            outputAABB.add(axisalignedbb1);
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        return AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1));
    }

    @Override
    public void onEntityCollidedWithBlock(World aWorld, int aX, int aY, int aZ, Entity collider) {
    }

    @Override
    public void onCreated(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
    }

    @Override
    public boolean allowGeneralRedstoneOutput() {
        return false;
    }

    @Override
    public boolean hasAlternativeModeText() {
        return false;
    }

    @Override
    public String getAlternativeModeText() {
        return "";
    }

    protected boolean connectableColor(TileEntity tTileEntity) {
        if (tTileEntity instanceof IColoredTileEntity && this.getBaseMetaTileEntity().getColorization() >= 0) {
            byte tColor = ((IColoredTileEntity)tTileEntity).getColorization();
            return tColor < 0 || tColor == this.getBaseMetaTileEntity().getColorization();
        }
        return true;
    }

    @Override
    public int connect(ForgeDirection side) {
        if (side == ForgeDirection.UNKNOWN) {
            return 0;
        }
        ForgeDirection oppositeSide = side.getOpposite();
        IGregTechTileEntity baseMetaTile = this.getBaseMetaTileEntity();
        if (baseMetaTile == null || !baseMetaTile.isServerSide()) {
            return 0;
        }
        CoverInfo coverInfo = baseMetaTile.getCoverInfoAtSide(side);
        boolean alwaysLookConnected = coverInfo.alwaysLookConnected();
        boolean letsIn = this.letsIn(coverInfo);
        boolean letsOut = this.letsOut(coverInfo);
        TileEntity tTileEntity = baseMetaTile.getTileEntityAtSide(side);
        if (!this.connectableColor(tTileEntity)) {
            return 0;
        }
        if (alwaysLookConnected || letsIn || letsOut) {
            IMetaTileEntity tPipe;
            IMetaTileEntity iMetaTileEntity = tPipe = tTileEntity instanceof IGregTechTileEntity ? ((IGregTechTileEntity)tTileEntity).getMetaTileEntity() : null;
            if (this.getClass().isInstance(tPipe) || tPipe != null && tPipe.getClass().isInstance(this)) {
                this.connectAtSide(side);
                if (!((IConnectable)((Object)tPipe)).isConnectedAtSide(oppositeSide)) {
                    ((IConnectable)((Object)tPipe)).connect(oppositeSide);
                }
                return 1;
            }
            if (this.getGT6StyleConnection() && baseMetaTile.getAirAtSide(side) || this.canConnect(side, tTileEntity)) {
                this.connectAtSide(side);
                return 1;
            }
            if (!baseMetaTile.getWorld().func_72863_F().func_73149_a(baseMetaTile.getOffsetX(side, 1) >> 4, baseMetaTile.getOffsetZ(side, 1) >> 4)) {
                return -1;
            }
        }
        return 0;
    }

    protected void checkConnections() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (this.getGT6StyleConnection() && !this.isConnectedAtSide(side) || this.connect(side) != 0) continue;
            this.disconnect(side);
        }
        this.mCheckConnections = false;
    }

    private void connectAtSide(ForgeDirection side) {
        this.mConnections = (byte)(this.mConnections | side.flag);
    }

    @Override
    public void disconnect(ForgeDirection side) {
        IMetaTileEntity tPipe;
        if (side == ForgeDirection.UNKNOWN) {
            return;
        }
        this.mConnections = (byte)(this.mConnections & ~side.flag);
        ForgeDirection oppositeSide = side.getOpposite();
        IGregTechTileEntity tTileEntity = this.getBaseMetaTileEntity().getIGregTechTileEntityAtSide(side);
        IMetaTileEntity iMetaTileEntity = tPipe = tTileEntity == null ? null : tTileEntity.getMetaTileEntity();
        if ((this.getClass().isInstance(tPipe) || tPipe != null && tPipe.getClass().isInstance(this)) && ((IConnectable)((Object)tPipe)).isConnectedAtSide(oppositeSide)) {
            ((IConnectable)((Object)tPipe)).disconnect(oppositeSide);
        }
    }

    @Override
    public boolean isConnectedAtSide(ForgeDirection sideDirection) {
        return (this.mConnections & sideDirection.flag) != 0;
    }

    public boolean letsIn(CoverBehavior coverBehavior, ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    public boolean letsIn(CoverInfo coverInfo) {
        return false;
    }

    public boolean letsOut(CoverBehavior coverBehavior, ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    public boolean letsOut(CoverInfo coverInfo) {
        return false;
    }

    public boolean letsIn(CoverBehaviorBase<?> coverBehavior, ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    public boolean letsOut(CoverBehaviorBase<?> coverBehavior, ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    public boolean canConnect(ForgeDirection side, TileEntity tTileEntity) {
        return false;
    }

    public boolean getGT6StyleConnection() {
        return false;
    }

    @Override
    public boolean shouldJoinIc2Enet() {
        return false;
    }

    @Override
    public boolean isMachineBlockUpdateRecursive() {
        return false;
    }

    public void reloadLocks() {
    }

    @Override
    public int getGUIColorization() {
        Dyes dye = Dyes.dyeWhite;
        if (GregTechAPI.sColoredGUI) {
            if (GregTechAPI.sMachineMetalGUI) {
                dye = Dyes.MACHINE_METAL;
            } else if (this.getBaseMetaTileEntity() != null) {
                dye = Dyes.getDyeFromIndex(this.getBaseMetaTileEntity().getColorization());
            }
        }
        return GTUtil.getRGBInt(dye.getRGBA());
    }
}

