/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.logic.interfaces;

import com.google.common.primitives.Ints;
import gregtech.api.enums.InventoryType;
import gregtech.api.logic.FluidInventoryLogic;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public interface FluidInventoryLogicHost
extends IFluidHandler {
    @Nullable
    public FluidInventoryLogic getFluidLogic(@Nonnull ForgeDirection var1, @Nonnull InventoryType var2);

    @Nonnull
    default public FluidInventoryLogic getFluidLogic(@Nonnull InventoryType type, @Nullable UUID id) {
        return Objects.requireNonNull(this.getFluidLogic(ForgeDirection.UNKNOWN, type));
    }

    @Nonnull
    default public Set<Map.Entry<UUID, FluidInventoryLogic>> getAllFluidInventoryLogics(@Nonnull InventoryType type) {
        return new HashSet<Map.Entry<UUID, FluidInventoryLogic>>();
    }

    default public boolean canDrain(@Nonnull ForgeDirection from, Fluid fluid) {
        FluidInventoryLogic logic = this.getFluidLogic(from, InventoryType.Output);
        return logic != null;
    }

    default public boolean canFill(@Nonnull ForgeDirection from, Fluid fluid) {
        FluidInventoryLogic logic = this.getFluidLogic(from, InventoryType.Input);
        return logic != null;
    }

    @Nullable
    default public FluidStack drain(@Nonnull ForgeDirection from, @Nonnull FluidStack resource, boolean doDrain) {
        FluidInventoryLogic logic = this.getFluidLogic(from, InventoryType.Output);
        if (logic == null) {
            return null;
        }
        return logic.drain(resource.getFluid(), resource.amount, !doDrain);
    }

    @Nullable
    default public FluidStack drain(@Nonnull ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidInventoryLogic logic = this.getFluidLogic(from, InventoryType.Output);
        if (logic == null) {
            return null;
        }
        return logic.drain(maxDrain, !doDrain);
    }

    default public int fill(@Nonnull ForgeDirection from, @Nonnull FluidStack resource, boolean doFill) {
        FluidInventoryLogic logic = this.getFluidLogic(from, InventoryType.Input);
        if (logic == null) {
            return 0;
        }
        return Ints.saturatedCast((long)logic.fill(resource.getFluid(), resource.amount, !doFill));
    }

    @Nullable
    default public FluidTankInfo[] getTankInfo(@Nonnull ForgeDirection from) {
        return null;
    }
}

