/*
 * Decompiled with CFR 0.152.
 */
package galacticgreg.api;

import galacticgreg.api.AsteroidBlockComb;
import galacticgreg.api.Enums;
import galacticgreg.api.GTOreTypes;
import galacticgreg.api.ISpaceObjectGenerator;
import galacticgreg.api.ModDBMDef;
import galacticgreg.api.SpecialBlockComb;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.chunk.IChunkProvider;

public class ModDimensionDef {
    private static final String STR_NOTDEFINED = "iiznotdefined";
    private final String _mDimensionName;
    private String _mInternalDimIdentifier = "iiznotdefined";
    private final String _mChunkProvider;
    private Enums.AirReplaceRule _mDimAirSetting;
    private final ArrayList<ModDBMDef> _mReplaceableBlocks;
    private Enums.DimensionType _mDimensionType;
    private final List<ISpaceObjectGenerator> _mSpaceObjectsGenerators;
    private final List<ISpaceObjectGenerator> _mSpaceStructureGenerators;
    private int _mGroundOreMaxY = 64;
    private int _mFloatingAsteroidsMinY = 128;
    private GTOreTypes _mStoneType;
    private final List<AsteroidBlockComb> _mValidAsteroidMaterials;
    private final List<SpecialBlockComb> _mSpecialBlocksForAsteroids;
    private final Random _mRandom = new Random(System.currentTimeMillis());

    public List<AsteroidBlockComb> getValidAsteroidMaterials() {
        return this._mValidAsteroidMaterials;
    }

    public int getPreConfiguratedGroundOreMaxY() {
        return this._mGroundOreMaxY;
    }

    public int getPreConfiguratedFloatingAsteroidMinY() {
        return this._mFloatingAsteroidsMinY;
    }

    public void registerSpaceObjectGenerator(ISpaceObjectGenerator pSpaceObjectGenerator) {
        Enums.SpaceObjectType tType = pSpaceObjectGenerator.getType();
        switch (tType) {
            case NonOreSchematic: {
                this._mSpaceStructureGenerators.add(pSpaceObjectGenerator);
                break;
            }
            case OreAsteroid: {
                this._mSpaceObjectsGenerators.add(pSpaceObjectGenerator);
                break;
            }
        }
    }

    public ISpaceObjectGenerator getRandomSOGenerator(Enums.SpaceObjectType pTargetType) {
        ISpaceObjectGenerator tGen = null;
        List<ISpaceObjectGenerator> tLst = null;
        try {
            switch (pTargetType) {
                case NonOreSchematic: {
                    tLst = this._mSpaceStructureGenerators;
                    break;
                }
                case OreAsteroid: {
                    tLst = this._mSpaceObjectsGenerators;
                    break;
                }
            }
            if (tLst != null) {
                if (tLst.size() == 1) {
                    tGen = tLst.get(0);
                } else if (tLst.size() > 1) {
                    tGen = tLst.get(this._mRandom.nextInt(tLst.size()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tGen;
    }

    public void setAsteroidAndPlanetLimits(int pOregenMaxY, int pAsteroidMinY) {
        if (pOregenMaxY >= pAsteroidMinY) {
            throw new IllegalArgumentException("pOregenMaxY must be LOWER than pAsteroidMinY!");
        }
        this._mFloatingAsteroidsMinY = pAsteroidMinY;
        this._mGroundOreMaxY = pOregenMaxY;
    }

    public List<SpecialBlockComb> getSpecialBlocksForAsteroids() {
        return this._mSpecialBlocksForAsteroids;
    }

    public List<ISpaceObjectGenerator> getSpaceObjectGenerators() {
        return this._mSpaceObjectsGenerators;
    }

    public Enums.DimensionType getDimensionType() {
        return this._mDimensionType;
    }

    public void setDimensionType(Enums.DimensionType pType) {
        this._mDimensionType = pType;
    }

    public Enums.AirReplaceRule getAirSetting() {
        return this._mDimAirSetting;
    }

    public void setAirSetting(Enums.AirReplaceRule pSetting) {
        this._mDimAirSetting = pSetting;
    }

    public String getDimIdentifier() {
        return this._mInternalDimIdentifier;
    }

    public void setStoneType(GTOreTypes pStoneType) {
        this._mStoneType = pStoneType;
    }

    public GTOreTypes getStoneType() {
        return this._mStoneType;
    }

    public String getChunkProviderName() {
        return this._mChunkProvider;
    }

    public boolean addBlockDefinition(ModDBMDef pBlockDef) {
        if (this._mReplaceableBlocks.contains(pBlockDef)) {
            return false;
        }
        this._mReplaceableBlocks.add(pBlockDef);
        return true;
    }

    public String getDimensionName() {
        return this._mDimensionName;
    }

    public ArrayList<ModDBMDef> getReplaceableBlocks() {
        return this._mReplaceableBlocks;
    }

    public ModDimensionDef(String pDimensionName, Class<? extends IChunkProvider> pChunkProvider, Enums.DimensionType pDimType) {
        this(pDimensionName, pChunkProvider.toString().substring(6), pDimType, null);
    }

    public ModDimensionDef(String pDimensionName, Class<? extends IChunkProvider> pChunkProvider, Enums.DimensionType pDimType, List<ModDBMDef> pBlockDefinitions) {
        this(pDimensionName, pChunkProvider.toString().substring(6), pDimType, pBlockDefinitions);
    }

    public ModDimensionDef(String pDimensionName, String pChunkProviderName, Enums.DimensionType pDimType) {
        this(pDimensionName, pChunkProviderName, pDimType, null);
    }

    public ModDimensionDef(String pDimensionName, String pChunkProviderName, Enums.DimensionType pDimType, List<ModDBMDef> pBlockDefinitions) {
        this._mDimensionName = pDimensionName;
        this._mChunkProvider = pChunkProviderName;
        this._mDimensionType = pDimType;
        this._mReplaceableBlocks = new ArrayList();
        if (pBlockDefinitions != null) {
            this._mReplaceableBlocks.addAll(pBlockDefinitions);
        }
        this._mValidAsteroidMaterials = new ArrayList<AsteroidBlockComb>();
        this._mSpecialBlocksForAsteroids = new ArrayList<SpecialBlockComb>();
        this._mSpaceObjectsGenerators = new ArrayList<ISpaceObjectGenerator>();
        this._mSpaceStructureGenerators = new ArrayList<ISpaceObjectGenerator>();
    }

    protected void setParentModName(String pModName) {
        if (this._mInternalDimIdentifier.equals(STR_NOTDEFINED)) {
            this._mInternalDimIdentifier = String.format("%s_%s", pModName, this._mDimensionName);
        }
    }

    public Enums.ReplaceState getReplaceStateForBlock(Block pBlock, int pMeta) {
        Enums.ReplaceState tFlag = Enums.ReplaceState.Unknown;
        for (ModDBMDef pDef : this._mReplaceableBlocks) {
            Enums.ReplaceState tResult = pDef.blockEquals(pBlock, pMeta);
            if (tResult == Enums.ReplaceState.Unknown) continue;
            if (tResult == Enums.ReplaceState.CanReplace) {
                tFlag = Enums.ReplaceState.CanReplace;
                break;
            }
            if (tResult != Enums.ReplaceState.CannotReplace) break;
            tFlag = Enums.ReplaceState.CannotReplace;
            break;
        }
        return tFlag;
    }

    public AsteroidBlockComb getRandomAsteroidMaterial() {
        if (this._mValidAsteroidMaterials.isEmpty()) {
            return null;
        }
        if (this._mValidAsteroidMaterials.size() == 1) {
            return this._mValidAsteroidMaterials.get(0);
        }
        return this._mValidAsteroidMaterials.get(this._mRandom.nextInt(this._mValidAsteroidMaterials.size()));
    }

    public SpecialBlockComb getRandomSpecialAsteroidBlock() {
        if (this._mSpecialBlocksForAsteroids.isEmpty()) {
            return null;
        }
        if (this._mSpecialBlocksForAsteroids.size() == 1) {
            return this._mSpecialBlocksForAsteroids.get(0);
        }
        return this._mSpecialBlocksForAsteroids.get(this._mRandom.nextInt(this._mSpecialBlocksForAsteroids.size()));
    }

    public void addAsteroidMaterial(GTOreTypes pMaterial) {
        this.addAsteroidMaterial(new AsteroidBlockComb(pMaterial));
    }

    public void addAsteroidMaterial(AsteroidBlockComb pBlockComb) {
        if (!this._mValidAsteroidMaterials.contains(pBlockComb)) {
            this._mValidAsteroidMaterials.add(pBlockComb);
        }
    }

    public void addSpecialAsteroidBlock(SpecialBlockComb pBlock) {
        if (!this._mSpecialBlocksForAsteroids.contains(pBlock)) {
            this._mSpecialBlocksForAsteroids.add(pBlock);
        }
    }

    public void finalizeReplaceableBlocks(String pParentModName) {
        for (ModDBMDef rpb : this._mReplaceableBlocks) {
            try {
                rpb.updateBlockName(pParentModName);
                if (this._mStoneType != null) continue;
                this._mStoneType = GTOreTypes.NormalOres;
            }
            catch (Exception exception) {}
        }
    }
}

