/*
 * Decompiled with CFR 0.152.
 */
package bartworks.API.recipe;

import bartworks.common.tileentities.multis.MTEBioVat;
import com.gtnewhorizons.modularui.api.math.Alignment;
import gregtech.api.enums.GTValues;
import gregtech.api.recipe.BasicUIPropertiesBuilder;
import gregtech.api.recipe.NEIRecipePropertiesBuilder;
import gregtech.api.recipe.RecipeMapFrontend;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.nei.GTNEIDefaultHandler;
import gregtech.nei.RecipeDisplayInfo;
import gregtech.nei.formatter.INEISpecialInfoFormatter;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BacterialVatFrontend
extends RecipeMapFrontend {
    public BacterialVatFrontend(BasicUIPropertiesBuilder uiPropertiesBuilder, NEIRecipePropertiesBuilder neiPropertiesBuilder) {
        super(uiPropertiesBuilder, neiPropertiesBuilder.neiSpecialInfoFormatter(new BacterialVatSpecialValueFormatter()));
    }

    @Override
    protected List<String> handleNEIItemInputTooltip(List<String> currentTip, GTNEIDefaultHandler.FixedPositionedStack pStack) {
        if (pStack.isFluid()) {
            currentTip.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"nei.biovat.input.tooltip"));
            return currentTip;
        }
        return super.handleNEIItemInputTooltip(currentTip, pStack);
    }

    @Override
    protected List<String> handleNEIItemOutputTooltip(List<String> currentTip, GTNEIDefaultHandler.FixedPositionedStack pStack) {
        if (pStack.isFluid()) {
            currentTip.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"nei.biovat.output.tooltip"));
            return currentTip;
        }
        return super.handleNEIItemOutputTooltip(currentTip, pStack);
    }

    @Override
    protected void drawNEIOverlayForInput(GTNEIDefaultHandler.FixedPositionedStack stack) {
        this.drawFluidOverlay(stack);
    }

    @Override
    protected void drawNEIOverlayForOutput(GTNEIDefaultHandler.FixedPositionedStack stack) {
        this.drawFluidOverlay(stack);
    }

    private void drawFluidOverlay(GTNEIDefaultHandler.FixedPositionedStack stack) {
        if (stack.isFluid()) {
            this.drawNEIOverlayText("+", stack, this.colorOverride.getTextColorOrDefault("nei_overlay_yellow", 16635957), 0.5f, true, Alignment.TopRight);
            return;
        }
        super.drawNEIOverlayForOutput(stack);
    }

    private static class BacterialVatSpecialValueFormatter
    implements INEISpecialInfoFormatter {
        private BacterialVatSpecialValueFormatter() {
        }

        @Override
        public List<String> format(RecipeDisplayInfo recipeInfo) {
            int[] tSpecialA = MTEBioVat.specialValueUnpack(recipeInfo.recipe.mSpecialValue);
            String glassTier = StatCollector.func_74837_a((String)"nei.biovat.0.name", (Object[])new Object[]{GTValues.VN[tSpecialA[0]]});
            String sievert = "";
            if (tSpecialA[3] != 0) {
                sievert = tSpecialA[2] == 1 ? StatCollector.func_74837_a((String)"nei.biovat.1.name", (Object[])new Object[]{tSpecialA[3]}) : StatCollector.func_74837_a((String)"nei.biovat.2.name", (Object[])new Object[]{tSpecialA[3]});
            }
            return Arrays.asList(glassTier, sievert);
        }
    }
}

