/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.sequencer;

import binnie.Binnie;
import binnie.core.craftgui.minecraft.IMachineInformation;
import binnie.core.machines.Machine;
import binnie.core.machines.inventory.ComponentChargedSlots;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.genetics.Genetics;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.core.GeneticsTexture;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.machine.ComponentGeneticGUI;
import binnie.genetics.machine.ModuleMachine;
import binnie.genetics.machine.PackageGeneticBase;
import binnie.genetics.machine.sequencer.Sequencer;
import binnie.genetics.machine.sequencer.SequencerComponentFX;
import binnie.genetics.machine.sequencer.SequencerComponentLogic;
import binnie.genetics.machine.sequencer.UnsequencedSlotValidator;

public class SequencerPackage
extends PackageGeneticBase
implements IMachineInformation {
    public SequencerPackage() {
        super("sequencer", GeneticsTexture.Sequencer, 12058418, true);
        Sequencer.fxSeqA = Binnie.Resource.getBlockIcon(Genetics.instance, "fx/sequencer.a");
        Sequencer.fxSeqG = Binnie.Resource.getBlockIcon(Genetics.instance, "fx/sequencer.g");
        Sequencer.fxSeqT = Binnie.Resource.getBlockIcon(Genetics.instance, "fx/sequencer.t");
        Sequencer.fxSeqC = Binnie.Resource.getBlockIcon(Genetics.instance, "fx/sequencer.c");
    }

    @Override
    public void createMachine(Machine machine) {
        new ComponentGeneticGUI(machine, GeneticsGUI.Sequencer);
        ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
        InventorySlot slotDye = inventory.addSlot(0, "dye");
        slotDye.setValidator(new SlotValidator.Item(GeneticsItems.FluorescentDye.get(1), ModuleMachine.IconDye));
        slotDye.forbidExtraction();
        inventory.addSlotArray(Sequencer.SLOT_RESERVE, "input");
        for (InventorySlot slot : inventory.getSlots(Sequencer.SLOT_RESERVE)) {
            slot.setValidator(new UnsequencedSlotValidator());
            slot.forbidExtraction();
        }
        InventorySlot slotTarget = inventory.addSlot(5, "process");
        slotTarget.setValidator(new UnsequencedSlotValidator());
        slotTarget.setReadOnly();
        slotTarget.forbidInteraction();
        InventorySlot slotDone = inventory.addSlot(6, "output");
        slotDone.setReadOnly();
        ComponentInventoryTransfer transfer = new ComponentInventoryTransfer(machine);
        transfer.addRestock(Sequencer.SLOT_RESERVE, 5, 1);
        new ComponentChargedSlots(machine).addCharge(0);
        new ComponentPowerReceptor(machine, 10000);
        new SequencerComponentFX(machine);
        SequencerComponentLogic logic = new SequencerComponentLogic(machine);
        transfer.setTransferListener(logic);
    }
}

