/*
 * Decompiled with CFR 0.152.
 */
package binnie.core;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class Mods {
    public static final Mod forestry = new Mod("Forestry");
    public static final Mod ic2 = new Mod("IC2");
    public static final Mod botania = new Mod("Botania");
    public static final Mod extraBiomes = new Mod("ExtrabiomesXL");
    public static final Mod dreamcraft = new Mod("dreamcraft");

    private static Item findItem(String modId, String name) {
        Item stack = GameRegistry.findItem((String)modId, (String)name);
        if (stack == null && forestry.matchID(modId)) {
            throw new RuntimeException("Item not found: " + modId + ":" + name);
        }
        return stack;
    }

    private static ItemStack findItemStack(String modId, String name, int stackSize) {
        ItemStack stack = GameRegistry.findItemStack((String)modId, (String)name, (int)stackSize);
        if (stack == null && forestry.matchID(modId)) {
            throw new RuntimeException("Stack not found: " + modId + ":" + name);
        }
        return stack;
    }

    private static Block findBlock(String modId, String name) {
        Block stack = GameRegistry.findBlock((String)modId, (String)name);
        if (stack == null && forestry.matchID(modId)) {
            throw new RuntimeException("Block not found: " + modId + ":" + name);
        }
        return stack;
    }

    public static class Mod {
        private final String modid;
        private final boolean isLoaded;

        private Mod(String id) {
            this.modid = id;
            this.isLoaded = Loader.isModLoaded((String)id);
        }

        public Item item(String name) {
            return Mods.findItem(this.modid, name);
        }

        public Block block(String name) {
            return Mods.findBlock(this.modid, name);
        }

        public ItemStack stack(String name, int stackSize) {
            return Mods.findItemStack(this.modid, name, stackSize);
        }

        public ItemStack stack(String name) {
            return this.stack(name, 1);
        }

        public ItemStack stack(String string, int i, int j) {
            return new ItemStack(this.item(string), i, j);
        }

        public boolean active() {
            return this.isLoaded;
        }

        public boolean matchID(String id) {
            return this.modid.equals(id);
        }
    }
}

