/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.ISpecialMob;
import toast.specialMobs.entity.SpecialMobData;

public class MessageTexture
implements IMessage {
    public int entityId;
    public String[] texturePaths;

    public MessageTexture() {
    }

    public MessageTexture(Entity entity) {
        this.entityId = entity.func_145782_y();
        ResourceLocation[] textures = ((ISpecialMob)entity).getSpecialData().getTextures();
        this.texturePaths = new String[textures.length];
        int i = textures.length;
        while (i-- > 0) {
            this.texturePaths[i] = textures[i].toString();
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.texturePaths = new String[buf.readInt()];
        for (int i = 0; i < this.texturePaths.length; ++i) {
            StringBuffer path = new StringBuffer();
            short l = buf.readShort();
            while (true) {
                short s = l;
                l = (short)(l - 1);
                if (s <= 0) break;
                path.append(buf.readChar());
            }
            this.texturePaths[i] = path.toString();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.texturePaths.length);
        for (int i = 0; i < this.texturePaths.length; ++i) {
            char[] path = this.texturePaths[i].toCharArray();
            buf.writeShort(path.length);
            for (char c : path) {
                buf.writeChar((int)c);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<MessageTexture, IMessage> {
        public IMessage onMessage(MessageTexture message, MessageContext ctx) {
            try {
                World world = _SpecialMobs.proxy.getClientWorld();
                if (world == null) {
                    return null;
                }
                ISpecialMob mob = (ISpecialMob)world.func_73045_a(message.entityId);
                if (mob != null) {
                    SpecialMobData data = mob.getSpecialData();
                    data.loadTextures(message.texturePaths);
                }
            }
            catch (Exception ex) {
                _SpecialMobs.console("[ERROR] Failed to fetch mob texture from server!");
                ex.printStackTrace();
            }
            return null;
        }
    }
}

