/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.BookmarkPanel;
import codechicken.nei.GuiNEIButton;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemsTooltipLineHandler;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.BookmarkRecipeId;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiRecipeTab;
import codechicken.nei.recipe.HandlerInfo;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.StackInfo;
import cpw.mods.fml.common.eventhandler.Cancelable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;

public class GuiOverlayButton
extends GuiNEIButton {
    private static final int OVERLAY_BUTTON_ID_START = 4;
    public final GuiContainer firstGui;
    public final IRecipeHandler handler;
    public final int recipeIndex;
    protected ItemsTooltipLineHandler missedMaterialsTooltipLineHandler;
    protected final IOverlayHandler overlayHandler;
    protected final List<ItemOverlayState> itemPresenceCache = new ArrayList<ItemOverlayState>();
    protected boolean requireShiftForOverlayRecipe = true;
    protected boolean useOverlayRenderer = false;
    protected boolean hasOverlay = false;

    public GuiOverlayButton(GuiContainer firstGui, IRecipeHandler handler, int recipeIndex, int x, int y, int width, int height) {
        super(4 + recipeIndex, x, y, width, height, "+");
        this.firstGui = firstGui != null && firstGui.field_147002_h != null ? firstGui : null;
        this.handler = handler;
        this.recipeIndex = recipeIndex;
        this.hasOverlay = this.firstGui != null && handler.hasOverlay(this.firstGui, this.firstGui.field_147002_h, recipeIndex);
        this.useOverlayRenderer = this.hasOverlay && handler.getOverlayRenderer(firstGui, recipeIndex) != null;
        this.overlayHandler = this.hasOverlay ? handler.getOverlayHandler(firstGui, recipeIndex) : null;
        this.setRequireShiftForOverlayRecipe(NEIClientConfig.requireShiftForOverlayRecipe());
        this.ingredientsOverlay();
    }

    public List<String> handleTooltip(GuiRecipe<?> gui, List<String> currenttip) {
        currenttip.add(NEIClientUtils.translate("recipe.overlay", new Object[0]));
        if (!this.field_146124_l && this.requireShiftForOverlayRecipe && this.overlayHandler == null) {
            currenttip.set(currenttip.size() - 1, currenttip.get(currenttip.size() - 1) + "\u00a7h");
            currenttip.add(EnumChatFormatting.RED + NEIClientUtils.translate("recipe.overlay.mismatch", new Object[0]) + EnumChatFormatting.RESET);
        } else if (this.missedMaterialsTooltipLineHandler != null) {
            if ((!this.requireShiftForOverlayRecipe || NEIClientUtils.shiftKey()) && this.overlayHandler != null) {
                this.missedMaterialsTooltipLineHandler.setLabelColor(EnumChatFormatting.RED);
            } else {
                this.missedMaterialsTooltipLineHandler.setLabelColor(EnumChatFormatting.GRAY);
            }
            currenttip.add("\u00a7x" + GuiDraw.getTipLineId((GuiDraw.ITooltipLineHandler)this.missedMaterialsTooltipLineHandler));
        }
        return currenttip;
    }

    public Map<String, String> handleHotkeys(GuiContainer gui, int mousex, int mousey, Map<String, String> hotkeys) {
        String keyName;
        if (this.requireShiftForOverlayRecipe && this.useOverlayRenderer) {
            hotkeys.put(NEIClientUtils.translate("recipe.overlay.fillCraftingGrid.key", new Object[0]), NEIClientUtils.translate("recipe.overlay.fillCraftingGrid", new Object[0]));
        }
        if ((keyName = NEIClientConfig.getKeyName("gui.bookmark")) != null) {
            hotkeys.put(keyName, NEIClientUtils.translate("recipe.overlay.bookmark", new Object[0]));
        }
        if ((keyName = NEIClientConfig.getKeyName("gui.bookmark_recipe")) != null) {
            hotkeys.put(keyName, NEIClientUtils.translate("recipe.overlay.bookmarkRecipe", new Object[0]));
        }
        if ((keyName = NEIClientConfig.getKeyName("gui.bookmark_count")) != null) {
            hotkeys.put(keyName, NEIClientUtils.translate("recipe.overlay.bookmarkAmount", new Object[0]));
        }
        if ((keyName = NEIClientConfig.getKeyName("gui.bookmark_recipe_count")) != null) {
            hotkeys.put(keyName, NEIClientUtils.translate("recipe.overlay.bookmarkRecipeAndAmount", new Object[0]));
        }
        return hotkeys;
    }

    public void func_146118_a(int mouseX, int mouseY) {
        if (this.firstGui != null) {
            this.firstGui.field_146297_k.func_147108_a((GuiScreen)this.firstGui);
            this.overlayRecipe(NEIClientUtils.shiftKey());
        }
    }

    public void drawItemPresenceOverlay() {
        int presenceOverlay = NEIClientConfig.itemPresenceOverlay();
        boolean highlightPresentItem = NEIClientConfig.isSlotHighlightPresent();
        ItemOverlayFormat format = ItemOverlayFormat.from(presenceOverlay);
        for (ItemOverlayState overlay : this.ingredientsOverlay()) {
            if (!highlightPresentItem && overlay.isPresent()) continue;
            overlay.draw(format);
        }
    }

    protected List<ItemOverlayState> ingredientsOverlay() {
        List<PositionedStack> ingredients = this.handler.getIngredientStacks(this.recipeIndex);
        if (this.itemPresenceCache.size() != ingredients.size()) {
            this.itemPresenceCache.clear();
            if (this.overlayHandler != null) {
                this.itemPresenceCache.addAll(this.overlayHandler.presenceOverlay(this.firstGui, this.handler, this.recipeIndex));
            } else if (this.firstGui != null) {
                this.itemPresenceCache.addAll(this.presenceOverlay(ingredients));
            }
            List items = this.itemPresenceCache.stream().filter(state -> !state.isPresent()).map(state -> state.getSlot().item).collect(Collectors.toCollection(ArrayList::new));
            this.missedMaterialsTooltipLineHandler = !items.isEmpty() ? new ItemsTooltipLineHandler(NEIClientUtils.translate("recipe.overlay.missing", new Object[0]), items, true, Integer.MAX_VALUE) : null;
        }
        return this.itemPresenceCache;
    }

    public void setRequireShiftForOverlayRecipe(boolean require) {
        this.requireShiftForOverlayRecipe = require;
        this.field_146124_l = this.hasOverlay && (this.requireShiftForOverlayRecipe || this.overlayHandler != null);
    }

    public void setUseOverlayRenderer(boolean use) {
        this.useOverlayRenderer = use;
    }

    public boolean useOverlayRenderer() {
        return this.useOverlayRenderer;
    }

    public boolean canFillCraftingGrid() {
        return this.missedMaterialsTooltipLineHandler == null;
    }

    public boolean hasOverlay() {
        return this.hasOverlay;
    }

    private List<ItemOverlayState> presenceOverlay(List<PositionedStack> ingredients) {
        ArrayList<ItemOverlayState> itemPresenceSlots = new ArrayList<ItemOverlayState>();
        List invStacks = this.firstGui.field_147002_h.field_75151_b.stream().filter(s -> s != null && s.func_75211_c() != null && s.func_75211_c().field_77994_a > 0 && s.func_75214_a(s.func_75211_c()) && s.func_82869_a((EntityPlayer)this.firstGui.field_146297_k.field_71439_g)).map(s -> s.func_75211_c().func_77946_l()).collect(Collectors.toCollection(ArrayList::new));
        for (PositionedStack stack : ingredients) {
            Optional<ItemStack> used = invStacks.stream().filter(is -> is.field_77994_a > 0 && stack.contains((ItemStack)is)).findAny();
            itemPresenceSlots.add(new ItemOverlayState(stack, used.isPresent()));
            if (!used.isPresent()) continue;
            ItemStack is2 = used.get();
            --is2.field_77994_a;
        }
        return itemPresenceSlots;
    }

    public void overlayRecipe(boolean shift) {
        if (!this.hasOverlay) {
            return;
        }
        if (!this.useOverlayRenderer || !this.requireShiftForOverlayRecipe || shift) {
            if (this.overlayHandler != null) {
                this.overlayHandler.overlayRecipe(this.firstGui, this.handler, this.recipeIndex, !this.requireShiftForOverlayRecipe || shift);
            }
        } else {
            LayoutManager.overlayRenderer = this.handler.getOverlayRenderer(this.firstGui, this.recipeIndex);
        }
    }

    public void lastKeyTyped(GuiRecipe<?> gui, char keyChar, int keyID) {
        if (NEIClientConfig.isKeyHashDown("gui.bookmark")) {
            this.saveRecipeInBookmark(false, false);
        } else if (NEIClientConfig.isKeyHashDown("gui.bookmark_recipe")) {
            this.saveRecipeInBookmark(true, false);
        } else if (NEIClientConfig.isKeyHashDown("gui.bookmark_count")) {
            this.saveRecipeInBookmark(false, true);
        } else if (NEIClientConfig.isKeyHashDown("gui.bookmark_recipe_count")) {
            this.saveRecipeInBookmark(true, true);
        }
    }

    public void saveRecipeInBookmark(boolean saveIngredients, boolean saveStackSize) {
        HandlerInfo handlerInfo = GuiRecipeTab.getHandlerInfo(this.handler);
        List<PositionedStack> ingredients = this.handler.getIngredientStacks(this.recipeIndex);
        BookmarkRecipeId recipeId = new BookmarkRecipeId(handlerInfo.getHandlerName(), ingredients);
        if (!ItemPanels.bookmarkPanel.removeBookmarkRecipeId(recipeId)) {
            PositionedStack result;
            BookmarkPanel.BookmarkRecipe recipe = new BookmarkPanel.BookmarkRecipe(new ItemStack[0]);
            recipe.handlerName = recipeId.handlerName;
            recipe.recipeId = recipeId;
            if (saveIngredients) {
                for (PositionedStack stack : ingredients) {
                    recipe.ingredients.add(stack.item);
                }
            }
            if ((result = this.handler.getResultStack(this.recipeIndex)) != null) {
                recipe.result.add(result.item);
            } else {
                for (PositionedStack stack : this.handler.getOtherStacks(this.recipeIndex)) {
                    recipe.result.add(stack.item);
                }
            }
            ItemPanels.bookmarkPanel.addRecipe(recipe, saveStackSize);
        }
    }

    public int getResultStackSize(ItemStack stackover) {
        List<PositionedStack> stacks = this.handler.getOtherStacks(this.recipeIndex);
        int stackSize = stackover.field_77994_a;
        for (PositionedStack pStack : stacks) {
            if (!StackInfo.equalItemAndNBT(pStack.item, stackover, true)) continue;
            stackSize += pStack.item.field_77994_a;
        }
        return stackSize;
    }

    public Rectangle4i bounds() {
        return new Rectangle4i(this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g);
    }

    public boolean contains(int mx, int my) {
        return this.bounds().contains(mx, my);
    }

    public static enum ItemOverlayFormat {
        BACKGROUND,
        ICON;


        public static ItemOverlayFormat from(int overlay) {
            return overlay == 2 ? BACKGROUND : ICON;
        }
    }

    public static class ItemOverlayState {
        protected PositionedStack slot;
        protected boolean isPresent;

        public ItemOverlayState(PositionedStack slot, boolean isPresent) {
            this.slot = slot;
            this.isPresent = isPresent;
        }

        public boolean isPresent() {
            return this.isPresent;
        }

        public PositionedStack getSlot() {
            return this.slot;
        }

        public void draw(ItemOverlayFormat format) {
            LayoutManager.drawItemPresenceOverlay(this.slot.relx, this.slot.rely, this.isPresent, format == ItemOverlayFormat.BACKGROUND);
        }
    }

    public static class UpdateOverlayButtonsEvent
    extends GuiScreenEvent {
        public List<GuiOverlayButton> buttonList;

        public UpdateOverlayButtonsEvent(GuiRecipe<?> gui, List<GuiOverlayButton> buttonList) {
            super(gui);
            this.buttonList = new ArrayList<GuiOverlayButton>(buttonList);
        }

        public static class Post
        extends UpdateOverlayButtonsEvent {
            public Post(GuiRecipe<?> gui, List<GuiOverlayButton> buttonList) {
                super(gui, buttonList);
            }
        }

        @Cancelable
        public static class Pre
        extends UpdateOverlayButtonsEvent {
            public int xOffset;
            public int yOffset;
            public int height;
            public HandlerInfo handlerInfo;

            public Pre(GuiRecipe<?> gui, int xOffset, int yOffset, int height, HandlerInfo handlerInfo) {
                super(gui, new ArrayList<GuiOverlayButton>());
                this.xOffset = xOffset;
                this.yOffset = yOffset;
                this.height = height;
                this.handlerInfo = handlerInfo;
            }
        }
    }
}

