/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.model;

import com.google.common.annotations.Beta;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.gtnewhorizon.gtnhlib.GTNHLib;
import com.gtnewhorizon.gtnhlib.client.model.Variant;
import com.gtnewhorizon.gtnhlib.client.model.json.JsonModel;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.QuadProvider;
import com.gtnewhorizon.gtnhlib.util.Callback;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

@Beta
public class ModelLoader {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(JsonModel.class, (Object)new JsonModel.Deserializer()).create();
    private static final List<ResourceLocation> unloadedModels = new ObjectArrayList<ResourceLocation>();
    private static final Map<ResourceLocation, JsonModel> loadedModels = new Object2ObjectOpenHashMap<ResourceLocation, JsonModel>();
    private static final Map<Variant, JsonModel> modelsToBake = new Object2ObjectOpenHashMap<Variant, JsonModel>();
    private static final List<Callback> postBakeCallbacks = new ObjectArrayList<Callback>();

    public static void registerBaker(Callback baker) {
        postBakeCallbacks.add(baker);
    }

    public static void registerModels(Callback loader, Variant ... variants) {
        ModelLoader.registerModels(loader, Arrays.asList(variants));
    }

    public static void registerModels(Callback loader, Collection<Variant> variants) {
        for (Variant v : variants) {
            unloadedModels.add(v.getModel());
            modelsToBake.put(v, null);
        }
        postBakeCallbacks.add(loader);
    }

    public static void loadModels() {
        for (ResourceLocation l : unloadedModels) {
            if (l == null || loadedModels.containsKey(l)) continue;
            JsonModel model = ModelLoader.loadJson(l, JsonModel.class);
            unloadedModels.addAll(model.getParents());
            loadedModels.put(l, model);
        }
    }

    private static <T> T loadJson(ResourceLocation path, Class<T> clazz) {
        try {
            InputStream is = Minecraft.func_71410_x().func_110442_L().func_110536_a(path).func_110527_b();
            return (T)GSON.fromJson((Reader)new InputStreamReader(is), clazz);
        }
        catch (IOException e) {
            GTNHLib.LOG.fatal("Could not find " + path.func_110624_b() + " " + path.func_110623_a());
            throw new RuntimeException(e);
        }
    }

    public static void bakeModels() {
        for (Map.Entry<Variant, JsonModel> l : modelsToBake.entrySet()) {
            JsonModel dough = new JsonModel(loadedModels.get(l.getKey().getModel()));
            dough.resolveParents(loadedModels::get);
            dough.bake(l.getKey());
            l.setValue(dough);
        }
        for (Callback c : postBakeCallbacks) {
            c.run();
        }
    }

    public static QuadProvider getModel(Variant loc) {
        return modelsToBake.get(loc);
    }

    public static boolean shouldLoadModels() {
        return !unloadedModels.isEmpty();
    }
}

