/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import net.malisis.core.network.MalisisMessage;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.entity.VanishingDiamondTileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@MalisisMessage
public class VanishingDiamondFrameMessage
implements IMessageHandler<Packet, IMessage> {
    public VanishingDiamondFrameMessage() {
        MalisisDoors.network.registerMessage(this, Packet.class, Side.SERVER);
    }

    public IMessage onMessage(Packet message, MessageContext ctx) {
        World world = ctx.getServerHandler().field_147369_b.field_70170_p;
        VanishingDiamondTileEntity te = TileEntityUtils.getTileEntity(VanishingDiamondTileEntity.class, (IBlockAccess)world, message.x, message.y, message.z);
        if (te == null) {
            return null;
        }
        switch (message.type) {
            case PROPAGATION: {
                te.getDirectionState((ForgeDirection)message.facing).shouldPropagate = message.checked;
                break;
            }
            case DELAY: {
                te.getDirectionState((ForgeDirection)message.facing).delay = message.time;
                break;
            }
            case INVERSED: {
                te.getDirectionState((ForgeDirection)message.facing).inversed = message.checked;
                break;
            }
            case DURATION: {
                te.setDuration(message.time);
            }
        }
        world.func_147471_g(message.x, message.y, message.z);
        return null;
    }

    public static void sendConfiguration(VanishingDiamondTileEntity te, ForgeDirection facing, DataType type, int time, boolean checked) {
        Packet packet = new Packet(te.field_145851_c, te.field_145848_d, te.field_145849_e, type, facing, time, checked);
        MalisisDoors.network.sendToServer(packet);
    }

    public static class Packet
    implements IMessage {
        protected int x;
        protected int y;
        protected int z;
        protected DataType type;
        protected ForgeDirection facing;
        protected int time;
        protected boolean checked;

        public Packet() {
        }

        public Packet(int x, int y, int z, DataType type, ForgeDirection facing, int time, boolean checked) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.type = type;
            this.facing = facing;
            this.time = time;
            this.checked = checked;
        }

        public void fromBytes(ByteBuf buf) {
            this.x = buf.readInt();
            this.y = buf.readInt();
            this.z = buf.readInt();
            this.type = DataType.values()[buf.readByte()];
            if (this.type != DataType.DURATION) {
                this.facing = ForgeDirection.values()[buf.readByte()];
            }
            if (this.type == DataType.PROPAGATION || this.type == DataType.INVERSED) {
                this.checked = buf.readBoolean();
            } else {
                this.time = buf.readInt();
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.x);
            buf.writeInt(this.y);
            buf.writeInt(this.z);
            buf.writeByte(this.type.ordinal());
            if (this.type != DataType.DURATION) {
                buf.writeByte(this.facing.ordinal());
            }
            if (this.type == DataType.PROPAGATION || this.type == DataType.INVERSED) {
                buf.writeBoolean(this.checked);
            } else {
                buf.writeInt(this.time);
            }
        }
    }

    public static enum DataType {
        PROPAGATION,
        DELAY,
        INVERSED,
        DURATION;

    }
}

