/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.block;

import cpw.mods.fml.common.registry.GameRegistry;
import net.malisis.core.renderer.icon.MalisisIcon;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.door.block.Door;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.malisis.doors.door.tileentity.FenceGateTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FenceGate
extends BlockFenceGate
implements ITileEntityProvider {
    private Type type;
    private IIcon camoIcon;
    public static int renderId = -1;

    public FenceGate(Type type) {
        this.type = type;
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(field_149766_f);
        this.func_149663_c(type.name);
        if (type != Type.OAK) {
            this.func_149647_a(MalisisDoors.tab);
        }
    }

    public FenceGate register() {
        GameRegistry.registerBlock((Block)this, (String)this.type.name);
        if (this.type == Type.CAMO) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this), (Object[])new Object[]{"ABC", Character.valueOf('A'), MalisisDoors.Blocks.acaciaFenceGate, Character.valueOf('B'), MalisisDoors.Blocks.jungleFenceGate, Character.valueOf('C'), MalisisDoors.Blocks.birchFenceGate});
        } else {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this), (Object[])new Object[]{"ABA", "ABA", Character.valueOf('A'), Items.field_151055_y, Character.valueOf('B'), new ItemStack(Blocks.field_150344_f, 1, this.type.type)});
        }
        return this;
    }

    public void func_149651_a(IIconRegister register) {
        if (this.type == Type.CAMO) {
            this.camoIcon = new MalisisIcon("malisisdoors:camo_fencegate").register((TextureMap)register);
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.type == Type.CAMO ? this.camoIcon : Blocks.field_150344_f.func_149691_a(side, this.type.type);
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        if (this.type != Type.CAMO) {
            return super.func_149673_e(world, x, y, z, side);
        }
        FenceGateTileEntity te = TileEntityUtils.getTileEntity(FenceGateTileEntity.class, world, x, y, z);
        if (te == null) {
            return super.func_149673_e(world, x, y, z, side);
        }
        return te.getCamoIcon();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, player, itemStack);
        if (world.field_72995_K) {
            return;
        }
        FenceGateTileEntity te = TileEntityUtils.getTileEntity(FenceGateTileEntity.class, (IBlockAccess)world, x, y, z);
        if (te == null) {
            return;
        }
        te.updateAll();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        DoorTileEntity te = Door.getDoor((IBlockAccess)world, x, y, z);
        if (te == null) {
            return true;
        }
        boolean opened = te.isOpened();
        te.openOrCloseDoor();
        if (opened) {
            return true;
        }
        int dir = (MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) % 4;
        if (dir == ((world.func_72805_g(x, y, z) & 3) + 2) % 4) {
            world.func_72921_c(x, y, z, dir, 2);
        }
        if ((te = te.getDoubleDoor()) != null && dir == ((world.func_72805_g(te.field_145851_c, te.field_145848_d, te.field_145849_e) & 3) + 2) % 4) {
            world.func_72921_c(te.field_145851_c, te.field_145848_d, te.field_145849_e, dir, 2);
        }
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        FenceGateTileEntity te = TileEntityUtils.getTileEntity(FenceGateTileEntity.class, (IBlockAccess)world, x, y, z);
        if (te == null) {
            return;
        }
        te.updateAll();
        if (world.func_72864_z(x, y, z) || block.func_149744_f()) {
            te.setPowered(te.isPowered());
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        DoorTileEntity te = Door.getDoor((IBlockAccess)world, x, y, z);
        if (te == null || te.isMoving() || te.isOpened()) {
            return null;
        }
        return super.func_149668_a(world, x, y, z);
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new FenceGateTileEntity();
    }

    public int func_149645_b() {
        return renderId;
    }

    public static enum Type {
        OAK("fenceGate", 0),
        ACACIA("acaciaFenceGate", 4),
        BIRCH("birchFenceGate", 2),
        DARK_OAK("darkOakFenceGate", 5),
        JUNGLE("jungleFenceGate", 3),
        SPRUCE("spruceFenceGate", 1),
        CAMO("camoFenceGate", 0);

        private int type;
        private String name;

        private Type(String name, int type) {
            this.name = name;
            this.type = type;
        }
    }
}

