/*
 * Decompiled with CFR 0.152.
 */
package travellersgear.common.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import travellersgear.TravellersGear;
import travellersgear.api.TGSaveData;
import travellersgear.api.TravellersGearAPI;
import travellersgear.client.ClientProxy;
import travellersgear.client.ToolDisplayInfo;

public class MessageNBTSync
implements IMessage {
    int dim;
    int playerid;
    NBTTagCompound tag;
    NBTTagCompound[] toolDisplay;

    public MessageNBTSync() {
    }

    public MessageNBTSync(EntityPlayer player) {
        this.dim = player.field_70170_p.field_73011_w.field_76574_g;
        this.playerid = player.func_145782_y();
        this.tag = TGSaveData.getPlayerData(player);
        if (this.tag == null) {
            this.tag = new NBTTagCompound();
            if (player.getEntityData().func_74775_l("TravellersRPG") != null) {
                this.tag = player.getEntityData().func_74775_l("TravellersRPG");
                player.getEntityData().func_82580_o("TravellersRPG");
            }
            this.tag.func_74772_a("UUIDMost", player.getPersistentID().getMostSignificantBits());
            this.tag.func_74772_a("UUIDLeast", player.getPersistentID().getLeastSignificantBits());
        }
        this.tag.func_74780_a("info_playerDamage", player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dim);
        buf.writeInt(this.playerid);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
    }

    public void fromBytes(ByteBuf buf) {
        this.dim = buf.readInt();
        this.playerid = buf.readInt();
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public static class HandlerServer
    implements IMessageHandler<MessageNBTSync, IMessage> {
        public IMessage onMessage(MessageNBTSync message, MessageContext ctx) {
            WorldServer world = DimensionManager.getWorld((int)message.dim);
            if (world == null) {
                return null;
            }
            Entity player = world.func_73045_a(message.playerid);
            if (!(player instanceof EntityPlayer)) {
                return null;
            }
            TGSaveData.setPlayerData((EntityPlayer)player, message.tag);
            TGSaveData.setDirty();
            TravellersGear.packetHandler.sendToAll((IMessage)new MessageNBTSync((EntityPlayer)player));
            return null;
        }
    }

    public static class HandlerClient
    implements IMessageHandler<MessageNBTSync, IMessage> {
        public IMessage onMessage(MessageNBTSync message, MessageContext ctx) {
            World world = TravellersGear.proxy.getClientWorld();
            if (world == null) {
                return null;
            }
            Entity player = world.func_73045_a(message.playerid);
            if (!(player instanceof EntityPlayer)) {
                return null;
            }
            if (message.tag == null) {
                throw new RuntimeException("HEYO!");
            }
            TGSaveData.setPlayerData((EntityPlayer)player, message.tag);
            TGSaveData.setDirty();
            ClientProxy.equipmentMap.put(player.func_70005_c_(), TravellersGearAPI.getExtendedInventory((EntityPlayer)player));
            if (message.tag.func_74764_b("toolDisplay")) {
                NBTTagList list = message.tag.func_150295_c("toolDisplay", 10);
                ToolDisplayInfo[] tdi = new ToolDisplayInfo[list.func_74745_c()];
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    tdi[i] = ToolDisplayInfo.readFromNBT(list.func_150305_b(i));
                }
                ClientProxy.toolDisplayMap.put(player.func_70005_c_(), tdi);
            }
            return null;
        }
    }
}

