/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.network;

import com.brandon3055.brandonscore.common.utills.DataUtills;
import com.brandon3055.brandonscore.common.utills.ItemNBTHelper;
import com.brandon3055.draconicevolution.common.utills.IConfigurableItem;
import com.brandon3055.draconicevolution.common.utills.ItemConfigField;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemConfigPacket
implements IMessage {
    public byte datatype;
    public int slot;
    public Object value;
    public String name;
    public boolean renameProfile = false;

    public ItemConfigPacket() {
    }

    public ItemConfigPacket(ItemConfigField field) {
        this.datatype = (byte)field.datatype;
        this.slot = field.slot;
        this.value = field.value;
        this.name = field.name;
    }

    public ItemConfigPacket(int slot, String name) {
        this.datatype = (byte)6;
        this.slot = slot;
        this.value = false;
        this.name = name;
        this.renameProfile = true;
    }

    public void fromBytes(ByteBuf bytes) {
        this.datatype = bytes.readByte();
        this.slot = bytes.readInt();
        this.name = ByteBufUtils.readUTF8String((ByteBuf)bytes);
        this.value = DataUtills.instance.readObjectFromBytes(bytes, (int)this.datatype);
        this.renameProfile = bytes.readBoolean();
    }

    public void toBytes(ByteBuf bytes) {
        bytes.writeByte((int)this.datatype);
        bytes.writeInt(this.slot);
        ByteBufUtils.writeUTF8String((ByteBuf)bytes, (String)this.name);
        DataUtills.instance.writeObjectToBytes(bytes, (int)this.datatype, this.value);
        bytes.writeBoolean(this.renameProfile);
    }

    public static class Handler
    implements IMessageHandler<ItemConfigPacket, IMessage> {
        public IMessage onMessage(ItemConfigPacket message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (message.slot >= player.field_71071_by.func_70302_i_() || message.slot < 0) {
                return null;
            }
            ItemStack stack = player.field_71071_by.func_70301_a(message.slot);
            if (stack != null && stack.func_77973_b() instanceof IConfigurableItem) {
                if (message.renameProfile) {
                    ItemNBTHelper.setString((ItemStack)stack, (String)("ProfileName" + ItemNBTHelper.getInteger((ItemStack)stack, (String)"ConfigProfile", (int)0)), (String)message.name);
                    return null;
                }
                IConfigurableItem item = (IConfigurableItem)stack.func_77973_b();
                List<ItemConfigField> fields = item.getFields(stack, message.slot);
                for (ItemConfigField field : fields) {
                    ItemConfigField newValue;
                    if (!field.name.equals(message.name) || message.datatype != field.datatype || !((newValue = new ItemConfigField(message.datatype, message.value, message.slot, message.name)).castToDouble() <= field.castMaxToDouble()) || !(newValue.castToDouble() >= field.castMinToDouble())) continue;
                    DataUtills.writeObjectToCompound((NBTTagCompound)IConfigurableItem.ProfileHelper.getProfileCompound(stack), (Object)message.value, (int)message.datatype, (String)message.name);
                }
            }
            return null;
        }
    }
}

