/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.core.sync.packets;

import appeng.api.storage.data.IAEItemStack;
import appeng.client.ClientHelper;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftAmount;
import appeng.helpers.InventoryAction;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.p455w0rd.wirelesscraftingterminal.common.WCTGuiHandler;
import net.p455w0rd.wirelesscraftingterminal.common.container.ContainerWirelessCraftingTerminal;
import net.p455w0rd.wirelesscraftingterminal.common.utils.RandomUtils;
import net.p455w0rd.wirelesscraftingterminal.core.sync.WCTPacket;
import net.p455w0rd.wirelesscraftingterminal.core.sync.network.INetworkInfo;

public class PacketInventoryAction
extends WCTPacket {
    private final InventoryAction action;
    private final int slot;
    private final long id;
    private final IAEItemStack slotItem;

    public PacketInventoryAction(ByteBuf stream) throws IOException {
        this.action = InventoryAction.values()[stream.readInt()];
        this.slot = stream.readInt();
        this.id = stream.readLong();
        boolean hasItem = stream.readBoolean();
        this.slotItem = hasItem ? AEItemStack.loadItemStackFromPacket((ByteBuf)stream) : null;
    }

    public PacketInventoryAction(InventoryAction action, int slot, IAEItemStack slotItem) throws IOException {
        if (Platform.isClient()) {
            throw new IllegalStateException("invalid packet, client cannot post inv actions with stacks.");
        }
        this.action = action;
        this.slot = slot;
        this.id = 0L;
        this.slotItem = slotItem;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(action.ordinal());
        data.writeInt(slot);
        data.writeLong(this.id);
        if (slotItem == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(true);
            slotItem.writeToPacket(data);
        }
        this.configureWrite(data);
    }

    public PacketInventoryAction(InventoryAction action, int slot, long id) {
        this.action = action;
        this.slot = slot;
        this.id = id;
        this.slotItem = null;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(action.ordinal());
        data.writeInt(slot);
        data.writeLong(id);
        data.writeBoolean(false);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, WCTPacket packet, EntityPlayer player) {
        EntityPlayerMP sender = (EntityPlayerMP)player;
        Container baseContainer = sender.field_71070_bA;
        ContainerOpenContext context = null;
        if (baseContainer instanceof AEBaseContainer) {
            context = ((AEBaseContainer)baseContainer).getOpenContext();
        }
        if (this.action == InventoryAction.AUTO_CRAFT) {
            int x = (int)player.field_70165_t;
            int y = (int)player.field_70163_u;
            int z = (int)player.field_70161_v;
            WCTGuiHandler.launchGui(2, player, player.field_70170_p, x, y, z);
            if (sender.field_71070_bA instanceof ContainerCraftAmount) {
                ContainerCraftAmount cca = (ContainerCraftAmount)sender.field_71070_bA;
                if (baseContainer instanceof ContainerWirelessCraftingTerminal && ((ContainerWirelessCraftingTerminal)baseContainer).getTargetStack() != null) {
                    cca.getCraftingItem().func_75215_d(((ContainerWirelessCraftingTerminal)baseContainer).getTargetStack().getItemStack());
                    cca.setItemToCraft(((ContainerWirelessCraftingTerminal)baseContainer).getTargetStack());
                }
                if (baseContainer instanceof AEBaseContainer && ((AEBaseContainer)baseContainer).getTargetStack() != null) {
                    cca.getCraftingItem().func_75215_d(((AEBaseContainer)baseContainer).getTargetStack().getItemStack());
                    cca.setItemToCraft(((AEBaseContainer)baseContainer).getTargetStack());
                }
                cca.func_75142_b();
            }
        } else {
            if (baseContainer instanceof ContainerWirelessCraftingTerminal) {
                if (RandomUtils.getWirelessTerm(player.field_71071_by) == null) {
                    ((ContainerWirelessCraftingTerminal)baseContainer).setValidContainer(false);
                } else {
                    ((ContainerWirelessCraftingTerminal)baseContainer).doAction(sender, this.action, this.slot, this.id);
                }
            }
            if (baseContainer instanceof AEBaseContainer) {
                ((AEBaseContainer)baseContainer).doAction(sender, this.action, this.slot, this.id);
            }
        }
    }

    @Override
    public void clientPacketData(INetworkInfo network, WCTPacket packet, EntityPlayer player) {
        if (this.action == InventoryAction.UPDATE_HAND) {
            if (this.slotItem == null) {
                ((EntityPlayer)ClientHelper.proxy.getPlayers().get((int)0)).field_71071_by.func_70437_b(null);
            } else {
                ((EntityPlayer)ClientHelper.proxy.getPlayers().get((int)0)).field_71071_by.func_70437_b(this.slotItem.getItemStack());
            }
        }
    }
}

