/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.compat.oc;

import gcewing.sg.BaseConfiguration;
import gcewing.sg.SGCraft;
import gcewing.sg.tileentities.SGBaseTE;
import li.cil.oc.api.Network;
import li.cil.oc.api.network.Packet;
import li.cil.oc.api.network.WirelessEndpoint;
import net.minecraft.world.World;

public class OCWirelessEndpoint
implements WirelessEndpoint {
    public static double forwardingStrength = 50.0;
    static boolean debugWireless = false;
    SGBaseTE te;

    public static void configure(BaseConfiguration config) {
        forwardingStrength = config.getDouble("opencomputers", "wirelessRebroadcastStrength", forwardingStrength);
    }

    public OCWirelessEndpoint(SGBaseTE te) {
        if (debugWireless) {
            SGCraft.log.debug(String.format("OCSGWirelessEndpoint: added %s for %s", this, te));
        }
        this.te = te;
        Network.joinWirelessNetwork((WirelessEndpoint)this);
    }

    public void remove() {
        if (debugWireless) {
            SGCraft.log.debug(String.format("OCSGWirelessEndpoint: removed for %s", this.te));
        }
        Network.leaveWirelessNetwork((WirelessEndpoint)this);
    }

    public int x() {
        return this.te.field_145851_c;
    }

    public int y() {
        return this.te.field_145848_d;
    }

    public int z() {
        return this.te.field_145849_e;
    }

    public World world() {
        return this.te.func_145831_w();
    }

    public void receivePacket(Packet packet, WirelessEndpoint sender) {
        SGBaseTE dte;
        if (debugWireless) {
            SGCraft.log.debug(String.format("OCSGWirelessEndpoint.receivePacket: ttl %s from %s by %s", packet.ttl(), sender, this.te));
        }
        if (packet.ttl() > 0 && (dte = this.te.getConnectedStargateTE()) != null && dte.ocWirelessEndpoint != null) {
            if (debugWireless) {
                SGCraft.log.debug(String.format("OCSGWirelessEndpoint.receivePacket: forwarding to %s", dte));
            }
            Network.sendWirelessPacket((WirelessEndpoint)dte.ocWirelessEndpoint, (double)forwardingStrength, (Packet)packet.hop());
        }
    }
}

