/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels.common.blocks.logic;

import cpw.mods.fml.common.Loader;
import mcp.mobius.betterbarrels.common.blocks.IBarrelStorage;
import mcp.mobius.betterbarrels.common.blocks.TileEntityBarrel;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public enum LogicHopper {
    INSTANCE;

    private static Boolean isMFRLoaded;

    private static boolean isMFRLoaded() {
        if (isMFRLoaded == null) {
            isMFRLoaded = Loader.isModLoaded((String)"MineFactoryReloaded");
        }
        return isMFRLoaded;
    }

    private boolean isStorage(TileEntity inventory) {
        if (LogicHopper.isMFRLoaded() && inventory instanceof IDeepStorageUnit) {
            return true;
        }
        return inventory instanceof IInventory;
    }

    public boolean run(TileEntityBarrel barrel) {
        boolean transaction = false;
        IBarrelStorage store = barrel.getStorage();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity targetEntity;
            if (barrel.sideUpgrades[side.ordinal()] != 3 || (barrel.sideMetadata[side.ordinal()] & 1) == 0 && (!store.hasItem() || store.getAmount() <= 0) || (barrel.sideMetadata[side.ordinal()] & 1) == 1 && store.getAmount() >= store.getMaxStoredCount() || !this.isStorage(targetEntity = barrel.func_145831_w().func_147438_o(barrel.field_145851_c + side.offsetX, barrel.field_145848_d + side.offsetY, barrel.field_145849_e + side.offsetZ))) continue;
            if ((barrel.sideMetadata[side.ordinal()] & 1) == 0) {
                int free = this.freeSpaceForStack(targetEntity, side.getOpposite(), store, barrel.sideMetadata[side.ordinal()] >> 1);
                if (free <= 0 || !this.pushItemToInventory(targetEntity, side.getOpposite(), store, Math.min(barrel.sideMetadata[side.ordinal()] >> 1, free))) continue;
                store.func_70296_d();
                transaction = true;
                targetEntity.func_70296_d();
                continue;
            }
            ItemStack pulledStack = this.pullMatchingItemFromInventory(targetEntity, side.getOpposite(), store, barrel.sideMetadata[side.ordinal()] >> 1);
            if (pulledStack == null) continue;
            if (store.hasItem()) {
                store.setStoredItemCount(store.getAmount() + pulledStack.field_77994_a);
            } else {
                store.setStoredItemType(pulledStack, pulledStack.field_77994_a);
            }
            transaction = true;
            targetEntity.func_70296_d();
        }
        return transaction;
    }

    private int freeSpaceForStack(TileEntity target, ForgeDirection side, IBarrelStorage barrel, int maxSeeking) {
        int ret;
        block7: {
            ItemStack stack;
            block8: {
                ItemStack is;
                IDeepStorageUnit dsu;
                block9: {
                    stack = barrel.func_70301_a(1);
                    ret = 0;
                    if (!LogicHopper.isMFRLoaded() || !(target instanceof IDeepStorageUnit)) break block8;
                    dsu = (IDeepStorageUnit)target;
                    is = dsu.getStoredItemType();
                    if (is != null) break block9;
                    ret = dsu.getMaxStoredCount();
                    break block7;
                }
                if (!barrel.sameItem(is)) break block7;
                ret = dsu.getMaxStoredCount() - is.field_77994_a;
                break block7;
            }
            if (target instanceof ISidedInventory) {
                int[] islots;
                ISidedInventory sinv = (ISidedInventory)target;
                for (int index : islots = sinv.func_94128_d(side.ordinal())) {
                    if (!sinv.func_102007_a(index, stack, side.ordinal())) continue;
                    ItemStack is = sinv.func_70301_a(index);
                    ret = is == null ? (ret += sinv.func_70297_j_()) : (ret += is.func_77976_d() - is.field_77994_a);
                    if (ret < maxSeeking) {
                        continue;
                    }
                    break;
                }
            } else if (target instanceof IInventory) {
                IInventory inv = (IInventory)target;
                for (int index = 0; index < inv.func_70302_i_(); ++index) {
                    if (!inv.func_94041_b(index, stack)) continue;
                    ItemStack is = inv.func_70301_a(index);
                    ret = is == null ? (ret += inv.func_70297_j_()) : (ret += is.func_77976_d() - is.field_77994_a);
                    if (ret < maxSeeking) {
                        continue;
                    }
                    break;
                }
            }
        }
        return ret;
    }

    private boolean pushItemToInventory(TileEntity target, ForgeDirection side, IBarrelStorage barrel, int maxTransfer) {
        ItemStack stack = barrel.func_70301_a(1);
        int transferAmount = Math.min(maxTransfer, stack.field_77994_a);
        if (LogicHopper.isMFRLoaded() && target instanceof IDeepStorageUnit) {
            IDeepStorageUnit dsu = (IDeepStorageUnit)target;
            ItemStack is = dsu.getStoredItemType();
            if (is == null) {
                is = stack.func_77946_l();
                dsu.setStoredItemType(is, transferAmount);
                stack.field_77994_a -= transferAmount;
                return true;
            }
            if (barrel.sameItem(is)) {
                dsu.setStoredItemCount(is.field_77994_a + transferAmount);
                stack.field_77994_a -= transferAmount;
                return true;
            }
        } else if (target instanceof ISidedInventory && side.ordinal() > -1) {
            ISidedInventory sinv = (ISidedInventory)target;
            int[] islots = sinv.func_94128_d(side.ordinal());
            int maxInventoryStackLimit = sinv.func_70297_j_();
            int transferred = 0;
            for (int slot : islots) {
                if (transferred == transferAmount) break;
                if (!sinv.func_102007_a(slot, stack, side.ordinal())) continue;
                ItemStack targetStack = sinv.func_70301_a(slot);
                int slotTransferAmount = Math.min(transferAmount - transferred, maxInventoryStackLimit);
                if (targetStack == null) {
                    targetStack = stack.func_77946_l();
                    targetStack.field_77994_a = slotTransferAmount;
                    sinv.func_70299_a(slot, targetStack);
                    stack.field_77994_a -= slotTransferAmount;
                    transferred += slotTransferAmount;
                    continue;
                }
                if (!barrel.sameItem(targetStack) || (slotTransferAmount = Math.min(slotTransferAmount, targetStack.func_77976_d() - targetStack.field_77994_a)) <= 0) continue;
                targetStack.field_77994_a += slotTransferAmount;
                stack.field_77994_a -= slotTransferAmount;
                transferred += slotTransferAmount;
            }
            if (transferred > 0) {
                return true;
            }
        } else if (target instanceof IInventory) {
            IInventory inv = (IInventory)target;
            int nslots = inv.func_70302_i_();
            int maxInventoryStackLimit = inv.func_70297_j_();
            int transferred = 0;
            for (int slot = 0; slot < nslots && transferred != transferAmount; ++slot) {
                if (!inv.func_94041_b(slot, stack)) continue;
                ItemStack targetStack = inv.func_70301_a(slot);
                int slotTransferAmount = Math.min(transferAmount - transferred, maxInventoryStackLimit);
                if (targetStack == null) {
                    targetStack = stack.func_77946_l();
                    targetStack.field_77994_a = slotTransferAmount;
                    inv.func_70299_a(slot, targetStack);
                    stack.field_77994_a -= slotTransferAmount;
                    transferred += slotTransferAmount;
                    continue;
                }
                if (!barrel.sameItem(targetStack) || (slotTransferAmount = Math.min(slotTransferAmount, targetStack.func_77976_d() - targetStack.field_77994_a)) <= 0) continue;
                targetStack.field_77994_a += slotTransferAmount;
                stack.field_77994_a -= slotTransferAmount;
                transferred += slotTransferAmount;
            }
            if (transferred > 0) {
                return true;
            }
        }
        return false;
    }

    private ItemStack pullMatchingItemFromInventory(TileEntity source, ForgeDirection side, IBarrelStorage barrel, int maxTransfer) {
        block5: {
            block6: {
                ItemStack testStack;
                block4: {
                    if (!LogicHopper.isMFRLoaded() || !(source instanceof IDeepStorageUnit)) break block4;
                    IDeepStorageUnit dsu = (IDeepStorageUnit)source;
                    ItemStack stack = dsu.getStoredItemType();
                    if (stack != null && barrel.sameItem(stack) && stack.field_77994_a > 0) {
                        stack = stack.func_77946_l();
                        int transferAmount = Math.min(maxTransfer, stack.field_77994_a);
                        dsu.setStoredItemCount(stack.field_77994_a - transferAmount);
                        stack.field_77994_a = transferAmount;
                        return stack;
                    }
                    break block5;
                }
                if (!(source instanceof ISidedInventory) || side.ordinal() <= -1) break block6;
                ISidedInventory sinv = (ISidedInventory)source;
                int[] islots = sinv.func_94128_d(side.ordinal());
                ItemStack itemStack = testStack = barrel.hasItem() ? barrel.getItem().func_77946_l() : null;
                if (testStack != null) {
                    testStack.field_77994_a = maxTransfer;
                }
                for (int slot : islots) {
                    ItemStack stack = sinv.func_70301_a(slot);
                    if ((testStack != null || stack != null) && !sinv.func_102008_b(slot, testStack != null ? testStack : stack, side.ordinal()) || stack == null || !barrel.sameItem(stack) || stack.field_77994_a <= 0) continue;
                    return sinv.func_70298_a(slot, Math.min(maxTransfer, stack.field_77994_a));
                }
                break block5;
            }
            if (!(source instanceof IInventory)) break block5;
            IInventory inv = (IInventory)source;
            int nslots = inv.func_70302_i_();
            for (int slot = 0; slot < nslots; ++slot) {
                ItemStack stack = inv.func_70301_a(slot);
                if (stack == null || !barrel.sameItem(stack) || stack.field_77994_a <= 0) continue;
                return inv.func_70298_a(slot, Math.min(maxTransfer, stack.field_77994_a));
            }
        }
        return null;
    }

    static {
        isMFRLoaded = null;
    }
}

