/*
 * Decompiled with CFR 0.152.
 */
package glowredman.txloader;

import glowredman.txloader.Asset;
import glowredman.txloader.RemoteHandler;
import glowredman.txloader.TXLoaderCore;

public class AssetBuilder {
    private final Asset asset;

    AssetBuilder(String resourceLocation) {
        this.asset = new Asset(resourceLocation, RemoteHandler.latestRelease, Asset.Source.ASSET);
        this.asset.addedByMod = true;
    }

    public AssetBuilder setOverride(String resourceLocationOverride) {
        this.asset.resourceLocationOverride = resourceLocationOverride;
        return this;
    }

    public AssetBuilder setForced() {
        this.asset.forceLoad = true;
        return this;
    }

    public AssetBuilder setVersion(String version) {
        this.asset.version = version;
        return this;
    }

    public AssetBuilder setSource(Asset.Source source) {
        this.asset.source = source;
        return this;
    }

    public void add() {
        TXLoaderCore.REMOTE_ASSETS.add(this.asset);
    }
}

