/*
 * Decompiled with CFR 0.152.
 */
package magicbees.tileentity;

import cpw.mods.fml.common.Optional;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.apiculture.genetics.BeeGenome;
import java.util.Objects;
import magicbees.bees.BeeManager;
import magicbees.bees.BeeSpecies;
import magicbees.main.Config;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumicenergistics.api.storage.IAspectStorage;

@Optional.InterfaceList(value={@Optional.Interface(iface="thaumicenergistics.api.storage.IAspectStorage", modid="thaumicenergistics")})
public class TileEntityApimancersDrainerCommon
extends TileEntity
implements IEssentiaTransport,
IAspectContainer,
IAspectStorage {
    public Aspect aspect;
    public AspectList essentia = new AspectList();
    public final int maxAmount = Config.drainerCapacity;
    protected int increment = 0;

    public void setAspect(Aspect sAspect) {
        this.aspect = sAspect;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.aspect == null || this.essentia.visSize() == this.maxAmount) {
            return;
        }
        if (this.increment >= Config.drainerTimeBetween) {
            this.increment = 0;
            try {
                TileEntity above = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                IBeeHousing beeHousing = this.beeHousing(above);
                if (beeHousing != null) {
                    if (!this.canWork(beeHousing, above)) {
                        return;
                    }
                    ItemStack queenStack = this.getQueen(beeHousing, above);
                    IAlleleBeeSpecies queenSpecies = BeeGenome.getSpecies((ItemStack)queenStack);
                    if (queenSpecies == null) {
                        return;
                    }
                    if (BeeManager.beeRoot.getType(queenStack) != EnumBeeType.QUEEN) {
                        return;
                    }
                    if (Objects.equals(queenSpecies.getUID(), BeeSpecies.TC_ESSENTIA.getSpecies().getUID())) {
                        IBeeModifier modifier = BeeManager.beeRoot.createBeeHousingModifier(beeHousing);
                        IBee queen = BeeManager.beeRoot.getMember(queenStack);
                        int amount = Config.drainerAmount * this.getProductionMultiplier(modifier, queen, above);
                        this.addToContainer(this.aspect, amount);
                        this.drainQueen(beeHousing, modifier, queen);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ++this.increment;
    }

    protected IBeeHousing beeHousing(TileEntity above) {
        return above instanceof IBeeHousing ? (IBeeHousing)above : null;
    }

    protected boolean canWork(IBeeHousing beeHousing, TileEntity above) {
        IBeekeepingLogic beekeepingLogic = beeHousing.getBeekeepingLogic();
        return beekeepingLogic.canWork();
    }

    protected ItemStack getQueen(IBeeHousing beeHousing, TileEntity te) {
        return beeHousing.getBeeInventory().getQueen();
    }

    protected int getProductionMultiplier(IBeeModifier modifier, IBee queen, TileEntity te) {
        IBeekeepingMode mode = BeeManager.beeRoot.getBeekeepingMode(te.func_145831_w());
        IBeeGenome genome = queen.getGenome();
        float genomeSpeed = genome.getSpeed();
        float productionMultiplier = modifier.getProductionModifier(genome, 1.0f);
        productionMultiplier += mode != null ? mode.getBeeModifier().getProductionModifier(genome, productionMultiplier) : 0.0f;
        float minimum = Math.max(productionMultiplier += genomeSpeed, 1.0f);
        return (int)Math.ceil(minimum);
    }

    private void drainQueen(IBeeHousing housing, IBeeModifier modifier, IBee queen) {
        float lifespanModifier = modifier.getLifespanModifier(queen.getGenome(), queen.getMate(), 1.0f);
        queen.age(housing.getWorld(), lifespanModifier);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        queen.writeToNBT(nbttagcompound);
        housing.getBeeInventory().getQueen().func_77982_d(nbttagcompound);
    }

    @Optional.Method(modid="thaumicenergistics")
    public int getContainerCapacity() {
        return this.maxAmount;
    }

    @Optional.Method(modid="thaumicenergistics")
    public boolean doesShareCapacity() {
        return true;
    }

    public AspectList getAspects() {
        return this.essentia;
    }

    public void setAspects(AspectList aspects) {
        this.essentia = aspects;
    }

    public boolean doesContainerAccept(Aspect tag) {
        return false;
    }

    public int addToContainer(Aspect tag, int am) {
        int toAdd = Math.min(this.maxAmount - this.essentia.visSize(), am);
        if (this.aspect.equals(tag) && toAdd > 0) {
            this.essentia.add(this.aspect, toAdd);
            this.func_70296_d();
            return am - toAdd;
        }
        this.func_70296_d();
        return am;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.essentia.getAmount(tag) >= amount) {
            this.essentia.reduce(tag, amount);
            return true;
        }
        return false;
    }

    public boolean takeFromContainer(AspectList ot) {
        boolean hasIt = true;
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        for (Aspect next : ot.aspects.keySet()) {
            if (this.essentia.getAmount(next) >= ot.getAmount(next)) continue;
            hasIt = false;
        }
        if (hasIt) {
            for (Aspect next : ot.aspects.keySet()) {
                this.essentia.reduce(next, ot.getAmount(next));
            }
            return true;
        }
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return this.essentia.getAmount(tag) >= amount;
    }

    public boolean doesContainerContain(AspectList ot) {
        boolean hasIt = true;
        for (Aspect next : ot.aspects.keySet()) {
            if (this.essentia.getAmount(next) >= ot.getAmount(next)) continue;
            hasIt = false;
        }
        return hasIt;
    }

    public int containerContains(Aspect tag) {
        return this.essentia.getAmount(tag);
    }

    public boolean isConnectable(ForgeDirection face) {
        return face != ForgeDirection.UP;
    }

    public boolean canInputFrom(ForgeDirection face) {
        return false;
    }

    public boolean canOutputTo(ForgeDirection face) {
        return face != ForgeDirection.UP;
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection face) {
        if (face != ForgeDirection.UP) {
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (amount > this.essentia.getAmount(aspect)) {
                int total = this.essentia.getAmount(aspect);
                this.essentia.reduce(aspect, total);
                return total;
            }
            this.essentia.reduce(aspect, amount);
            return amount;
        }
        return 0;
    }

    public void setSuction(Aspect aspect, int amount) {
    }

    public int getMinimumSuction() {
        return -1;
    }

    public int getSuctionAmount(ForgeDirection face) {
        return -1;
    }

    public boolean renderExtendedTube() {
        return false;
    }

    public Aspect getSuctionType(ForgeDirection face) {
        return null;
    }

    public Aspect getEssentiaType(ForgeDirection face) {
        return this.essentia.size() > 0 ? this.essentia.getAspects()[this.field_145850_b.field_73012_v.nextInt(this.essentia.getAspects().length)] : null;
    }

    public int getEssentiaAmount(ForgeDirection face) {
        return this.essentia.visSize();
    }

    public int addEssentia(Aspect aspect, int amount, ForgeDirection face) {
        return this.canInputFrom(face) ? amount - this.addToContainer(aspect, amount) : 0;
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.essentia.writeToNBT(compound);
        if (this.aspect != null) {
            compound.func_74778_a("aspect", this.aspect.getTag());
        }
        compound.func_74768_a("increment", this.increment);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.essentia.readFromNBT(compound);
        if (this.essentia.visSize() > this.maxAmount) {
            this.essentia = new AspectList();
        }
        if (compound.func_74764_b("aspect")) {
            this.aspect = Aspect.getAspect((String)compound.func_74779_i("aspect"));
        }
        this.increment = compound.func_74762_e("increment");
    }
}

