/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.gthandler;

import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class DTPFCalculator {
    protected long duration = -1L;
    protected ItemStack customInput = null;
    protected long ebfEUpertick = 0L;
    protected long ebfDuration = 0L;
    protected long freezerEUpertick = 0L;
    protected long freezerDuration = 0L;
    protected long baseParallel = 1L;
    protected long DTPFEUt = 0L;
    protected long totalBaseEU = 0L;
    protected long minCatalystTier = 0L;
    protected long maxCatalystTier = 3L;
    protected long catalystDiscount = 0L;
    protected long processingTimeDiscount = 0L;
    protected long recipeDuration = 0L;
    protected long scalingFactor = 2L;
    protected float EUtDivisor = 1.0f;
    Collection<GTRecipe> ebfRecipes = RecipeMaps.blastFurnaceRecipes.getAllRecipes();
    Collection<GTRecipe> freezerRecipes = RecipeMaps.vacuumFreezerRecipes.getAllRecipes();
    private int[] catalystAmounts = new int[5];
    private static final FluidStack[] CATALYSTS = new FluidStack[]{MaterialsUEVplus.ExcitedDTCC.getFluid(1L), MaterialsUEVplus.ExcitedDTPC.getFluid(1L), MaterialsUEVplus.ExcitedDTRC.getFluid(1L), MaterialsUEVplus.ExcitedDTEC.getFluid(1L), MaterialsUEVplus.ExcitedDTSC.getFluid(1L)};
    private static final long[] CATALYST_ENERGY_VALUES = new long[]{14514983L, 66768460L, 269326451L, 1073007393L, 4276767521L};

    public DTPFCalculator calculateGenericEBFBasedRecipe(Materials material) {
        this.determineEBFParams(material);
        this.determineFreezerParams(material);
        this.calculateBaseDTPFPowerConsumption();
        this.calculateCatalystAmounts(this.ebfDuration);
        return this;
    }

    public DTPFCalculator calculateNonEBFRecipe(long baseVoltage, long baseDuration) {
        this.recipeDuration = baseDuration;
        this.calculateNonEBFBaseDTPFPowerConsumption(baseVoltage, baseDuration);
        this.calculateCatalystAmounts(baseDuration);
        return this;
    }

    private void determineEBFParams(Materials material) {
        ArrayList<GTRecipe> foundEBFRecipes = new ArrayList<GTRecipe>();
        ItemStack input = material.getDust(1);
        if (this.customInput != null) {
            input = this.customInput;
        }
        for (GTRecipe recipe : this.ebfRecipes) {
            if (!GTUtility.areStacksEqual((ItemStack)input, (ItemStack)recipe.mInputs[0])) continue;
            foundEBFRecipes.add(recipe);
        }
        for (GTRecipe recipe : foundEBFRecipes) {
            if (recipe.mFluidInputs.length == 0) {
                this.ebfDuration = (long)((double)recipe.mDuration * 0.3);
                this.ebfEUpertick = recipe.mEUt;
                continue;
            }
            if (!recipe.mFluidInputs[0].isFluidEqual(Materials.Radon.getGas(1000L))) continue;
            this.ebfDuration = (long)((double)recipe.mDuration / 0.7 * 0.3);
            this.ebfEUpertick = recipe.mEUt;
            break;
        }
        this.recipeDuration = this.ebfDuration;
    }

    private void determineFreezerParams(Materials material) {
        for (GTRecipe recipe : this.freezerRecipes) {
            if (recipe.mInputs.length == 0 || !GTUtility.areStacksEqual((ItemStack)GTOreDictUnificator.get((OrePrefixes)OrePrefixes.ingotHot, (Object)material, (long)1L), (ItemStack)recipe.mInputs[0])) continue;
            this.freezerDuration = recipe.mDuration;
            this.freezerEUpertick = recipe.mEUt;
            break;
        }
    }

    private void calculateBaseDTPFPowerConsumption() {
        this.totalBaseEU = (this.freezerEUpertick * this.freezerDuration + this.ebfEUpertick * this.ebfDuration) * this.baseParallel;
        this.DTPFEUt = this.totalBaseEU / this.ebfDuration / 10L;
        while ((double)this.DTPFEUt > 2.147483647E9 / Math.pow(this.scalingFactor, this.maxCatalystTier - this.minCatalystTier)) {
            this.DTPFEUt /= this.scalingFactor;
        }
    }

    private void calculateNonEBFBaseDTPFPowerConsumption(long baseVoltage, long baseDuration) {
        this.totalBaseEU = baseVoltage * baseDuration * this.baseParallel;
        this.DTPFEUt = this.totalBaseEU / baseDuration / 10L;
        while ((double)this.DTPFEUt > 2.147483647E9 / Math.pow(this.scalingFactor, this.maxCatalystTier - this.minCatalystTier)) {
            this.DTPFEUt /= this.scalingFactor;
        }
    }

    private void calculateCatalystAmounts(long recipeDuration) {
        for (long i = 0L; i <= this.maxCatalystTier - this.minCatalystTier; ++i) {
            this.catalystAmounts[(int)(this.minCatalystTier + i)] = (int)(((double)this.totalBaseEU * (0.8 - (double)i * 0.1) * Math.pow(this.scalingFactor, i) - (double)this.DTPFEUt * Math.pow(this.scalingFactor, i) * ((double)recipeDuration / Math.pow(this.scalingFactor, i + 1L)) / (double)this.EUtDivisor) / (double)CATALYST_ENERGY_VALUES[(int)(this.minCatalystTier + i)] * (double)(1.0f - (float)this.catalystDiscount / 100.0f));
        }
    }

    public DTPFCalculator setBaseParallel(long parallel) {
        this.baseParallel = parallel;
        return this;
    }

    public DTPFCalculator setLowestCatalystTier(long tier) {
        this.minCatalystTier = tier;
        return this;
    }

    public DTPFCalculator setHighestCatalystTier(long tier) {
        this.maxCatalystTier = tier;
        return this;
    }

    public DTPFCalculator setCatalystDiscount(long discount) {
        this.catalystDiscount = discount;
        return this;
    }

    public DTPFCalculator setProcessingTimeDiscount(long discount) {
        this.processingTimeDiscount = discount;
        return this;
    }

    public DTPFCalculator setEUtDivisor(float divisor) {
        this.EUtDivisor = divisor;
        return this;
    }

    public DTPFCalculator setCustomEBFinputItem(ItemStack item) {
        this.customInput = item;
        return this;
    }

    public DTPFCalculator setScalingFactor(long factor) {
        this.scalingFactor = factor;
        return this;
    }

    public long getDuration(int catalystTier) {
        return (long)((double)this.recipeDuration / Math.pow(this.scalingFactor, (long)(catalystTier + 1) - this.minCatalystTier) * (double)(1.0f - (float)this.processingTimeDiscount / 100.0f));
    }

    public long getEUt(int catalystTier) {
        return (long)((double)this.DTPFEUt * Math.pow(this.scalingFactor, (long)catalystTier - this.minCatalystTier) / (double)this.EUtDivisor);
    }

    public long getCatalystAmount(int catalystTier) {
        return this.catalystAmounts[catalystTier];
    }

    public long getResidueAmount(int catalystTier) {
        return (long)((double)this.catalystAmounts[catalystTier] * (Math.pow(2.0, catalystTier) / 8.0));
    }

    public static DTPFCalculator dtpfCalculator() {
        return new DTPFCalculator();
    }
}

