/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.math;

import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;

public class Alignment {
    public final int x;
    public final int y;
    public static final Alignment TopLeft = new Alignment(-1, -1);
    public static final Alignment TopCenter = new Alignment(0, -1);
    public static final Alignment TopRight = new Alignment(1, -1);
    public static final Alignment CenterLeft = new Alignment(-1, 0);
    public static final Alignment Center = new Alignment(0, 0);
    public static final Alignment CenterRight = new Alignment(1, 0);
    public static final Alignment BottomLeft = new Alignment(-1, 1);
    public static final Alignment BottomCenter = new Alignment(0, 1);
    public static final Alignment BottomRight = new Alignment(1, 1);
    public static final Alignment[] ALL = new Alignment[]{TopLeft, TopCenter, TopRight, CenterLeft, Center, CenterRight, BottomLeft, BottomCenter, BottomRight};
    public static final Alignment[] CORNERS = new Alignment[]{TopLeft, TopRight, BottomLeft, BottomRight};

    public Alignment(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Pos2d getAlignedPos(Size parent, Size child) {
        float x = (float)(this.x + 1) * 1.0f / 2.0f;
        float y = (float)(this.y + 1) * 1.0f / 2.0f;
        return new Pos2d((float)parent.width * x - (float)child.width * x, (float)parent.height * y - (float)child.height * y);
    }
}

