/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity.tank;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import openblocks.client.renderer.tileentity.tank.INeighbourMap;
import openblocks.client.renderer.tileentity.tank.TankRenderUtils;
import openblocks.common.tileentity.TileEntityTank;

public class NeighbourMap
implements INeighbourMap {
    private boolean[] neighbors = new boolean[64];

    public NeighbourMap(World world, int x, int y, int z, FluidStack fluid) {
        if (world == null) {
            return;
        }
        this.testNeighbour(world, fluid, x + 0, y + 1, z + 0, 16);
        this.testNeighbour(world, fluid, x + 0, y - 1, z + 0, 32);
        this.testNeighbour(world, fluid, x + 1, y + 0, z + 0, 8);
        this.testNeighbour(world, fluid, x - 1, y + 0, z + 0, 4);
        this.testNeighbour(world, fluid, x + 0, y + 0, z + 1, 2);
        this.testNeighbour(world, fluid, x + 0, y + 0, z - 1, 1);
        this.testNeighbour(world, fluid, x + 1, y + 1, z + 0, 24);
        this.testNeighbour(world, fluid, x - 1, y + 1, z + 0, 20);
        this.testNeighbour(world, fluid, x + 0, y + 1, z + 1, 18);
        this.testNeighbour(world, fluid, x + 0, y + 1, z - 1, 17);
        this.testNeighbour(world, fluid, x + 1, y - 1, z + 0, 40);
        this.testNeighbour(world, fluid, x - 1, y - 1, z + 0, 36);
        this.testNeighbour(world, fluid, x + 0, y - 1, z + 1, 34);
        this.testNeighbour(world, fluid, x + 0, y - 1, z - 1, 33);
        this.testNeighbour(world, fluid, x - 1, y + 0, z - 1, 5);
        this.testNeighbour(world, fluid, x - 1, y + 0, z + 1, 6);
        this.testNeighbour(world, fluid, x + 1, y + 0, z + 1, 10);
        this.testNeighbour(world, fluid, x + 1, y + 0, z - 1, 9);
    }

    private void testNeighbour(World world, FluidStack ownFluid, int x, int y, int z, int flag) {
        TileEntity te = TankRenderUtils.getTileEntitySafe(world, x, y, z);
        if (te instanceof TileEntityTank) {
            this.neighbors[flag] = ((TileEntityTank)te).accepts(ownFluid);
        }
    }

    @Override
    public boolean hasDirectNeighbour(int direction) {
        return this.neighbors[direction];
    }

    @Override
    public boolean hasDiagonalNeighbour(int direction1, int direction2) {
        return this.neighbors[direction1 | direction2];
    }
}

