/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.render.TextureManager;
import forestry.core.tiles.IIngredientsSearchController;
import forestry.core.tiles.IngredientsStorage;
import forestry.core.utils.StringUtil;
import java.util.Locale;
import net.minecraft.util.IIcon;

public class SearchIngregientsLedger
extends Ledger {
    private final IIngredientsSearchController ingredientsSearch;

    public SearchIngregientsLedger(LedgerManager manager, IIngredientsSearchController ingredientsSearch) {
        super(manager, "search_ingredients");
        this.ingredientsSearch = ingredientsSearch;
        this.maxHeight = 36;
    }

    private boolean isSwitchButton(int mouseX, int mouseY) {
        int shiftX = this.currentShiftX + 20;
        int shiftY = this.currentShiftY + 8;
        return mouseX >= shiftX && (float)mouseX <= (float)this.currentShiftX + this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + 24;
    }

    @Override
    public void draw(int x, int y) {
        this.drawBackground(x, y);
        IIcon icon = TextureManager.getInstance().getDefault("misc/search_ingredients." + this.ingredientsSearch.getIngredientsStorage().toString().toLowerCase(Locale.ENGLISH));
        this.drawIcon(icon, x + 3, y + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        this.drawHeader(StringUtil.localize("gui.search_ingredients"), x + 22, y + 8);
        this.drawText(StringUtil.localize("gui.search_ingredients." + this.ingredientsSearch.getIngredientsStorage().toString().toLowerCase(Locale.ENGLISH)), x + 22, y + 20);
    }

    @Override
    public String getTooltip() {
        return StringUtil.localize("gui.search_ingredients") + ": " + StringUtil.localize("gui.search_ingredients." + this.ingredientsSearch.getIngredientsStorage().toString().toLowerCase(Locale.ENGLISH));
    }

    @Override
    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        if (this.isSwitchButton(x, y)) {
            IngredientsStorage ingredientsStorage = this.ingredientsSearch.getIngredientsStorage();
            IngredientsStorage newIngredientsStorage = mouseButton == 0 ? ingredientsStorage.next() : ingredientsStorage.previous();
            this.ingredientsSearch.setIngredientsStorage(newIngredientsStorage);
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptMouseButton(int mouseButton) {
        return mouseButton == 0 || mouseButton == 1;
    }
}

