/*
 * Decompiled with CFR 0.152.
 */
package tterrag.wailaplugins.plugins;

import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.api.rituals.Rituals;
import WayofTime.alchemicalWizardry.common.items.armour.BoundArmour;
import WayofTime.alchemicalWizardry.common.tileEntity.TEAltar;
import WayofTime.alchemicalWizardry.common.tileEntity.TEMasterStone;
import WayofTime.alchemicalWizardry.common.tileEntity.TETeleposer;
import WayofTime.alchemicalWizardry.common.tileEntity.TEWritingTable;
import com.enderio.core.common.util.BlockCoord;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.List;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import tterrag.wailaplugins.api.Plugin;
import tterrag.wailaplugins.config.WPConfigHandler;
import tterrag.wailaplugins.plugins.PluginBase;

@Plugin(name="Blood Magic", deps={"AWWayofTime"}, order=1)
public class PluginBloodMagic
extends PluginBase {
    private static final String KEY_CURRENT_LP = "lp";
    private static final String KEY_CAPACITY = "cap";
    private static final String KEY_TIER = "tier";
    private static final String KEY_PROGRESS = "prog";
    private static final String KEY_RESULT_STACK = "resStack";
    private static final String KEY_OWNER = "owner";
    private static final String KEY_RITUAL_NAME = "ritName";
    private static final String KEY_STACK_NAME = "stackName";
    private static final Field liquidRequired = ReflectionHelper.findField(TEAltar.class, (String[])new String[]{"liquidRequired"});

    @Override
    public void load(IWailaRegistrar registrar) {
        super.load(registrar);
        this.registerBody(TEAltar.class, TEWritingTable.class, TEMasterStone.class, TETeleposer.class);
        this.registerNBT(TEAltar.class, TEWritingTable.class, TEMasterStone.class, TETeleposer.class);
        this.addConfig("altar");
        this.addConfig("chemistrySet");
        this.addConfig("masterStone");
        this.addConfig("teleposer");
    }

    @Override
    public void getBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor) {
        ((ITaggedList)currenttip).removeEntries((Object)"IFluidHandler");
        boolean hasSeer = false;
        boolean hasSigil = false;
        switch (WPConfigHandler.sigilRequirement) {
            case 0: {
                hasSigil = true;
                hasSeer = true;
                break;
            }
            case 1: {
                hasSeer = this.searchInventory(ModItems.itemSeerSigil, accessor.getPlayer()) != null;
                hasSigil = hasSeer || this.searchInventory(ModItems.divinationSigil, accessor.getPlayer()) != null;
                break;
            }
            case 2: {
                hasSeer = accessor.getPlayer().func_70694_bm() != null && accessor.getPlayer().func_70694_bm().func_77973_b() == ModItems.itemSeerSigil;
                hasSigil = hasSeer || accessor.getPlayer().func_70694_bm() != null && accessor.getPlayer().func_70694_bm().func_77973_b() == ModItems.divinationSigil;
                break;
            }
        }
        hasSeer |= !WPConfigHandler.seerBenefit;
        TileEntity te = accessor.getTileEntity();
        NBTTagCompound tag = accessor.getNBTData();
        if (hasSigil && te instanceof TEAltar && this.getConfig("altar")) {
            currenttip.add(lang.localize("currentLP") + tag.func_74762_e(KEY_CURRENT_LP));
            currenttip.add(lang.localize("capacity") + tag.func_74762_e(KEY_CAPACITY));
            currenttip.add(lang.localize(KEY_TIER) + tag.func_74762_e(KEY_TIER));
            if (hasSeer && tag.func_74764_b(KEY_PROGRESS)) {
                currenttip.add(lang.localize("progress") + tag.func_74762_e(KEY_PROGRESS) + "%");
            }
        }
        if (te instanceof TEWritingTable && this.getConfig("chemistrySet")) {
            currenttip.add(lang.localize("progress") + tag.func_74762_e(KEY_PROGRESS) + "%");
            if (tag.func_74764_b(KEY_RESULT_STACK)) {
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l(KEY_RESULT_STACK));
                currenttip.add(stack.func_82833_r());
            }
        }
        if (te instanceof TEMasterStone && this.getConfig("masterStone")) {
            String ritualName;
            String owner = tag.func_74779_i(KEY_OWNER);
            if (!owner.isEmpty()) {
                currenttip.add(lang.localize(KEY_OWNER) + tag.func_74779_i(KEY_OWNER));
            }
            if (!(ritualName = tag.func_74779_i(KEY_RITUAL_NAME)).isEmpty()) {
                currenttip.add(Rituals.getNameOfRitual((String)ritualName));
            }
        }
        if (te instanceof TETeleposer && this.getConfig("teleposer")) {
            TETeleposer teleposer = (TETeleposer)te;
            te.func_145839_a(tag);
            if (teleposer.func_70301_a(0) != null) {
                currenttip.add(teleposer.func_70301_a(0).func_82833_r());
            }
        }
    }

    private ItemStack searchInventory(Item item, EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || stack.func_77973_b() != item) continue;
            return stack.func_77946_l();
        }
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (stack == null || !(stack.func_77973_b() instanceof BoundArmour)) continue;
            for (ItemStack sigil : ((BoundArmour)stack.func_77973_b()).getInternalInventory(stack)) {
                if (sigil == null || sigil.func_77973_b() != item) continue;
                return sigil;
            }
        }
        return null;
    }

    @Override
    protected void getNBTData(TileEntity te, NBTTagCompound tag, World world, BlockCoord pos) {
        if (!liquidRequired.isAccessible()) {
            liquidRequired.setAccessible(true);
        }
        if (te instanceof TEAltar) {
            TEAltar altar = (TEAltar)te;
            tag.func_74768_a(KEY_CURRENT_LP, altar.getCurrentBlood());
            tag.func_74768_a(KEY_CAPACITY, altar.getCapacity());
            tag.func_74768_a(KEY_TIER, altar.getTier());
            if (altar.isActive()) {
                int cur = altar.getProgress();
                int max = liquidRequired.getInt(altar) * altar.func_70301_a((int)0).field_77994_a;
                tag.func_74768_a(KEY_PROGRESS, (int)((double)cur / (double)max * 100.0));
            }
        }
        if (te instanceof TEWritingTable) {
            NBTTagCompound datahack = new NBTTagCompound();
            te.func_145841_b(datahack);
            tag.func_74768_a(KEY_PROGRESS, datahack.func_74762_e("progress"));
            NBTTagCompound stack = new NBTTagCompound();
            if (((TEWritingTable)te).getResultingItemStack() != null) {
                ((TEWritingTable)te).getResultingItemStack().func_77955_b(stack);
                tag.func_74782_a(KEY_RESULT_STACK, (NBTBase)stack);
            }
        }
        if (te instanceof TEMasterStone) {
            tag.func_74778_a(KEY_OWNER, ((TEMasterStone)te).getOwner());
            tag.func_74778_a(KEY_RITUAL_NAME, ((TEMasterStone)te).getCurrentRitual());
        }
        if (te instanceof TETeleposer && ((TETeleposer)te).func_70301_a(0) != null) {
            tag.func_74778_a(KEY_STACK_NAME, ((TETeleposer)te).func_70301_a(0).func_82833_r());
        }
    }
}

