/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.model.render;

import com.gtnewhorizons.navigator.api.model.locations.ILocationProvider;
import com.gtnewhorizons.navigator.api.model.steps.UniversalRenderStep;
import com.gtnewhorizons.navigator.api.util.DrawUtils;
import com.sinthoras.visualprospecting.integration.model.locations.UndergroundFluidLocation;
import net.minecraft.client.resources.I18n;

public class UndergroundFluidRenderStep
extends UniversalRenderStep<UndergroundFluidLocation> {
    public UndergroundFluidRenderStep(UndergroundFluidLocation location) {
        super((ILocationProvider)location);
        this.setSize(128.0);
        this.setFontScale(0.5);
    }

    public void draw(double topX, double topY, float drawScale, double zoom) {
        int maxAmountInField = ((UndergroundFluidLocation)this.location).getMaxProduction();
        int borderColor = ((UndergroundFluidLocation)this.location).getFluid().getColor();
        DrawUtils.drawHollowRect((double)topX, (double)topY, (double)this.getAdjustedWidth(), (double)this.getAdjustedHeight(), (int)borderColor, (int)255, (double)2.0);
        if (this.getZoomStep() >= 1.0 && !this.isMinimap()) {
            String label = I18n.func_135052_a((String)"visualprospecting.empty", (Object[])new Object[0]);
            if (maxAmountInField > 0) {
                label = ((UndergroundFluidLocation)this.location).getMinProduction() + "L - " + maxAmountInField + "L  " + ((UndergroundFluidLocation)this.location).getFluid().getLocalizedName();
            }
            DrawUtils.drawLabel((String)label, (double)(topX + this.getAdjustedWidth() / 2.0), (double)topY, (int)-1, (int)-1275068416, (boolean)true, (double)this.getFontScale());
        }
    }
}

