/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.util;

import com.gtnewhorizon.structurelib.util.MiscUtils;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class ItemStackPredicate
implements Predicate<ItemStack> {
    private final Item item;
    private int meta = -1;
    private NBTTagCompound tag;
    private NBTMode mode = NBTMode.IGNORE;

    public static ItemStackPredicate from(Item item) {
        return new ItemStackPredicate(item);
    }

    public static ItemStackPredicate from(ItemStack itemStack) {
        return new ItemStackPredicate(itemStack.func_77973_b()).setMeta(Items.field_151008_G.getDamage(itemStack));
    }

    public static ItemStackPredicate from(ItemStack itemStack, NBTMode mode) {
        return new ItemStackPredicate(itemStack.func_77973_b()).setMeta(Items.field_151008_G.getDamage(itemStack)).setTag(mode, itemStack.field_77990_d);
    }

    public static ItemStackPredicate from(Block block) {
        return new ItemStackPredicate(Item.func_150898_a((Block)block));
    }

    private ItemStackPredicate(Item item) {
        this.item = item;
    }

    public ItemStackPredicate ignoreMeta() {
        this.meta = -1;
        return this;
    }

    public ItemStackPredicate setMeta(int meta) {
        this.meta = meta;
        return this;
    }

    public ItemStackPredicate setTag(NBTMode mode, NBTTagCompound tag) {
        this.mode = mode;
        this.tag = tag;
        return this;
    }

    @Override
    public boolean test(ItemStack itemStack) {
        if (this.item != null && itemStack.func_77973_b() != this.item) {
            return false;
        }
        if (this.meta != -1 && Items.field_151008_G.getDamage(itemStack) != this.meta) {
            return false;
        }
        return this.mode.test(this.tag, itemStack.field_77990_d);
    }

    public static enum NBTMode implements BiPredicate<NBTTagCompound, NBTTagCompound>
    {
        IGNORE{

            @Override
            public boolean test(NBTTagCompound lhs, NBTTagCompound rhs) {
                return true;
            }
        }
        ,
        IN{

            @Override
            public boolean test(NBTTagCompound lhs, NBTTagCompound rhs) {
                if (lhs == null || lhs.func_82582_d()) {
                    return true;
                }
                if (rhs == null || rhs.func_82582_d()) {
                    return false;
                }
                for (String key : MiscUtils.getTagKeys(lhs)) {
                    if (!rhs.func_150297_b(key, (int)lhs.func_150299_b(key))) {
                        return false;
                    }
                    NBTBase tag = lhs.func_74781_a(key);
                    if (!(tag instanceof NBTTagCompound ? !this.test((NBTTagCompound)tag, rhs.func_74775_l(key)) : !tag.equals((Object)rhs.func_74781_a(key)))) continue;
                    return false;
                }
                return true;
            }
        }
        ,
        EXACT{

            @Override
            public boolean test(NBTTagCompound lhs, NBTTagCompound rhs) {
                if (lhs != null && lhs.func_82582_d()) {
                    lhs = null;
                }
                if (rhs != null && rhs.func_82582_d()) {
                    rhs = null;
                }
                return Objects.equals(lhs, rhs);
            }
        }
        ,
        IGNORE_KNOWN_INSIGNIFICANT_TAGS{

            @Override
            public boolean test(NBTTagCompound lhs, NBTTagCompound rhs) {
                if (rhs == null || rhs.func_82582_d()) {
                    return lhs == null || lhs.func_82582_d();
                }
                rhs = (NBTTagCompound)rhs.func_74737_b();
                for (String s : KNOWN_INSIGNIFICANT_TAGS) {
                    rhs.func_82580_o(s);
                }
                return EXACT.test(lhs, rhs);
            }
        };

        private static final String[] KNOWN_INSIGNIFICANT_TAGS;

        static {
            KNOWN_INSIGNIFICANT_TAGS = new String[]{"display"};
        }
    }
}

