/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.enhancedlootbags.integration.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemStackMap;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import eu.usrv.enhancedlootbags.EnhancedLootBags;
import eu.usrv.enhancedlootbags.core.LootGroupsHandler;
import eu.usrv.enhancedlootbags.core.serializer.LootGroups;
import eu.usrv.enhancedlootbags.integration.nei.TooltipStack;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class LootBagRecipeHandler
extends TemplateRecipeHandler {
    private static final int SLOT_NUM_X = 11;
    private static final DecimalFormat chanceFormat = new DecimalFormat("##0.##");

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(93, 20, 15, 13), this.getOverlayIdentifier(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier()) && ((Object)((Object)this)).getClass() == LootBagRecipeHandler.class) {
            for (LootGroups.LootGroup lootGroup : this.getLootGroups()) {
                this.arecipes.add(new CachedLootBagRecipe(lootGroup, null, 0));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (LootGroups.LootGroup lootGroup : this.getLootGroups()) {
            if (!lootGroup.getDrops().stream().anyMatch(d -> NEIServerUtils.areStacksSameTypeCrafting((ItemStack)result, (ItemStack)d.getItemStack()))) continue;
            this.arecipes.add(new CachedLootBagRecipe(lootGroup, result, 0));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (LootGroups.LootGroup lootGroup : this.getLootGroups()) {
            ItemStack lootBagStack = lootGroup.createLootBagItemStack();
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ingredient, (ItemStack)lootBagStack)) continue;
            this.arecipes.add(new CachedLootBagRecipe(lootGroup, null, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)ingredient)));
        }
    }

    private List<LootGroups.LootGroup> getLootGroups() {
        return EnhancedLootBags.LootGroupHandler.getLootGroups().getLootTable();
    }

    public void drawExtras(int recipe) {
        CachedLootBagRecipe cachedRecipe = (CachedLootBagRecipe)((Object)this.arecipes.get(recipe));
        String toDraw = cachedRecipe.lootGroup.getGroupID() != 0 ? I18n.func_135052_a((String)"enhancedlootbags.nei.recipe.contains_trash", (Object[])new Object[]{LootBagRecipeHandler.translateBoolean(cachedRecipe.lootGroup.getCombineWithTrash())}) : I18n.func_135052_a((String)"enhancedlootbags.nei.recipe.is_trash", (Object[])new Object[0]);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(toDraw, 2, 216, 0);
    }

    public void drawBackground(int recipeIndex) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)207, (int)232);
        CachedLootBagRecipe recipe = (CachedLootBagRecipe)((Object)this.arecipes.get(recipeIndex));
        Point focus = recipe.focus;
        if (focus != null) {
            GuiDraw.drawTexturedModalRect((int)focus.x, (int)focus.y, (int)212, (int)0, (int)18, (int)18);
        }
    }

    public List<String> handleItemTooltip(GuiRecipe<?> gui, ItemStack cursorStack, List<String> currenttip, int recipe) {
        CachedLootBagRecipe cachedRecipe = (CachedLootBagRecipe)((Object)this.arecipes.get(recipe));
        for (PositionedStack pStack : cachedRecipe.outputs) {
            TooltipStack tStack;
            List<String> tooltip;
            if (!gui.isMouseOver(pStack, recipe) || !(pStack instanceof TooltipStack) || (tooltip = (tStack = (TooltipStack)pStack).getTooltip(cursorStack)) == null) continue;
            currenttip.addAll(tooltip);
            break;
        }
        return currenttip;
    }

    public String getGuiTexture() {
        return new ResourceLocation("enhancedlootbags", "textures/gui/nei.png").toString();
    }

    public String getOverlayIdentifier() {
        return "enhancedlootbags";
    }

    public String getHandlerId() {
        return "enhancedlootbags";
    }

    public String getRecipeName() {
        return I18n.func_135052_a((String)"enhancedlootbags.nei.category", (Object[])new Object[0]);
    }

    private static String translateBoolean(boolean b) {
        return b ? I18n.func_135052_a((String)"enhancedlootbags.nei.recipe.true", (Object[])new Object[0]) : I18n.func_135052_a((String)"enhancedlootbags.nei.recipe.false", (Object[])new Object[0]);
    }

    private class CachedLootBagRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final List<PositionedStack> input;
        private final List<PositionedStack> outputs;
        private final LootGroups.LootGroup lootGroup;
        private Point focus;

        public CachedLootBagRecipe(LootGroups.LootGroup lootGroup, ItemStack focusStack, int fortuneLevel) {
            super((TemplateRecipeHandler)LootBagRecipeHandler.this);
            this.input = new ArrayList<PositionedStack>();
            this.outputs = new ArrayList<PositionedStack>();
            this.lootGroup = lootGroup;
            ItemStack lootBagStack = lootGroup.createLootBagItemStack();
            if (fortuneLevel > 0) {
                lootBagStack.func_77966_a(Enchantment.field_77346_s, Math.min(fortuneLevel, LootGroupsHandler.FortuneLevel.LV3.level));
            }
            this.input.add(new PositionedStack((Object)lootBagStack, 92, 4));
            List<List<LootGroups.LootGroup.Drop>> sortedDrops = this.getDropGroups(lootGroup);
            sortedDrops.sort(Comparator.comparingInt(d -> -this.getAccumulatedWeight((List<LootGroups.LootGroup.Drop>)d)));
            int row = 0;
            int col = 0;
            for (List<LootGroups.LootGroup.Drop> dropGroup : sortedDrops) {
                ItemStackMap tooltips = new ItemStackMap();
                ArrayList<ItemStack> dropItems = new ArrayList<ItemStack>();
                for (LootGroups.LootGroup.Drop drop : dropGroup) {
                    ArrayList<String> tooltip = new ArrayList<String>();
                    ItemStack dropItem = drop.getItemStack();
                    if (dropItem == null) {
                        dropItem = new ItemStack((Block)Blocks.field_150480_ab);
                        tooltip.add(String.format("no entries found for item name \"%s\"", drop.getItemName()));
                    }
                    this.addTooltip(drop, tooltip, dropGroup, fortuneLevel);
                    dropItems.add(dropItem);
                    tooltips.put(dropItem, tooltip);
                }
                int xPos = 3 + 18 * col;
                int yPos = 33 + 18 * row;
                this.outputs.add(new TooltipStack(dropItems, xPos, yPos, (ItemStackMap<List<String>>)tooltips));
                if (++col >= 11) {
                    col = 0;
                    ++row;
                }
                if (focusStack == null || !dropItems.stream().anyMatch(stack -> NEIServerUtils.areStacksSameTypeCrafting((ItemStack)focusStack, (ItemStack)stack))) continue;
                this.focus = new Point(xPos - 1, yPos - 1);
            }
        }

        private void addTooltip(LootGroups.LootGroup.Drop drop, List<String> tooltip, List<LootGroups.LootGroup.Drop> dropGroup, int fortuneLevel) {
            if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
                tooltip.add(I18n.func_135052_a((String)"enhancedlootbags.nei.recipe.drop_id", (Object[])new Object[]{drop.getIdentifier()}));
            }
            if (drop.getIsRandomAmount()) {
                tooltip.add(I18n.func_135052_a((String)"enhancedlootbags.nei.recipe.amount_random", (Object[])new Object[]{1, drop.getAmount()}));
            } else {
                tooltip.add(I18n.func_135052_a((String)"enhancedlootbags.nei.recipe.amount_exact", (Object[])new Object[]{drop.getAmount()}));
            }
            if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
                tooltip.add(I18n.func_135052_a((String)"enhancedlootbags.nei.recipe.weight", (Object[])new Object[]{drop.getChance()}));
                tooltip.add(I18n.func_135052_a((String)"enhancedlootbags.nei.recipe.weight_accumulated", (Object[])new Object[]{this.getAccumulatedWeight(dropGroup)}));
            }
            tooltip.add(I18n.func_135052_a((String)"enhancedlootbags.nei.recipe.chance", (Object[])new Object[]{this.getPercentageString(dropGroup, this.lootGroup, LootGroupsHandler.FortuneLevel.LV0, fortuneLevel), this.getPercentageString(dropGroup, this.lootGroup, LootGroupsHandler.FortuneLevel.LV1, fortuneLevel), this.getPercentageString(dropGroup, this.lootGroup, LootGroupsHandler.FortuneLevel.LV2, fortuneLevel), this.getPercentageString(dropGroup, this.lootGroup, LootGroupsHandler.FortuneLevel.LV3, fortuneLevel)}));
            if (Minecraft.func_71410_x().field_71474_y.field_82882_x && !drop.getItemDropGroup().isEmpty()) {
                tooltip.add(I18n.func_135052_a((String)"enhancedlootbags.nei.recipe.drop_group", (Object[])new Object[]{drop.getItemDropGroup()}));
            }
            if (drop.getLimitedDropCount() > 0) {
                int currentDropCount = EnhancedLootBags.LootGroupHandler.getDropCount((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.lootGroup, drop);
                String toAdd = I18n.func_135052_a((String)"enhancedlootbags.nei.recipe.limit", (Object[])new Object[]{currentDropCount, drop.getLimitedDropCount()});
                if (currentDropCount >= drop.getLimitedDropCount()) {
                    toAdd = toAdd + " " + EnumChatFormatting.DARK_RED + I18n.func_135052_a((String)"enhancedlootbags.nei.recipe.limit_reached", (Object[])new Object[0]);
                }
                tooltip.add(toAdd);
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.input;
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.getCycledIngredients(LootBagRecipeHandler.this.cycleticks / 20, this.outputs);
        }

        private List<List<LootGroups.LootGroup.Drop>> getDropGroups(LootGroups.LootGroup lootGroup) {
            ArrayList<List<LootGroups.LootGroup.Drop>> ret = new ArrayList<List<LootGroups.LootGroup.Drop>>();
            block0: for (LootGroups.LootGroup.Drop drop : lootGroup.getDrops()) {
                if (drop.getItemDropGroup().isEmpty()) {
                    ret.add(Collections.singletonList(drop));
                    continue;
                }
                for (List list : ret) {
                    if (!((LootGroups.LootGroup.Drop)list.get(0)).getItemDropGroup().equalsIgnoreCase(drop.getItemDropGroup())) continue;
                    list.add(drop);
                    continue block0;
                }
                ret.add(new ArrayList<LootGroups.LootGroup.Drop>(Collections.singletonList(drop)));
            }
            return ret;
        }

        private String getPercentageString(List<LootGroups.LootGroup.Drop> dropGroup, LootGroups.LootGroup lootGroup, LootGroupsHandler.FortuneLevel levelToCompare, int actualLevel) {
            double percentage = dropGroup.stream().mapToDouble(d -> EnhancedLootBags.LootGroupHandler.calcPercentageFromWeight((LootGroups.LootGroup.Drop)d, lootGroup, levelToCompare)).sum();
            return (levelToCompare.level == actualLevel ? EnumChatFormatting.UNDERLINE.toString() : "") + chanceFormat.format(percentage) + EnumChatFormatting.RESET;
        }

        private int getAccumulatedWeight(List<LootGroups.LootGroup.Drop> dropGroup) {
            return dropGroup.stream().mapToInt(LootGroups.LootGroup.Drop::getChance).sum();
        }
    }
}

