/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.cc;

import dan200.computercraft.api.filesystem.IMount;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import pl.asie.computronics.Computronics;

public class ComputronicsFileMount
implements IMount {
    private final File root;
    private static final Constructor<?> jarMount;

    protected ComputronicsFileMount(File root) {
        this.root = root;
    }

    public boolean exists(String path) throws IOException {
        return new File(this.root, path).exists();
    }

    public boolean isDirectory(String path) throws IOException {
        return new File(this.root, path).isDirectory();
    }

    public void list(String path, List<String> contents) throws IOException {
        String[] paths;
        if (!this.root.exists() || !this.root.isDirectory()) {
            throw new IOException("Not a directory");
        }
        for (String s : paths = this.root.list()) {
            if (!new File(this.root, s).exists()) continue;
            contents.add(s);
        }
    }

    public long getSize(String path) throws IOException {
        File file = new File(this.root, path);
        if (file.exists()) {
            return file.isDirectory() ? 0L : file.length();
        }
        throw new FileNotFoundException(path);
    }

    public InputStream openForRead(String path) throws IOException {
        File file = new File(this.root, path);
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException(path);
        }
        return new FileInputStream(file);
    }

    public static IMount createMount(Class clazz, String domain, String root) {
        try {
            File file;
            URL url;
            boolean isArchive;
            String codeUrl;
            String innerPath = ("assets/" + domain + "/" + root.trim()).replace("//", "/");
            String codeSource = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
            if (codeSource.contains(".zip!") || codeSource.contains(".jar!")) {
                codeUrl = codeSource.substring(0, codeSource.lastIndexOf(33));
                isArchive = true;
            } else {
                codeUrl = codeSource;
                isArchive = false;
            }
            try {
                url = new URL(codeUrl);
            }
            catch (MalformedURLException e) {
                try {
                    url = new URL("file://" + codeUrl);
                }
                catch (MalformedURLException e1) {
                    url = null;
                }
            }
            if (url != null) {
                try {
                    file = new File(url.toURI());
                }
                catch (URISyntaxException e) {
                    file = new File(url.getPath());
                }
            } else {
                file = new File(codeSource);
            }
            if (isArchive) {
                if (jarMount != null) {
                    return (IMount)jarMount.newInstance(file, innerPath);
                }
            } else {
                String[] paths;
                if (!file.exists() || file.isDirectory()) {
                    return null;
                }
                File parent = new File(new File(file.getParent()), innerPath);
                if (parent.exists()) {
                    return new ComputronicsFileMount(file);
                }
                for (String s : paths = System.getProperty("java.class.path").split(System.getProperty("path.separator"))) {
                    File f = new File(new File(s), innerPath);
                    if (!f.exists()) continue;
                    return new ComputronicsFileMount(f);
                }
            }
            return null;
        }
        catch (Exception e) {
            Computronics.log.error("Unable to create ComputerCraft file mount", (Throwable)e);
            return null;
        }
    }

    static {
        Constructor<?> constr = null;
        try {
            constr = Class.forName("dan200.computercraft.core.filesystem.JarMount").getConstructor(File.class, String.class);
        }
        catch (Exception e) {
            Computronics.log.error("Unable to access ComputerCraft jar file mount", (Throwable)e);
        }
        jarMount = constr;
    }
}

