/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.tile.machine;

import cpw.mods.fml.relauncher.Side;
import galaxyspace.ACentauriSystem.ACBlocks;
import galaxyspace.BarnardsSystem.BRBlocks;
import galaxyspace.VegaSystem.VegaBlocks;
import galaxyspace.core.register.GSBlocks;
import java.util.HashSet;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.block.ITerraformableBlock;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.util.Annotations;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityConverterSurface
extends TileBaseElectricBlockWithInventory
implements IFluidHandler,
ISidedInventory,
IPacketReceiver {
    public static int PROCESS_TIME_REQUIRED = 130;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTimeRequired = PROCESS_TIME_REQUIRED;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank;
    public static ItemStack[] blocks = new ItemStack[]{new ItemStack((Block)GSBlocks.MercuryBlocks, 1, 0), new ItemStack((Block)GSBlocks.MercuryBlocks, 1, 1), new ItemStack((Block)GSBlocks.MercuryBlocks, 1, 2), new ItemStack((Block)GSBlocks.VenusBlocks, 1, 0), new ItemStack((Block)GSBlocks.VenusBlocks, 1, 1), new ItemStack((Block)GSBlocks.CeresBlocks, 1, 0), new ItemStack((Block)GSBlocks.CeresBlocks, 1, 1), new ItemStack((Block)GSBlocks.PlutoBlocks, 1, 0), new ItemStack((Block)GSBlocks.PlutoBlocks, 1, 1), new ItemStack((Block)GSBlocks.PlutoBlocks, 1, 2), new ItemStack((Block)GSBlocks.PlutoBlocks, 1, 3), new ItemStack((Block)GSBlocks.PlutoBlocks, 1, 4), new ItemStack((Block)GSBlocks.PlutoBlocks, 1, 5), new ItemStack((Block)GSBlocks.HaumeaBlocks, 1, 0), new ItemStack((Block)GSBlocks.MakemakeBlocks, 1, 0), new ItemStack((Block)GSBlocks.MakemakeBlocks, 1, 1), new ItemStack((Block)GSBlocks.PhobosBlocks, 1, 0), new ItemStack((Block)GSBlocks.PhobosBlocks, 1, 1), new ItemStack((Block)GSBlocks.PhobosBlocks, 1, 2), new ItemStack((Block)GSBlocks.DeimosBlocks, 1, 0), new ItemStack((Block)GSBlocks.DeimosBlocks, 1, 1), new ItemStack((Block)GSBlocks.IoBlocks, 1, 0), new ItemStack((Block)GSBlocks.IoBlocks, 1, 1), new ItemStack((Block)GSBlocks.IoBlocks, 1, 2), new ItemStack((Block)GSBlocks.EuropaBlocks, 1, 0), new ItemStack((Block)GSBlocks.GanymedeBlocks, 1, 0), new ItemStack((Block)GSBlocks.GanymedeBlocks, 1, 1), new ItemStack((Block)GSBlocks.CallistoBlocks, 1, 0), new ItemStack((Block)GSBlocks.CallistoBlocks, 1, 1), new ItemStack((Block)GSBlocks.EnceladusBlocks, 1, 1), new ItemStack((Block)GSBlocks.TitanBlocks, 1, 0), new ItemStack((Block)GSBlocks.TitanBlocks, 1, 1), new ItemStack((Block)GSBlocks.TitanBlocks, 1, 2), new ItemStack((Block)GSBlocks.OberonBlocks, 1, 0), new ItemStack((Block)GSBlocks.OberonBlocks, 1, 1), new ItemStack((Block)GSBlocks.OberonBlocks, 1, 2), new ItemStack((Block)GSBlocks.ProteusBlocks, 1, 0), new ItemStack((Block)GSBlocks.ProteusBlocks, 1, 1), new ItemStack((Block)GSBlocks.ProteusBlocks, 1, 2), new ItemStack((Block)GSBlocks.TritonBlocks, 1, 0), new ItemStack((Block)GSBlocks.TritonBlocks, 1, 1), new ItemStack((Block)GSBlocks.TritonBlocks, 1, 2), new ItemStack((Block)ACBlocks.ACentauriBbGrunt, 1, 0), new ItemStack((Block)ACBlocks.ACentauriBbSubGrunt, 1, 0), new ItemStack((Block)BRBlocks.BarnardaCGrass, 1, 0), new ItemStack((Block)BRBlocks.BarnardaCDirt, 1, 0), new ItemStack((Block)VegaBlocks.VegaBGrunt, 1, 0), new ItemStack((Block)VegaBlocks.VegaBSubGrunt, 1, 0)};
    private ItemStack[] containingItems;
    public final Set<EntityPlayer> playersUsing;
    private boolean initialised;

    public TileEntityConverterSurface() {
        this(1);
    }

    public TileEntityConverterSurface(int tier) {
        ((Object)((Object)this)).getClass();
        this.waterTank = new FluidTank(3000);
        this.containingItems = new ItemStack[6];
        this.playersUsing = new HashSet<EntityPlayer>();
        this.initialised = false;
        this.initialised = true;
        if (tier == 1) {
            this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 60.0f : 45.0f);
            return;
        }
        this.setTier2();
    }

    private void setTier2() {
        this.storage.setCapacity(25000.0f);
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 60.0f);
        this.processTimeRequired = 100;
        this.setTierGC(2);
    }

    public int getScaledWaterLevel(int i) {
        return this.waterTank.getFluidAmount() * i / this.waterTank.getCapacity();
    }

    public void func_145845_h() {
        if (!this.initialised) {
            int metadata = this.func_145832_p();
            Block b = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (b == GCBlocks.machineBase) {
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, GCBlocks.machineTiered, 4, 2);
            } else if (metadata >= 8) {
                this.setTier2();
            }
            this.initialised = true;
        }
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            boolean isWater;
            FluidStack liquid;
            if (this.containingItems[1] != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.containingItems[1])) != null && (isWater = FluidRegistry.getFluidName((FluidStack)liquid).startsWith("water")) && (this.waterTank.getFluid() == null || this.waterTank.getFluid().amount + liquid.amount <= this.waterTank.getCapacity())) {
                this.waterTank.fill(new FluidStack(FluidRegistry.WATER, liquid.amount), true);
                if (FluidContainerRegistry.isBucket((ItemStack)this.containingItems[1]) && FluidContainerRegistry.isFilledContainer((ItemStack)this.containingItems[1])) {
                    int amount = this.containingItems[1].field_77994_a;
                    if (amount > 1) {
                        this.waterTank.fill(new FluidStack(FluidRegistry.WATER, (amount - 1) * 1000), true);
                    }
                    this.containingItems[1] = new ItemStack(Items.field_151133_ar, amount);
                } else {
                    ItemStack itemStack = this.containingItems[1];
                    --itemStack.field_77994_a;
                    if (this.containingItems[1].field_77994_a == 0) {
                        this.containingItems[1] = null;
                    }
                }
            }
            if (this.canProcess()) {
                if (this.hasEnoughEnergyToRun) {
                    if (this.tierGC == 2) {
                        this.processTimeRequired = 200 / (1 + this.poweredByTierGC);
                    }
                    if (this.processTicks == 0) {
                        this.processTicks = this.processTimeRequired;
                    } else if (--this.processTicks <= 0) {
                        this.smeltItem();
                        this.processTicks = this.canProcess() ? this.processTimeRequired : 0;
                    }
                } else if (this.processTicks > 0 && this.processTicks < this.processTimeRequired && this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                    ++this.processTicks;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    public boolean canProcess() {
        return this.waterTank.getFluidAmount() != 0 && this.containingItems[2] != null && this.containingItems[3] != null && this.containingItems[4] != null && (this.containingItems[5] == null || this.containingItems[5].field_77994_a + 1 <= 64);
    }

    public void smeltItem() {
        if (this.canProcess()) {
            ItemStack itemStack = this.containingItems[2];
            --itemStack.field_77994_a;
            ItemStack itemStack2 = this.containingItems[3];
            --itemStack2.field_77994_a;
            ItemStack itemStack3 = this.containingItems[4];
            --itemStack3.field_77994_a;
            if (this.containingItems[5] == null) {
                this.containingItems[5] = new ItemStack((Block)Blocks.field_150349_c);
            } else {
                ItemStack itemStack4 = this.containingItems[5];
                ++itemStack4.field_77994_a;
            }
            this.waterTank.drain(100, true);
            if (this.containingItems[2].field_77994_a == 0) {
                this.containingItems[2] = null;
            }
            if (this.containingItems[3].field_77994_a == 0) {
                this.containingItems[3] = null;
            }
            if (this.containingItems[4].field_77994_a == 0) {
                this.containingItems[4] = null;
            }
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        if (this.storage.getEnergyStoredGC() > 16000.0f) {
            this.setTier2();
            this.initialised = true;
        } else {
            this.initialised = false;
        }
        this.processTicks = par1NBTTagCompound.func_74762_e("smeltingTicks");
        this.containingItems = this.readStandardItemsFromNBT(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74764_b("waterTank")) {
            this.waterTank.readFromNBT(par1NBTTagCompound.func_74775_l("waterTank"));
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        if (this.tierGC == 1 && this.storage.getEnergyStoredGC() > 16000.0f) {
            this.storage.setEnergyStored(16000.0f);
        }
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("smeltingTicks", this.processTicks);
        this.writeStandardItemsToNBT(par1NBTTagCompound);
        if (this.waterTank.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        }
    }

    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"tile.ConverterSurface.name");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        switch (slotID) {
            case 0: {
                return ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
            }
            case 1: {
                return itemStack == new ItemStack(Items.field_151131_as);
            }
            case 2: {
                return itemStack == new ItemStack(Items.field_151100_aR, 1, 15);
            }
            case 3: {
                return itemStack == new ItemStack(Items.field_151014_N);
            }
        }
        return itemStack.func_77973_b() instanceof ITerraformableBlock || this.func_94041_b(slotID, itemStack);
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3, 4};
    }

    public boolean func_102007_a(int slotID, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(slotID, par2ItemStack);
    }

    public boolean func_102008_b(int slotID, ItemStack par2ItemStack, int par3) {
        return slotID == 5;
    }

    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        String liquidName;
        int used = 0;
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.func_145832_p() + 2)).getOpposite()) && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null && liquidName.startsWith("water")) {
            used = this.waterTank.fill(resource, doFill);
        }
        return used;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.waterTank.getFluid() == null || this.waterTank.getFluidAmount() < this.waterTank.getCapacity();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.waterTank)};
    }
}

