/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.optimization;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import makamys.coretweaks.optimization.ThreadedTextureLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;

class TextureLoaderThread
extends Thread {
    ThreadedTextureLoader parent;

    public TextureLoaderThread(ThreadedTextureLoader parent, int index) {
        this.parent = parent;
        this.setName("Texture loader thread #" + String.valueOf(index));
        this.setDaemon(false);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    IResource res;
                    if (this.parent.queue.isEmpty()) {
                        this.say("No more images to load left.");
                    }
                    ThreadedTextureLoader.ResourceLoadJob job = this.parent.queue.take();
                    if (job.resource.isPresent()) {
                        res = job.resource.get();
                    } else {
                        ResourceLocation resLoc = job.resourceLocation.get();
                        boolean reuseRes = false;
                        if (reuseRes && this.parent.resMap.containsKey(resLoc)) {
                            ThreadedTextureLoader.Failable<IResource, IOException> resMaybe = this.parent.resMap.get(resLoc);
                            if (!resMaybe.present()) continue;
                            res = resMaybe.get();
                        } else {
                            try {
                                res = Minecraft.func_71410_x().func_110442_L().func_110536_a(resLoc);
                                this.parent.resMap.put(resLoc, ThreadedTextureLoader.Failable.of(res));
                            }
                            catch (IOException e) {
                                this.say("hmm, couldn't load " + resLoc);
                                this.parent.resMap.put(resLoc, ThreadedTextureLoader.Failable.failed(e));
                                res = null;
                            }
                            this.notifyIfWaitingOn(resLoc);
                        }
                    }
                    if (res == null) continue;
                    if (!this.parent.map.containsKey(res)) {
                        BufferedImage img;
                        try {
                            img = ImageIO.read(res.func_110527_b());
                            this.parent.map.put(res, ThreadedTextureLoader.Failable.of(img));
                        }
                        catch (IOException e) {
                            img = null;
                            this.say("hmm, couldn't load image " + res);
                            this.parent.map.put(res, ThreadedTextureLoader.Failable.failed(e));
                        }
                    }
                    this.notifyIfWaitingOn(res);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyIfWaitingOn(Object o) {
        List<ThreadedTextureLoader.ResourceLoadJob> list = ThreadedTextureLoader.waitingOn;
        synchronized (list) {
            if (!ThreadedTextureLoader.waitingOn.isEmpty()) {
                ThreadedTextureLoader.ResourceLoadJob job = ThreadedTextureLoader.waitingOn.get(0);
                if (o.equals(job.resource.orElse(null)) || o.equals(job.resourceLocation.orElse(null))) {
                    ThreadedTextureLoader.waitingOn.notify();
                }
            }
        }
    }

    void say(Object o) {
    }
}

