/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui.frame.components;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import me.flashyreese.mods.reeses_sodium_options.client.gui.OptionExtended;
import me.flashyreese.mods.reeses_sodium_options.client.gui.ReeseSodiumVideoOptionsScreen;
import me.flashyreese.mods.reeses_sodium_options.util.StringUtils;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.widgets.AbstractWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

public class SearchTextFieldComponent
extends AbstractWidget {
    protected final Dim2i dim;
    protected final List<OptionPage> pages;
    private final FontRenderer textRenderer;
    private final Predicate<String> textPredicate;
    private final AtomicReference<String> tabFrameSelectedTab;
    private final AtomicReference<Integer> tabFrameScrollBarOffset;
    private final AtomicReference<Integer> optionPageScrollBarOffset;
    private final int tabDimHeight;
    private final ReeseSodiumVideoOptionsScreen sodiumVideoOptionsScreen;
    private final AtomicReference<String> lastSearch;
    private final AtomicReference<Integer> lastSearchIndex;
    protected boolean selecting;
    protected String text;
    protected int maxLength;
    protected boolean visible;
    protected boolean editable;
    private int firstCharacterIndex;
    private int selectionStart;
    private int selectionEnd;
    private boolean focused;
    private int lastCursorPosition;

    public SearchTextFieldComponent(Dim2i dim, List<OptionPage> pages, AtomicReference<String> tabFrameSelectedTab, AtomicReference<Integer> tabFrameScrollBarOffset, AtomicReference<Integer> optionPageScrollBarOffset, int tabDimHeight, ReeseSodiumVideoOptionsScreen sodiumVideoOptionsScreen, AtomicReference<String> lastSearch, AtomicReference<Integer> lastSearchIndex) {
        this.textRenderer = Minecraft.func_71410_x().field_71466_p;
        this.textPredicate = Objects::nonNull;
        this.text = "";
        this.maxLength = 100;
        this.visible = true;
        this.editable = true;
        this.lastCursorPosition = this.getCursor();
        this.dim = dim;
        this.pages = pages;
        this.tabFrameSelectedTab = tabFrameSelectedTab;
        this.tabFrameScrollBarOffset = tabFrameScrollBarOffset;
        this.optionPageScrollBarOffset = optionPageScrollBarOffset;
        this.tabDimHeight = tabDimHeight;
        this.sodiumVideoOptionsScreen = sodiumVideoOptionsScreen;
        this.lastSearch = lastSearch;
        this.lastSearchIndex = lastSearchIndex;
        if (!lastSearch.get().trim().isEmpty()) {
            this.write(lastSearch.get());
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isFocused() && this.text.isEmpty()) {
            String key = "rso.search_bar_empty";
            String text = I18n.func_135052_a((String)"rso.search_bar_empty", (Object[])new Object[0]);
            if (text.equals("rso.search_bar_empty")) {
                text = "Search options...";
            }
            this.textRenderer.func_78276_b(text, this.dim.getOriginX() + 6, this.dim.getOriginY() + 6, -5592406);
        }
        this.drawRect(this.dim.getOriginX(), this.dim.getOriginY(), this.dim.getLimitX(), this.dim.getLimitY(), this.isFocused() ? -536870912 : -1879048192);
        int j = this.selectionStart - this.firstCharacterIndex;
        int k = this.selectionEnd - this.firstCharacterIndex;
        String string = this.textRenderer.func_78269_a(this.text.substring(this.firstCharacterIndex), this.getInnerWidth());
        boolean bl = j >= 0 && j <= string.length();
        int l = this.dim.getOriginX() + 6;
        int m = this.dim.getOriginY() + 6;
        int n = l;
        if (k > string.length()) {
            k = string.length();
        }
        if (!string.isEmpty()) {
            String string2 = bl ? string.substring(0, j) : string;
            n = this.textRenderer.func_78261_a(string2, n, m, 0xE0E0E0);
        }
        boolean bl3 = this.selectionStart < this.text.length() || this.text.length() >= this.getMaxLength();
        int o = n;
        if (!bl) {
            o = j > 0 ? l + this.dim.getWidth() - 12 : l;
        } else if (bl3) {
            --o;
            --n;
        }
        if (!string.isEmpty() && bl && j < string.length()) {
            this.textRenderer.func_78261_a(string.substring(j), n, m, 0xE0E0E0);
        }
        if (this.isFocused()) {
            this.drawRect(o, m - 1, o + 1, m + 1 + this.textRenderer.field_78288_b, -3092272);
        }
        if (k != j) {
            int p = l + this.textRenderer.func_78256_a(string.substring(0, k));
            this.drawSelectionHighlight(o, m - 1, p - 1, m + 1 + this.textRenderer.field_78288_b);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int i = MathHelper.func_76128_c((double)mouseX) - this.dim.getOriginX() - 6;
        String string = this.textRenderer.func_78269_a(this.text.substring(this.firstCharacterIndex), this.getInnerWidth());
        this.setCursor(this.textRenderer.func_78269_a(string, i).length() + this.firstCharacterIndex);
        this.setFocused(this.dim.containsCursor(mouseX, mouseY));
        this.pages.forEach(page -> page.getOptions().stream().filter(OptionExtended.class::isInstance).map(OptionExtended.class::cast).forEach(optionExtended -> optionExtended.setSelected(false)));
        return this.isFocused();
    }

    private void drawSelectionHighlight(int x1, int y1, int x2, int y2) {
        int i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        if (x2 > this.dim.getOriginX() + this.dim.getWidth()) {
            x2 = this.dim.getOriginX() + this.dim.getWidth();
        }
        if (x1 > this.dim.getOriginX() + this.dim.getWidth()) {
            x1 = this.dim.getOriginX() + this.dim.getWidth();
        }
        GL11.glEnable((int)3058);
        GL11.glLogicOp((int)5387);
        this.drawRect(x1, y1, x2, y2, -16776961);
        GL11.glDisable((int)3058);
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public String getSelectedText() {
        int i = Math.min(this.selectionStart, this.selectionEnd);
        int j = Math.max(this.selectionStart, this.selectionEnd);
        return this.text.substring(i, j);
    }

    public void write(String text) {
        String string2;
        String string;
        int l;
        int i = Math.min(this.selectionStart, this.selectionEnd);
        int j = Math.max(this.selectionStart, this.selectionEnd);
        int k = this.maxLength - this.text.length() - (i - j);
        if (k < (l = (string = text).length())) {
            string = string.substring(0, k);
            l = k;
        }
        if (this.textPredicate.test(string2 = new StringBuilder(this.text).replace(i, j, string).toString())) {
            this.text = string2;
            this.setSelectionStart(i + l);
            this.setSelectionEnd(this.selectionStart);
            this.onChanged(this.text);
        }
    }

    private void onChanged(String newText) {
        this.pages.forEach(page -> page.getOptions().stream().filter(OptionExtended.class::isInstance).map(OptionExtended.class::cast).forEach(optionExtended -> optionExtended.setHighlight(false)));
        this.lastSearch.set(newText.trim());
        if (this.editable && !newText.trim().isEmpty()) {
            List<Option<?>> fuzzy = StringUtils.fuzzySearch(this.pages, newText, 2);
            fuzzy.stream().filter(OptionExtended.class::isInstance).map(OptionExtended.class::cast).forEach(optionExtended -> optionExtended.setHighlight(true));
        }
    }

    private void erase(int offset) {
        if (GuiScreen.func_146271_m()) {
            this.eraseWords(offset);
        } else {
            this.eraseCharacters(offset);
        }
    }

    public void eraseWords(int wordOffset) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.selectionStart) {
                this.write("");
            } else {
                this.eraseCharacters(this.getWordSkipPosition(wordOffset) - this.selectionStart);
            }
        }
    }

    public void eraseCharacters(int characterOffset) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.selectionStart) {
                this.write("");
            } else {
                String string;
                int k;
                int i = this.getCursorPosWithOffset(characterOffset);
                int j = Math.min(i, this.selectionStart);
                if (j != (k = Math.max(i, this.selectionStart)) && this.textPredicate.test(string = new StringBuilder(this.text).delete(j, k).toString())) {
                    this.text = string;
                    this.setCursor(j);
                    this.onChanged(this.text);
                }
            }
        }
    }

    public int getWordSkipPosition(int wordOffset) {
        return this.getWordSkipPosition(wordOffset, this.getCursor());
    }

    private int getWordSkipPosition(int wordOffset, int cursorPosition) {
        return this.getWordSkipPosition(wordOffset, cursorPosition, true);
    }

    private int getWordSkipPosition(int wordOffset, int cursorPosition, boolean skipOverSpaces) {
        int i = cursorPosition;
        boolean bl = wordOffset < 0;
        int j = Math.abs(wordOffset);
        for (int k = 0; k < j; ++k) {
            if (!bl) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipOverSpaces && i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipOverSpaces && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public int getCursor() {
        return this.selectionStart;
    }

    public void setCursor(int cursor) {
        this.setSelectionStart(cursor);
        if (!this.selecting) {
            this.setSelectionEnd(this.selectionStart);
        }
        this.onChanged(this.text);
    }

    public void moveCursor(int offset) {
        this.setCursor(this.getCursorPosWithOffset(offset));
    }

    private int getCursorPosWithOffset(int offset) {
        return this.selectionStart + offset;
    }

    public void setSelectionStart(int cursor) {
        this.selectionStart = MathHelper.func_76125_a((int)cursor, (int)0, (int)this.text.length());
    }

    public void setCursorToStart() {
        this.setCursor(0);
    }

    public void setCursorToEnd() {
        this.setCursor(this.text.length());
    }

    public void setSelectionEnd(int index) {
        int i = this.text.length();
        this.selectionEnd = MathHelper.func_76125_a((int)index, (int)0, (int)i);
        if (this.textRenderer != null) {
            if (this.firstCharacterIndex > i) {
                this.firstCharacterIndex = i;
            }
            int j = this.getInnerWidth();
            String string = this.textRenderer.func_78269_a(this.text.substring(this.firstCharacterIndex), j);
            int k = string.length() + this.firstCharacterIndex;
            if (this.selectionEnd == this.firstCharacterIndex) {
                this.firstCharacterIndex -= this.textRenderer.func_78262_a(this.text, j, true).length();
            }
            if (this.selectionEnd > k) {
                this.firstCharacterIndex += this.selectionEnd - k;
            } else if (this.selectionEnd <= this.firstCharacterIndex) {
                this.firstCharacterIndex -= this.firstCharacterIndex - this.selectionEnd;
            }
            this.firstCharacterIndex = MathHelper.func_76125_a((int)this.firstCharacterIndex, (int)0, (int)i);
        }
    }

    public boolean isActive() {
        return this.isVisible() && this.isFocused() && this.isEditable();
    }

    @Override
    public boolean keyTyped(char typedChar, int keyCode) {
        this.pages.forEach(page2 -> page2.getOptions().stream().filter(OptionExtended.class::isInstance).map(OptionExtended.class::cast).forEach(optionExtended2 -> optionExtended2.setSelected(false)));
        if (!this.isActive()) {
            return false;
        }
        this.selecting = GuiScreen.func_146272_n();
        if (keyCode == 30 && GuiScreen.func_146271_m() && !GuiScreen.func_146272_n()) {
            this.setCursorToEnd();
            this.setSelectionEnd(0);
            return true;
        }
        if (keyCode == 46 && GuiScreen.func_146271_m() && !GuiScreen.func_146272_n()) {
            GuiScreen.func_146275_d((String)this.getSelectedText());
            return true;
        }
        if (keyCode == 47 && GuiScreen.func_146271_m() && !GuiScreen.func_146272_n()) {
            if (this.editable) {
                this.write(GuiScreen.func_146277_j());
            }
            return true;
        }
        if (keyCode == 45 && GuiScreen.func_146271_m() && !GuiScreen.func_146272_n()) {
            GuiScreen.func_146275_d((String)this.getSelectedText());
            if (this.editable) {
                this.write("");
            }
            return true;
        }
        switch (keyCode) {
            case 28: {
                if (this.editable) {
                    int count = 0;
                    for (OptionPage page : this.pages) {
                        for (Option option : page.getOptions()) {
                            OptionExtended optionExtended;
                            if (!(option instanceof OptionExtended) || !(optionExtended = (OptionExtended)option).isHighlight() || optionExtended.getParentDimension() == null) continue;
                            if (count == this.lastSearchIndex.get()) {
                                Dim2i optionDim = optionExtended.getDim2i();
                                Dim2i parentDim = optionExtended.getParentDimension();
                                int maxOffset = parentDim.getHeight() - this.tabDimHeight;
                                int input = optionDim.getOriginY() - parentDim.getOriginY();
                                int inputOffset = input + optionDim.getHeight() == parentDim.getHeight() ? parentDim.getHeight() : input;
                                int offset = inputOffset * maxOffset / parentDim.getHeight();
                                int total = this.pages.stream().mapToInt(page2 -> Math.toIntExact(page2.getOptions().stream().filter(OptionExtended.class::isInstance).map(OptionExtended.class::cast).filter(OptionExtended::isHighlight).count())).sum();
                                int value = total == this.lastSearchIndex.get() + 1 ? 0 : this.lastSearchIndex.get() + 1;
                                optionExtended.setSelected(true);
                                this.lastSearchIndex.set(value);
                                this.tabFrameSelectedTab.set(page.getName());
                                this.tabFrameScrollBarOffset.set(0);
                                this.optionPageScrollBarOffset.set(offset);
                                this.setFocused(false);
                                this.sodiumVideoOptionsScreen.rebuildGUI();
                                return true;
                            }
                            ++count;
                        }
                    }
                }
                return true;
            }
            case 14: {
                if (this.editable) {
                    this.selecting = false;
                    this.erase(-1);
                    this.selecting = GuiScreen.func_146272_n();
                }
                return true;
            }
            case 211: {
                if (this.editable) {
                    this.selecting = false;
                    this.erase(1);
                    this.selecting = GuiScreen.func_146272_n();
                }
                return true;
            }
            case 205: {
                if (GuiScreen.func_146271_m()) {
                    this.setCursor(this.getWordSkipPosition(1));
                } else {
                    this.moveCursor(1);
                }
                boolean state = this.getCursor() != this.lastCursorPosition && this.getCursor() != this.text.length() + 1;
                this.lastCursorPosition = this.getCursor();
                return state;
            }
            case 203: {
                if (GuiScreen.func_146271_m()) {
                    this.setCursor(this.getWordSkipPosition(-1));
                } else {
                    this.moveCursor(-1);
                }
                boolean state2 = this.getCursor() != this.lastCursorPosition && this.getCursor() != 0;
                this.lastCursorPosition = this.getCursor();
                return state2;
            }
            case 199: {
                this.setCursorToStart();
                return true;
            }
            case 207: {
                this.setCursorToEnd();
                return true;
            }
        }
        if (ChatAllowedCharacters.func_71566_a((char)typedChar)) {
            if (this.editable) {
                this.lastSearch.set(this.text.trim());
                this.write(Character.toString(typedChar));
                this.lastSearchIndex.set(0);
            }
            return true;
        }
        return false;
    }

    public int getInnerWidth() {
        return this.dim.getWidth() - 12;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public boolean isFocused() {
        return this.focused;
    }
}

