/*
 * Decompiled with CFR 0.152.
 */
package serverutils.task;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.INpc;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.WorldServer;
import serverutils.ServerUtilitiesConfig;
import serverutils.lib.data.Universe;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.text_components.Notification;
import serverutils.task.NotifyTask;
import serverutils.task.Task;

public class CleanupTask
extends Task {
    private static final Predicate<Entity> ENTITY_PREDICATE = entity -> {
        ServerUtilitiesConfig.Tasks.Cleanup config = ServerUtilitiesConfig.tasks.cleanup;
        if (entity instanceof EntityPlayer) {
            return false;
        }
        if (entity instanceof IAnimals && !(entity instanceof IMob) || entity instanceof INpc) {
            return config.passives;
        }
        if (entity instanceof IMob) {
            return config.hostiles;
        }
        if (entity instanceof EntityItem) {
            return config.items;
        }
        return config.experience && entity instanceof EntityXPOrb;
    };

    public CleanupTask() {
        super(Ticks.HOUR.x(ServerUtilitiesConfig.tasks.cleanup.interval));
    }

    @Override
    public void execute(Universe universe) {
        int removed = 0;
        for (WorldServer world : universe.server.field_71305_c) {
            for (Entity entity : new ArrayList(world.field_72996_f)) {
                if (!ENTITY_PREDICATE.test(entity)) continue;
                entity.func_70106_y();
                ++removed;
            }
        }
        Notification.of("removed_entities", new IChatComponent[]{new ChatComponentText(StatCollector.func_74837_a((String)"serverutilities.task.cleanup_removed", (Object[])new Object[]{removed}))}).sendToAll(universe.server);
    }

    @Override
    public List<NotifyTask> getNotifications() {
        ArrayList<NotifyTask> notifications = new ArrayList<NotifyTask>();
        if (ServerUtilitiesConfig.tasks.cleanup.silent) {
            return notifications;
        }
        Notification notification = Notification.of("cleanup_30", this.getNotificationString(30));
        NotifyTask task = new NotifyTask(this.nextTime - Ticks.SECOND.x(30L).millis(), notification);
        notifications.add(task);
        notification = Notification.of("cleanup_60", this.getNotificationString(60));
        task = new NotifyTask(this.nextTime - Ticks.SECOND.x(60L).millis(), notification);
        notifications.add(task);
        return notifications;
    }

    private IChatComponent getNotificationString(int seconds) {
        int index;
        ServerUtilitiesConfig.Tasks.Cleanup config = ServerUtilitiesConfig.tasks.cleanup;
        StringBuilder builder = new StringBuilder();
        if (config.hostiles) {
            builder.append(StatCollector.func_74838_a((String)"serverutilities.task.cleanup_hostiles"));
        }
        if (config.passives) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(StatCollector.func_74838_a((String)"serverutilities.task.cleanup_passives"));
        }
        if (config.items) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(StatCollector.func_74838_a((String)"serverutilities.task.cleanup_items"));
        }
        if (config.experience) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(StatCollector.func_74838_a((String)"serverutilities.task.cleanup_experience"));
        }
        if ((index = builder.lastIndexOf(",")) > 0) {
            builder.replace(index, index + 1, " &");
        }
        String finalString = StatCollector.func_74837_a((String)"serverutilities.task.cleanup_entity", (Object[])new Object[]{builder.toString().toLowerCase(), seconds});
        return StringUtils.color((IChatComponent)new ChatComponentText(finalString), EnumChatFormatting.LIGHT_PURPLE);
    }
}

