/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.handler.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.mixin.interfaces.accessors.PotionAccessor;
import gtPlusPlus.core.util.math.MathUtils;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;

public class PlayerSleepEventHandler {
    private static final ArrayList<Potion> potionBuffs = new ArrayList();

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new PlayerSleepEventHandler());
        potionBuffs.add(Potion.field_76424_c);
        potionBuffs.add(Potion.field_76427_o);
        potionBuffs.add(Potion.field_76429_m);
        potionBuffs.add(Potion.field_76428_l);
        potionBuffs.add(Potion.field_76420_g);
        potionBuffs.add(Potion.field_76422_e);
        potionBuffs.add(Potion.field_76426_n);
        potionBuffs.add(Potion.field_76434_w);
        potionBuffs.add(Potion.field_76444_x);
        potionBuffs.trimToSize();
    }

    @SubscribeEvent
    public void onPlayerWakeUp(PlayerWakeUpEvent event) {
        float maxHP;
        EntityPlayer player = event.entityPlayer;
        if (player == null || player.field_70170_p.field_72995_K) {
            return;
        }
        if (player.func_130014_f_().func_72820_D() % 24000L != 0L) {
            return;
        }
        ArrayList<Integer> potionToRemove = new ArrayList<Integer>();
        for (PotionEffect potionEffect : player.func_70651_bq()) {
            Potion potion = Potion.field_76425_a[potionEffect.func_76456_a()];
            if (!(potion instanceof PotionAccessor) || !((PotionAccessor)potion).gt5u$isBadEffect()) continue;
            potionToRemove.add(potion.field_76415_H);
        }
        for (Integer i : potionToRemove) {
            player.func_82170_o(i.intValue());
        }
        if (!potionToRemove.isEmpty()) {
            PlayerSleepEventHandler.messagePlayer(player, "sleep.event.downsides");
            return;
        }
        float currentHP = player.func_110143_aJ();
        if (currentHP < (maxHP = player.func_110138_aP())) {
            float missingHP = maxHP - currentHP;
            float heal = MathUtils.randFloat(1.0f, missingHP);
            player.func_70691_i(heal);
            PlayerSleepEventHandler.messagePlayer(player, heal >= missingHP / 2.0f ? "sleep.event.good" : "sleep.event.okay");
            return;
        }
        Potion aPotionToApply = potionBuffs.get(MathUtils.randInt(0, potionBuffs.size() - 1));
        player.func_70690_d(new PotionEffect(aPotionToApply.field_76415_H, MathUtils.randInt(60, 180) * 20, MathUtils.randInt(0, 2)));
        PlayerSleepEventHandler.messagePlayer(player, "sleep.event.wellrested");
    }

    private static void messagePlayer(EntityPlayer player, String aChatKey) {
        player.func_146105_b((IChatComponent)new ChatComponentTranslation(aChatKey, new Object[0]));
    }
}

