/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.generators;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicGenerator;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEMagicEnergyConverter
extends MTEBasicGenerator {
    public int mEfficiency;

    public MTEMagicEnergyConverter(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, "Put your strange stuff in here", new ITexture[0]);
        this.onConfigLoad();
    }

    public MTEMagicEnergyConverter(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
        this.onConfigLoad();
    }

    public MTEMagicEnergyConverter(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
        this.onConfigLoad();
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEMagicEnergyConverter(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.magicFuels;
    }

    @Override
    public int getCapacity() {
        return 16000;
    }

    @Override
    public void onConfigLoad() {
        this.mEfficiency = 100 - this.mTier * 5;
    }

    @Override
    public int getEfficiency() {
        return this.mEfficiency;
    }

    @Override
    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{super.getFront(aColor)[0], TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_MAGIC), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_MAGIC_GLOW).glow().build(), Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
    }

    @Override
    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{super.getBack(aColor)[0], TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_MAGIC_FRONT), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_MAGIC_FRONT_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{super.getBottom(aColor)[0], TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_MAGIC), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_MAGIC_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{super.getTop(aColor)[0], TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_MAGIC), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_MAGIC_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{super.getSides(aColor)[0], TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_MAGIC), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_MAGIC_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getFrontActive(byte aColor) {
        return new ITexture[]{super.getFrontActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE_GLOW).glow().build(), Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
    }

    @Override
    public ITexture[] getBackActive(byte aColor) {
        return new ITexture[]{super.getBackActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_MAGIC_FRONT_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_MAGIC_FRONT_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{super.getBottomActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{super.getTopActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{super.getSidesActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public int getPollution() {
        return 0;
    }
}

