/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.boilers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.ParticleFX;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.common.pollution.Pollution;
import gregtech.common.tileentities.boilers.MTEBoiler;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import org.jetbrains.annotations.NotNull;

public class MTEBoilerBronze
extends MTEBoiler {
    public MTEBoilerBronze(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, new String[]{"An early way to get Steam Power", "Produces 120L of Steam per second", "Causes " + GTMod.gregtechproxy.mPollutionSmallCoalBoilerPerSecond + " Pollution per second"}, new ITexture[0]);
    }

    public MTEBoilerBronze(int aID, String aName, String aNameRegional, String[] aDescription) {
        super(aID, aName, aNameRegional, aDescription, new ITexture[0]);
    }

    public MTEBoilerBronze(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    public MTEBoilerBronze(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[5][17][];
        ITexture[] texBottom = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_BRONZEBRICKS_BOTTOM)};
        ITexture[] texTop = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_BRONZEBRICKS_TOP), TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE)};
        ITexture[] texSide = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE), TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE)};
        ITexture[] texFront = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE), TextureFactory.of(Textures.BlockIcons.BOILER_FRONT), TextureFactory.builder().addIcon(Textures.BlockIcons.BOILER_FRONT_GLOW).glow().build()};
        ITexture[] texFrontActive = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE), TextureFactory.of(Textures.BlockIcons.BOILER_FRONT_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.BOILER_FRONT_ACTIVE_GLOW).glow().build()};
        for (int i = 0; i < 17; ++i) {
            rTextures[0][i] = texBottom;
            rTextures[1][i] = texTop;
            rTextures[2][i] = texSide;
            rTextures[3][i] = texFront;
            rTextures[4][i] = texFrontActive;
        }
        return rTextures;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEBoilerBronze(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRandomDisplayTick(IGregTechTileEntity aBaseMetaTileEntity) {
        if (aBaseMetaTileEntity.isActive()) {
            ForgeDirection frontFacing = aBaseMetaTileEntity.getFrontFacing();
            if ((frontFacing.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) == 0 && aBaseMetaTileEntity.getCoverIDAtSide(frontFacing) == 0 && !aBaseMetaTileEntity.getOpacityAtSide(frontFacing)) {
                double z;
                double x;
                double oX = (double)aBaseMetaTileEntity.getOffsetX(frontFacing, 1) + 0.5;
                double oY = aBaseMetaTileEntity.getOffsetY(frontFacing, 1);
                double oZ = (double)aBaseMetaTileEntity.getOffsetZ(frontFacing, 1) + 0.5;
                double offset = -0.48;
                double horizontal = (double)XSTR.XSTR_INSTANCE.nextFloat() * 10.0 / 16.0 - 0.3125;
                double y = oY + (double)XSTR.XSTR_INSTANCE.nextFloat() * 6.0 / 16.0;
                if (frontFacing == ForgeDirection.WEST) {
                    x = oX - -0.48;
                    z = oZ + horizontal;
                } else if (frontFacing == ForgeDirection.EAST) {
                    x = oX + -0.48;
                    z = oZ + horizontal;
                } else if (frontFacing == ForgeDirection.NORTH) {
                    x = oX + horizontal;
                    z = oZ - -0.48;
                } else {
                    x = oX + horizontal;
                    z = oZ + -0.48;
                }
                WorldSpawnedEventBuilder.ParticleEventBuilder particleEventBuilder = new WorldSpawnedEventBuilder.ParticleEventBuilder().setMotion(0.0, 0.0, 0.0).setPosition(x, y, z).setWorld(this.getBaseMetaTileEntity().getWorld());
                ((WorldSpawnedEventBuilder.ParticleEventBuilder)particleEventBuilder.setIdentifier((Enum)ParticleFX.SMOKE)).run();
                ((WorldSpawnedEventBuilder.ParticleEventBuilder)particleEventBuilder.setIdentifier((Enum)ParticleFX.FLAME)).run();
            }
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && aTick > 20L && this.mProcessingEnergy > 0 && aTick % 20L == 0L) {
            Pollution.addPollution(this.getBaseMetaTileEntity(), this.getPollution());
        }
    }

    @Override
    protected int getPollution() {
        return GTMod.gregtechproxy.mPollutionSmallCoalBoilerPerSecond;
    }

    @Override
    protected int getProductionPerSecond() {
        return 120;
    }

    @Override
    protected int getMaxTemperature() {
        return 500;
    }

    @Override
    protected int getEnergyConsumption() {
        return 1;
    }

    @Override
    protected int getCooldownInterval() {
        return 45;
    }

    @Override
    protected void updateFuel(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        ItemStack fuel = this.mInventory[2];
        int burnTime = TileEntityFurnace.func_145952_a((ItemStack)fuel);
        MTEBoilerBronze.getCombustionPotential(fuel, burnTime).ifPresent(ashMaterial -> {
            aBaseMetaTileEntity.func_70298_a(2, 1);
            this.mProcessingEnergy += burnTime / 10;
            boolean isABlock = !Block.func_149634_a((Item)fuel.func_77973_b()).equals(Blocks.field_150350_a);
            MTEBoilerBronze.combustFuel(burnTime, isABlock).map(dustSize -> GTOreDictUnificator.get(dustSize, ashMaterial, 1L)).ifPresent(ashes -> aBaseMetaTileEntity.addStackToSlot(3, (ItemStack)ashes));
        });
    }

    private static Optional<Materials> getCombustionPotential(ItemStack fuel, int burnTime) {
        if (burnTime / 10 <= 0 || FluidContainerRegistry.isFilledContainer((ItemStack)fuel)) {
            return Optional.empty();
        }
        String lowerCaseBlockName = Block.func_149634_a((Item)fuel.func_77973_b()).func_149739_a().toLowerCase();
        if (MTEBoilerBronze.couldProduceDarkAshes(fuel, lowerCaseBlockName)) {
            return Optional.of(Materials.DarkAsh);
        }
        if (MTEBoilerBronze.couldProduceRegularAshes(fuel, lowerCaseBlockName, burnTime)) {
            return Optional.of(Materials.Ash);
        }
        return Optional.empty();
    }

    private static boolean couldProduceDarkAshes(ItemStack fuel, String lowerCaseBlockName) {
        return GTUtility.isPartOfMaterials(fuel, Materials.Coal) || GTUtility.isPartOfMaterials(fuel, Materials.Lignite) || lowerCaseBlockName.matches("tile\\..+compressedcoal");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean couldProduceRegularAshes(ItemStack fuel, String lowerCaseBlockName, int burnTime) {
        if (GTUtility.isPartOfMaterials(fuel, Materials.Charcoal)) return true;
        if (GTUtility.isPartOfMaterials(fuel, Materials.Diamond)) return true;
        if (Stream.of("^tile\\..+charcoal", "^tile\\..+coke", "^tile\\..+railcraft.cube").anyMatch(lowerCaseBlockName::matches)) return true;
        if (Stream.of("fuelCoke", "fuelCactusCharcoal", "fuelCactusCoke", "fuelSugarCharcoal", "fuelSugarCoke").anyMatch(name -> GTOreDictUnificator.isItemStackInstanceOf(fuel, name))) return true;
        if (burnTime < 2000) return false;
        return true;
    }

    private static Optional<OrePrefixes> combustFuel(int burnTime, boolean isABlock) {
        if (isABlock) {
            return Optional.of(OrePrefixes.dust);
        }
        if (XSTR.XSTR_INSTANCE.nextInt(MTEBoilerBronze.getAshChanceBound(burnTime)) == 0) {
            if (burnTime > 100000) {
                return Optional.of(OrePrefixes.dust);
            }
            if (burnTime > 10000) {
                return Optional.of(OrePrefixes.dustSmall);
            }
            return Optional.of(OrePrefixes.dustTiny);
        }
        return Optional.empty();
    }

    private static int getAshChanceBound(int burnTime) {
        return 5 - Math.min(burnTime, 2000) / 400 + 2;
    }

    @Override
    protected boolean isItemValidFuel(@NotNull ItemStack stack) {
        return MTEBoilerBronze.getCombustionPotential(stack, TileEntityFurnace.func_145952_a((ItemStack)stack)).isPresent();
    }
}

