/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe.maps;

import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import gregtech.api.recipe.BasicUIPropertiesBuilder;
import gregtech.api.recipe.NEIRecipePropertiesBuilder;
import gregtech.api.recipe.RecipeMapFrontend;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.common.gui.modularui.UIHelper;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LargeNEIFrontend
extends RecipeMapFrontend {
    private static final int xDirMaxCount = 3;
    private static final int yOrigin = 8;
    private final int itemRowCount = this.getItemRowCount();
    private final int fluidRowCount = this.getFluidRowCount();

    public LargeNEIFrontend(BasicUIPropertiesBuilder uiPropertiesBuilder, NEIRecipePropertiesBuilder neiPropertiesBuilder) {
        super(uiPropertiesBuilder.logoPos(new Pos2d(80, 62)), neiPropertiesBuilder);
        this.neiProperties.recipeBackgroundSize = new Size(170, 82 + Math.max(this.itemRowCount + this.fluidRowCount - 4, 0) * 18);
    }

    @Override
    public List<Pos2d> getItemInputPositions(int itemInputCount) {
        return UIHelper.getGridPositions(itemInputCount, 16, 8, 3);
    }

    @Override
    public List<Pos2d> getItemOutputPositions(int itemOutputCount) {
        return UIHelper.getGridPositions(itemOutputCount, 106, 8, 3);
    }

    @Override
    public List<Pos2d> getFluidInputPositions(int fluidInputCount) {
        return UIHelper.getGridPositions(fluidInputCount, 16, 8 + this.itemRowCount * 18, 3);
    }

    @Override
    public List<Pos2d> getFluidOutputPositions(int fluidOutputCount) {
        return UIHelper.getGridPositions(fluidOutputCount, 106, 8 + this.itemRowCount * 18, 3);
    }

    private int getItemRowCount() {
        return (Math.max(this.uiProperties.maxItemInputs, this.uiProperties.maxItemOutputs) - 1) / 3 + 1;
    }

    private int getFluidRowCount() {
        return (Math.max(this.uiProperties.maxFluidInputs, this.uiProperties.maxFluidOutputs) - 1) / 3 + 1;
    }
}

