/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.interfaces;

public interface ICondition<O> {
    public boolean isTrue(O var1);

    public static class Equal<O>
    implements ICondition<O> {
        private final ICondition<O> mCondition1;
        private final ICondition<O> mCondition2;

        public Equal(ICondition<O> aCondition1, ICondition<O> aCondition2) {
            this.mCondition1 = aCondition1;
            this.mCondition2 = aCondition2;
        }

        @Override
        public boolean isTrue(O aObject) {
            return this.mCondition1.isTrue(aObject) == this.mCondition2.isTrue(aObject);
        }
    }

    public static class Xor<O>
    implements ICondition<O> {
        private final ICondition<O> mCondition1;
        private final ICondition<O> mCondition2;

        public Xor(ICondition<O> aCondition1, ICondition<O> aCondition2) {
            this.mCondition1 = aCondition1;
            this.mCondition2 = aCondition2;
        }

        @Override
        public boolean isTrue(O aObject) {
            return this.mCondition1.isTrue(aObject) != this.mCondition2.isTrue(aObject);
        }
    }

    public static class Nand<O>
    implements ICondition<O> {
        private final ICondition<O>[] mConditions;

        @SafeVarargs
        public Nand(ICondition<O> ... aConditions) {
            this.mConditions = aConditions;
        }

        @Override
        public boolean isTrue(O aObject) {
            for (ICondition<O> tCondition : this.mConditions) {
                if (tCondition.isTrue(aObject)) continue;
                return true;
            }
            return false;
        }
    }

    public static class And<O>
    implements ICondition<O> {
        private final ICondition<O>[] mConditions;

        @SafeVarargs
        public And(ICondition<O> ... aConditions) {
            this.mConditions = aConditions;
        }

        @Override
        public boolean isTrue(O aObject) {
            for (ICondition<O> tCondition : this.mConditions) {
                if (tCondition.isTrue(aObject)) continue;
                return false;
            }
            return true;
        }
    }

    public static class Nor<O>
    implements ICondition<O> {
        private final ICondition<O>[] mConditions;

        @SafeVarargs
        public Nor(ICondition<O> ... aConditions) {
            this.mConditions = aConditions;
        }

        @Override
        public boolean isTrue(O aObject) {
            for (ICondition<O> tCondition : this.mConditions) {
                if (!tCondition.isTrue(aObject)) continue;
                return false;
            }
            return true;
        }
    }

    public static class Or<O>
    implements ICondition<O> {
        private final ICondition<O>[] mConditions;

        @SafeVarargs
        public Or(ICondition<O> ... aConditions) {
            this.mConditions = aConditions;
        }

        @Override
        public boolean isTrue(O aObject) {
            for (ICondition<O> tCondition : this.mConditions) {
                if (!tCondition.isTrue(aObject)) continue;
                return true;
            }
            return false;
        }
    }

    public static class Not<O>
    implements ICondition<O> {
        private final ICondition<O> mCondition;

        public Not(ICondition<O> aCondition) {
            this.mCondition = aCondition;
        }

        @Override
        public boolean isTrue(O aObject) {
            return !this.mCondition.isTrue(aObject);
        }
    }
}

