/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.container.slot;

import com.creativemd.creativecore.common.container.slot.ContainerControl;
import com.creativemd.creativecore.common.gui.controls.GuiControl;
import com.creativemd.creativecore.common.gui.controls.container.GuiSlotControl;
import com.creativemd.creativecore.common.gui.event.container.SlotChangeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;

public class SlotControl
extends ContainerControl {
    public Slot slot;
    public ItemStack lastSended;

    public SlotControl(Slot slot) {
        this.slot = slot;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiControl createGuiControl() {
        GuiSlotControl control = new GuiSlotControl(this.slot.field_75223_e, this.slot.field_75221_f, this);
        return control;
    }

    @Override
    public void detectChange() {
        if (!ItemStack.func_77989_b((ItemStack)this.lastSended, (ItemStack)this.slot.func_75211_c())) {
            this.raiseEvent(new SlotChangeEvent(this));
            this.sendUpdate();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        if (this.slot.func_75216_d()) {
            this.slot.func_75211_c().func_77955_b(nbt);
        }
        this.lastSended = this.slot.func_75216_d() ? this.slot.func_75211_c().func_77946_l() : null;
        NBTTagCompound dragSlot = new NBTTagCompound();
        if (this.parent.player.field_71071_by.func_70445_o() != null) {
            this.parent.player.field_71071_by.func_70445_o().func_77955_b(dragSlot);
        }
        nbt.func_74782_a("drag", (NBTBase)dragSlot);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        switch (nbt.func_74762_e("type")) {
            case 0: {
                ItemStack stack = null;
                if (nbt.func_74764_b("id")) {
                    stack = ItemStack.func_77949_a((NBTTagCompound)nbt);
                }
                this.slot.func_75215_d(stack);
                ItemStack dragStack = null;
                if (nbt.func_74764_b("drag")) {
                    dragStack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("drag"));
                }
                this.parent.player.field_71071_by.func_70437_b(dragStack);
                break;
            }
            case 1: {
                this.onSlotClicked(nbt.func_74762_e("button"), nbt.func_74767_n("shift"), nbt.func_74762_e("scrolled"));
                break;
            }
            case 2: {
                this.dropItem(nbt.func_74767_n("ctrl"));
                break;
            }
            case 3: {
                this.splitStack(nbt.func_74759_k("slots"), ItemStack.func_77949_a((NBTTagCompound)nbt), nbt.func_74767_n("right"));
            }
        }
    }

    public void dropItem(boolean ctrl) {
        if (this.slot.func_75216_d()) {
            ItemStack drop = this.slot.func_75211_c().func_77946_l();
            if (ctrl) {
                this.slot.func_75215_d(null);
            } else {
                drop.field_77994_a = 1;
                ItemStack newStack = this.slot.func_75211_c();
                --newStack.field_77994_a;
                if (newStack.field_77994_a == 0) {
                    this.slot.func_75215_d(null);
                } else {
                    this.slot.func_75215_d(newStack);
                }
            }
            this.parent.player.func_71019_a(drop, true);
            this.slot.func_82870_a(this.parent.player, drop);
        }
    }

    public static ItemStack putItemInSlot(Slot slot, ItemStack stack) {
        boolean canStack = Container.func_94527_a((Slot)slot, (ItemStack)stack, (boolean)true);
        int stackSize = Math.min(slot.func_75219_a(), stack.func_77976_d());
        if (canStack && slot.func_75214_a(stack)) {
            int neededStackSize = stack.field_77994_a;
            if (slot.func_75216_d()) {
                stackSize -= slot.func_75211_c().field_77994_a;
            }
            if ((stackSize = Math.min(stackSize, neededStackSize)) > 0) {
                ItemStack inSlot = stack.func_77946_l();
                inSlot.field_77994_a = stackSize;
                if (slot.func_75216_d()) {
                    inSlot.field_77994_a += slot.func_75211_c().field_77994_a;
                }
                slot.func_75215_d(inSlot);
                stack.field_77994_a -= stackSize;
                if (stack.field_77994_a == 0) {
                    return null;
                }
            }
        }
        return stack;
    }

    public void switchItems() {
        ItemStack hand = this.parent.player.field_71071_by.func_70445_o();
        InventoryPlayer inventoryplayer = this.parent.player.field_71071_by;
        ItemStack slotItem = this.slot.func_75211_c();
        if (this.slot.func_75214_a(hand)) {
            boolean canStack = Container.func_94527_a((Slot)this.slot, (ItemStack)hand, (boolean)true);
            int stackSize = Math.min(this.slot.func_75219_a(), hand.func_77976_d());
            if (canStack && (!this.slot.func_75216_d() || this.slot.func_82869_a(this.parent.player))) {
                int neededStackSize = hand.field_77994_a;
                if (this.slot.func_75216_d()) {
                    stackSize -= slotItem.field_77994_a;
                }
                stackSize = Math.min(stackSize, neededStackSize);
                ItemStack inSlot = hand.func_77946_l();
                inSlot.field_77994_a = stackSize;
                if (this.slot.func_75216_d()) {
                    inSlot.field_77994_a += slotItem.field_77994_a;
                }
                this.slot.func_75215_d(inSlot);
                int left = neededStackSize - stackSize;
                if (left > 0) {
                    hand.field_77994_a = left;
                } else {
                    inventoryplayer.func_70437_b(null);
                }
            } else {
                int left = hand.field_77994_a - stackSize;
                if (left > 1) {
                    this.parent.player.func_71019_a(slotItem.func_77946_l(), true);
                }
                ItemStack inSlot = hand.func_77946_l();
                inSlot.field_77994_a = Math.min(stackSize, hand.field_77994_a);
                this.slot.func_75215_d(inSlot);
                hand.field_77994_a -= Math.min(stackSize, hand.field_77994_a);
                if (hand.field_77994_a == 0) {
                    inventoryplayer.func_70437_b(slotItem.func_77946_l());
                }
            }
        }
    }

    public void transferIntoOtherInventory(boolean reverse, int amount) {
        block5: {
            ItemStack stack;
            block6: {
                if (!this.slot.func_75216_d()) break block5;
                stack = this.slot.func_75211_c();
                if (!reverse) break block6;
                int stackSize = Math.min(this.slot.func_75219_a(), stack.func_77976_d());
                if ((stackSize -= stack.field_77994_a) <= 0) break block5;
                for (int i = 0; i < this.parent.controls.size(); ++i) {
                    boolean canStack;
                    if (!(this.parent.controls.get(i) instanceof SlotControl)) continue;
                    Slot mergeSlot = ((SlotControl)this.parent.controls.get((int)i)).slot;
                    if (mergeSlot.field_75224_c == this.slot.field_75224_c || !(canStack = Container.func_94527_a((Slot)this.slot, (ItemStack)stack, (boolean)true)) || !mergeSlot.func_75216_d() || mergeSlot.func_75211_c().field_77994_a <= 0) continue;
                    ++stack.field_77994_a;
                    --mergeSlot.func_75211_c().field_77994_a;
                    if (mergeSlot.func_75211_c().field_77994_a == 0) {
                        mergeSlot.func_75215_d(null);
                    }
                    return;
                }
                break block5;
            }
            if (amount > stack.field_77994_a) {
                amount = stack.field_77994_a;
            }
            ItemStack copy = stack.func_77946_l();
            copy.field_77994_a = amount;
            for (int i = 0; i < this.parent.controls.size(); ++i) {
                if (!(this.parent.controls.get(i) instanceof SlotControl)) continue;
                Slot mergeSlot = ((SlotControl)this.parent.controls.get((int)i)).slot;
                if (mergeSlot.field_75224_c == this.slot.field_75224_c) continue;
                stack.field_77994_a = (copy = SlotControl.putItemInSlot(mergeSlot, copy)) != null ? (stack.field_77994_a -= amount - copy.field_77994_a) : (stack.field_77994_a -= amount);
                if (this.slot.func_75211_c().field_77994_a == 0) {
                    this.slot.func_75215_d(null);
                    return;
                }
                if (copy != null) continue;
                return;
            }
        }
    }

    public void onSlotClicked(int mouseButton, boolean shift, int scrolled) {
        ItemStack hand = this.parent.player.field_71071_by.func_70445_o();
        InventoryPlayer inventoryplayer = this.parent.player.field_71071_by;
        ItemStack slotItem = this.slot.func_75211_c();
        boolean isWheel = false;
        if (mouseButton == 0) {
            if (this.slot.func_82869_a(this.parent.player)) {
                if (shift) {
                    this.transferIntoOtherInventory(false, 64);
                } else if (hand != null) {
                    this.switchItems();
                } else if (this.slot.func_75216_d()) {
                    inventoryplayer.func_70437_b(slotItem.func_77946_l());
                    this.slot.func_75215_d(null);
                    this.slot.func_82870_a(this.parent.player, inventoryplayer.func_70445_o());
                }
            }
        } else if (mouseButton == 1) {
            if (hand != null) {
                if (this.slot.func_75214_a(hand)) {
                    boolean canStack = Container.func_94527_a((Slot)this.slot, (ItemStack)hand, (boolean)true);
                    if (canStack) {
                        int stacksize = 1;
                        if (this.slot.func_75216_d()) {
                            stacksize += slotItem.field_77994_a;
                        }
                        stacksize = Math.min(stacksize, Math.min(this.slot.func_75219_a(), hand.func_77976_d()));
                        if (this.slot.func_75216_d() && stacksize > slotItem.field_77994_a || !this.slot.func_75216_d() && stacksize > 0) {
                            ItemStack inSlot = hand.func_77946_l();
                            inSlot.field_77994_a = stacksize;
                            this.slot.func_75215_d(inSlot);
                            --hand.field_77994_a;
                            if (hand.field_77994_a == 0) {
                                inventoryplayer.func_70437_b(null);
                            }
                        }
                    } else {
                        this.switchItems();
                    }
                }
            } else if (this.slot.func_75216_d() && this.slot.func_82869_a(this.parent.player)) {
                int amount = (slotItem.field_77994_a + 1) / 2;
                hand = this.slot.func_75209_a(amount);
                inventoryplayer.func_70437_b(hand);
                if (slotItem.field_77994_a == 0) {
                    this.slot.func_75215_d((ItemStack)null);
                }
                this.slot.func_82870_a(this.parent.player, inventoryplayer.func_70445_o());
            }
        } else if (mouseButton == 2) {
            if (hand == null && this.slot.func_75216_d() && this.parent.player.field_71075_bZ.field_75098_d) {
                ItemStack stack = slotItem.func_77946_l();
                stack.field_77994_a = stack.func_77976_d();
                inventoryplayer.func_70437_b(stack);
            }
        } else if (mouseButton == 3 && this.slot.func_82869_a(this.parent.player)) {
            this.transferIntoOtherInventory(scrolled == -1, 1);
        }
    }

    public void splitStack(int[] slots, ItemStack stack, boolean isRightClick) {
        stack = stack.func_77946_l();
        int StackPerSlot = MathHelper.func_76141_d((float)((float)stack.field_77994_a / (float)slots.length));
        if (isRightClick) {
            StackPerSlot = 1;
        }
        for (int i = 0; i < slots.length; ++i) {
            int use;
            SlotControl control = (SlotControl)this.parent.controls.get(slots[i]);
            int stackSize = Math.min(control.slot.func_75219_a(), stack.func_77976_d());
            if (control.slot.func_75216_d()) {
                stackSize -= control.slot.func_75211_c().field_77994_a;
            }
            if ((use = Math.min(StackPerSlot, Math.min(stackSize, stack.field_77994_a))) > 0) {
                int size = use;
                if (control.slot.func_75216_d()) {
                    size += control.slot.func_75211_c().field_77994_a;
                }
                ItemStack inSlot = stack.func_77946_l();
                inSlot.field_77994_a = size;
                control.slot.func_75215_d(inSlot);
            }
            stack.field_77994_a -= use;
        }
        if (stack.field_77994_a <= 0) {
            this.parent.player.field_71071_by.func_70437_b(null);
        } else {
            this.parent.player.field_71071_by.func_70437_b(stack.func_77946_l());
        }
    }
}

