/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils;

import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.block.BlockCursedEarth;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class ActivationRitual {
    public static int max_range = 8;
    public static int num_light = 0;
    public static int required_dirt = 20;
    public static int time_window = 500;

    public static boolean redstoneCirclePresent(World world, int x, int y, int z) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (!(dx != 0 | dz != 0) || world.func_147439_a(x + dx, y, z + dz) == Blocks.field_150488_af) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean altarInDarkness_Client(World world, int x, int y, int z) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (world.func_72925_a(EnumSkyBlock.Block, x + dx, y, z + dz) + world.func_72925_a(EnumSkyBlock.Sky, x + dx, y, z + dz) - world.func_72967_a(1.0f) <= 9) continue;
                return false;
            }
        }
        return world.func_72925_a(EnumSkyBlock.Block, x, y + 1, z) + world.func_72925_a(EnumSkyBlock.Sky, x, y + 1, z) - world.func_72967_a(1.0f) <= 9;
    }

    public static boolean altarInDarkness(World world, int x, int y, int z) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (world.func_72957_l(x + dx, y, z + dz) <= 9) continue;
                return false;
            }
        }
        return world.func_72957_l(x, y + 1, z) <= 9;
    }

    public static boolean altarCanSeeMoon(World world, int x, int y, int z) {
        return world.func_72937_j(x, y, z);
    }

    public static boolean altarOnEarth(World world, int x, int y, int z) {
        boolean hasDirt = false;
        for (int dx = -1; dx <= 1 && !hasDirt; ++dx) {
            for (int dz = -1; dz <= 1 && !hasDirt; ++dz) {
                if (world.func_147439_a(x + dx, y - 1, z + dz) == Blocks.field_150346_d || world.func_147439_a(x + dx, y - 1, z + dz) == Blocks.field_150349_c) continue;
                return false;
            }
        }
        return true;
    }

    public static int checkTime(long time) {
        if ((time %= 24000L) < (long)(18000 - time_window)) {
            return -1;
        }
        if (time > (long)(18000 + time_window)) {
            return 1;
        }
        return 0;
    }

    public static boolean naturalEarth(World world, int x, int y, int z) {
        int num_dirt = 0;
        block0: for (int dx = -max_range; dx <= max_range; ++dx) {
            block1: for (int dz = -max_range; dz <= max_range; ++dz) {
                if (dx * dx + dz * dz < max_range * max_range) {
                    for (int dy = Math.min(3 + world.func_72825_h(x + dx, z + dz) - y, max_range); dy >= -max_range; --dy) {
                        if (dx * dx + dy * dy + dz * dz <= max_range * max_range) {
                            Block id = world.func_147439_a(x + dx, y + dy, z + dz);
                            if (id == Blocks.field_150346_d || id == Blocks.field_150349_c) {
                                if (!ActivationRitual.canShift(world.func_147439_a(x + dx, y + dy + 1, z + dz)) || ++num_dirt <= required_dirt) continue block1;
                                return true;
                            }
                            if (!id.func_149662_c()) continue;
                            continue block1;
                        }
                        if (dy < 0) continue block1;
                    }
                    continue;
                }
                if (dz > 0) continue block0;
            }
        }
        return false;
    }

    public static boolean canShift(Block id) {
        if (id == Blocks.field_150350_a) {
            return true;
        }
        return id != null && id.func_149688_o() != Material.field_151586_h && id.func_149656_h() == 1;
    }

    public static void startRitual(World world, int x, int y, int z, EntityPlayer player) {
        world.func_72942_c((Entity)new EntityLightningBolt(world, (double)x, (double)y, (double)z));
        if (ExtraUtils.cursedEarth != null) {
            BlockCursedEarth.powered = 16;
            block0: for (int dx = -max_range; dx <= max_range; ++dx) {
                block1: for (int dz = -max_range; dz <= max_range; ++dz) {
                    if (dx * dx + dz * dz < max_range * max_range) {
                        for (int dy = max_range; dy > -max_range; --dy) {
                            if (dx * dx + dy * dy + dz * dz <= max_range * max_range) {
                                Block id = world.func_147439_a(x + dx, y + dy, z + dz);
                                if (id == Blocks.field_150350_a) continue;
                                if (id == Blocks.field_150346_d || id == Blocks.field_150349_c) {
                                    world.func_147465_d(x + dx, y + dy, z + dz, ExtraUtils.cursedEarth, 0, 3);
                                    continue block1;
                                }
                                if (id instanceof BlockLeaves) {
                                    id.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
                                    world.func_147449_b(x + dx, y + dy, z + dz, Blocks.field_150350_a);
                                    continue;
                                }
                                if (id instanceof BlockSnow) {
                                    world.func_147449_b(x + dx, y + dy, z + dz, Blocks.field_150350_a);
                                    continue;
                                }
                                if (id.func_149656_h() == 1 && id != Blocks.field_150488_af) {
                                    world.func_147480_a(x + dx, y + dy, z + dz, true);
                                    continue;
                                }
                                if (!id.func_149662_c()) continue;
                                continue block1;
                            }
                            if (dy < 0) continue block1;
                        }
                        continue;
                    }
                    if (dz > 0) continue block0;
                }
            }
            BlockCursedEarth.powered = 0;
        }
    }
}

