/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.recipes;

import buildcraft.api.recipes.IFlexibleRecipe;
import buildcraft.api.recipes.IRecipeManager;
import buildcraft.core.recipes.FlexibleRecipe;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.Collections;

public class RecipeManager<T>
implements IRecipeManager<T> {
    private BiMap<String, IFlexibleRecipe<T>> recipes = HashBiMap.create();

    @Override
    public void addRecipe(String id, int energyCost, T output, Object ... input) {
        this.addRecipe(id, energyCost, 0, output, input);
    }

    @Override
    public void addRecipe(String id, int energyCost, int craftingDelay, T output, Object ... input) {
        this.recipes.put((Object)id, new FlexibleRecipe<T>(id, output, energyCost, craftingDelay, input));
    }

    @Override
    public void addRecipe(IFlexibleRecipe<T> recipe) {
        this.recipes.put((Object)recipe.getId(), recipe);
    }

    @Override
    public void removeRecipe(String id) {
        this.recipes.remove((Object)id);
    }

    @Override
    public void removeRecipe(IFlexibleRecipe<T> recipe) {
        this.recipes.remove(this.recipes.inverse().get(recipe));
    }

    @Override
    public Collection<IFlexibleRecipe<T>> getRecipes() {
        return Collections.unmodifiableCollection(this.recipes.values());
    }

    @Override
    public IFlexibleRecipe<T> getRecipe(String id) {
        return (IFlexibleRecipe)this.recipes.get((Object)id);
    }
}

