/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.blocks.tiles;

import makeo.gadomancy.common.blocks.tiles.TileExtendedNode;
import makeo.gadomancy.common.node.ExtendedNodeType;
import makeo.gadomancy.common.utils.Injector;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.tiles.TileJarNode;
import thaumcraft.common.tiles.TileNode;

public class TileExtendedNodeJar
extends TileJarNode {
    private static final ResourceLocation tex = new ResourceLocation("thaumcraft", "textures/models/jar.png");
    private AspectList aspects = new AspectList();
    private AspectList aspectsBase = new AspectList();
    private NodeType nodeType = NodeType.NORMAL;
    private NodeModifier nodeModifier;
    private ExtendedNodeType extendedNodeType;
    private NBTTagCompound behaviorSnapshot;
    private String id = "";
    public long animate;
    public boolean drop = true;

    public ResourceLocation getTexture() {
        return tex;
    }

    public boolean canUpdate() {
        return true;
    }

    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.aspects.readFromNBT(nbttagcompound);
        this.id = nbttagcompound.func_74779_i("nodeId");
        AspectList al = new AspectList();
        NBTTagList tlist = nbttagcompound.func_150295_c("AspectsBase", 10);
        for (int j = 0; j < tlist.func_74745_c(); ++j) {
            Aspect[] rs = tlist.func_150305_b(j);
            if (!rs.func_74764_b("key")) continue;
            al.add(Aspect.getAspect((String)rs.func_74779_i("key")), rs.func_74762_e("amount"));
        }
        Short oldBase = nbttagcompound.func_74765_d("nodeVisBase");
        this.aspectsBase = new AspectList();
        if (oldBase > 0 && al.size() == 0) {
            for (Aspect a : this.aspects.getAspects()) {
                this.aspectsBase.merge(a, (int)oldBase.shortValue());
            }
        } else {
            this.aspectsBase = al.copy();
        }
        this.setNodeType(NodeType.values()[nbttagcompound.func_74771_c("type")]);
        byte mod = nbttagcompound.func_74771_c("modifier");
        if (mod >= 0) {
            this.setNodeModifier(NodeModifier.values()[mod]);
        } else {
            this.setNodeModifier(null);
        }
        byte exType = nbttagcompound.func_74771_c("extendedNodeType");
        if (exType >= 0) {
            this.setExtendedNodeType(ExtendedNodeType.values()[exType]);
        } else {
            this.setExtendedNodeType(null);
        }
        if (nbttagcompound.func_74764_b("Behavior")) {
            this.behaviorSnapshot = nbttagcompound.func_74775_l("Behavior");
        }
    }

    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        this.aspects.writeToNBT(nbttagcompound);
        nbttagcompound.func_74778_a("nodeId", this.id);
        NBTTagList tlist = new NBTTagList();
        nbttagcompound.func_74782_a("AspectsBase", (NBTBase)tlist);
        for (Aspect aspect : this.aspectsBase.getAspects()) {
            if (aspect == null) continue;
            NBTTagCompound f = new NBTTagCompound();
            f.func_74778_a("key", aspect.getTag());
            f.func_74768_a("amount", this.aspectsBase.getAmount(aspect));
            tlist.func_74742_a((NBTBase)f);
        }
        nbttagcompound.func_74774_a("type", (byte)this.getNodeType().ordinal());
        nbttagcompound.func_74774_a("modifier", this.getNodeModifier() == null ? (byte)-1 : (byte)this.getNodeModifier().ordinal());
        nbttagcompound.func_74774_a("extendedNodeType", this.getExtendedNodeType() == null ? (byte)-1 : (byte)this.getExtendedNodeType().ordinal());
        if (this.behaviorSnapshot != null) {
            nbttagcompound.func_74782_a("Behavior", (NBTBase)this.behaviorSnapshot);
        }
    }

    public AspectList getAspects() {
        return this.aspects;
    }

    public AspectList getAspectsBase() {
        return this.aspectsBase;
    }

    public void setAspects(AspectList aspects) {
        this.aspects = aspects.copy();
        this.aspectsBase = aspects.copy();
    }

    public int addToContainer(Aspect tt, int am) {
        int out = 0;
        if (this.aspects.getAmount(tt) + am > this.aspectsBase.getAmount(tt)) {
            out = this.aspects.getAmount(tt) + am - this.aspectsBase.getAmount(tt);
        }
        this.aspects.add(tt, am - out);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
        return out;
    }

    public boolean takeFromContainer(Aspect tt, int am) {
        if (this.aspects.getAmount(tt) >= am) {
            this.aspects.remove(tt, am);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amt) {
        return this.aspects.getAmount(tag) >= amt;
    }

    public boolean doesContainerContain(AspectList ot) {
        for (Aspect tt : ot.getAspects()) {
            if (this.aspects.getAmount(tt) >= ot.getAmount(tt)) continue;
            return false;
        }
        return true;
    }

    public int containerContains(Aspect tag) {
        return this.aspects.getAmount(tag);
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public void setNodeModifier(NodeModifier nodeModifier) {
        this.nodeModifier = nodeModifier;
    }

    public NodeModifier getNodeModifier() {
        return this.nodeModifier;
    }

    public ExtendedNodeType getExtendedNodeType() {
        return this.extendedNodeType;
    }

    public void setExtendedNodeType(ExtendedNodeType extendedNodeType) {
        this.extendedNodeType = extendedNodeType;
    }

    public int getNodeVisBase(Aspect aspect) {
        return this.aspectsBase.getAmount(aspect);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setBehaviorSnapshot(NBTTagCompound behaviorSnapshot) {
        this.behaviorSnapshot = behaviorSnapshot;
    }

    public NBTTagCompound getBehaviorSnapshot() {
        return this.behaviorSnapshot;
    }

    public void setNodeVisBase(Aspect aspect, short nodeVisBase) {
        if (this.aspectsBase.getAmount(aspect) < nodeVisBase) {
            this.aspectsBase.merge(aspect, (int)nodeVisBase);
        } else {
            this.aspectsBase.reduce(aspect, this.aspectsBase.getAmount(aspect) - nodeVisBase);
        }
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 9) {
            if (this.field_145850_b.field_72995_K) {
                for (int yy = -1; yy < 3; ++yy) {
                    for (int xx = -1; xx < 2; ++xx) {
                        for (int zz = -1; zz < 2; ++zz) {
                            Thaumcraft.proxy.blockSparkle(this.field_145850_b, this.field_145851_c + xx, this.field_145848_d + yy, this.field_145849_e + zz, -9999, 5);
                        }
                    }
                }
                this.animate = System.currentTimeMillis() + 1000L;
            }
            return true;
        }
        return super.func_145842_c(i, j);
    }

    public int onWandRightClick(World world, ItemStack wandstack, EntityPlayer player, int x, int y, int z, int side, int md) {
        if (!world.field_72995_K) {
            this.drop = false;
            world.func_147465_d(x, y, z, ConfigBlocks.blockAiry, 0, 3);
            TileExtendedNode tn = (TileExtendedNode)world.func_147438_o(x, y, z);
            if (tn != null) {
                tn.setAspects(this.getAspects());
                tn.setNodeModifier(this.getNodeModifier());
                tn.setNodeType(this.getNodeType());
                tn.setExtendedNodeType(this.getExtendedNodeType());
                new Injector((Object)tn, TileNode.class).setField("id", (Object)this.getId());
                tn.readBehaviorSnapshot(this.getBehaviorSnapshot());
                world.func_147471_g(x, y, z);
                tn.func_70296_d();
            }
        }
        world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)ConfigBlocks.blockJar) + 61440);
        player.field_70170_p.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.glass", 1.0f, 0.9f + player.field_70170_p.field_73012_v.nextFloat() * 0.2f, false);
        player.func_71038_i();
        return 0;
    }

    public ItemStack onWandRightClick(World world, ItemStack wandstack, EntityPlayer player) {
        return null;
    }

    public void onUsingWandTick(ItemStack wandstack, EntityPlayer player, int count) {
    }

    public void onWandStoppedUsing(ItemStack wandstack, World world, EntityPlayer player, int count) {
    }

    public boolean doesContainerAccept(Aspect tag) {
        return true;
    }
}

