/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.events;

import appeng.tile.AEBaseTile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.nbt.NBTTagCompound;

public final class AETileEventHandler {
    private final Method method;

    public AETileEventHandler(Method method) {
        this.method = method;
    }

    public void tick(AEBaseTile tile) {
        try {
            this.method.invoke((Object)tile, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public void writeToNBT(AEBaseTile tile, NBTTagCompound data) {
        try {
            this.method.invoke((Object)tile, data);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public void readFromNBT(AEBaseTile tile, NBTTagCompound data) {
        try {
            this.method.invoke((Object)tile, data);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public void writeToStream(AEBaseTile tile, ByteBuf data) {
        try {
            this.method.invoke((Object)tile, data);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean readFromStream(AEBaseTile tile, ByteBuf data) {
        try {
            return (Boolean)this.method.invoke((Object)tile, data);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }
}

