/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.api.parts.IAlphaPassItem;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.client.ClientHelper;
import appeng.client.render.BusRenderHelper;
import appeng.client.render.RenderBlocksWorkaround;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.facade.FacadePart;
import appeng.facade.IFacadeItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class BusRenderer
implements IItemRenderer {
    public static final BusRenderer INSTANCE = new BusRenderer();
    private static final Map<Integer, IPart> RENDER_PART = new ConcurrentHashMap<Integer, IPart>();
    private final ThreadLocal<RenderBlocksWorkaround> renderer = ThreadLocal.withInitial(RenderBlocksWorkaround::new);

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (item == null) {
            return;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        BusRenderHelper busRenderer = BusRenderHelper.instances.get();
        RenderBlocksWorkaround renderer = this.getRenderer();
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)24576);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        if (AEConfig.instance.isFeatureEnabled(AEFeature.AlphaPass) && item.func_77973_b() instanceof IAlphaPassItem && ((IAlphaPassItem)item.func_77973_b()).useAlphaPass(item)) {
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)3042);
        } else {
            GL11.glAlphaFunc((int)516, (float)0.4f);
            GL11.glEnable((int)3008);
            GL11.glDisable((int)3042);
        }
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glTranslatef((float)-0.2f, (float)-0.1f, (float)-0.3f);
        }
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
            GL11.glTranslatef((float)-0.8f, (float)-0.87f, (float)-0.7f);
        }
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glTranslatef((float)0.0f, (float)-0.1f, (float)0.0f);
        }
        GL11.glTranslated((double)0.2, (double)0.3, (double)0.1);
        GL11.glScaled((double)1.2, (double)1.2, (double)1.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        tessellator.func_78380_c(0xE000E0);
        busRenderer.setBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        busRenderer.setTexture(null);
        busRenderer.setInvColor(0xFFFFFF);
        renderer.field_147845_a = ClientHelper.proxy.getWorld();
        busRenderer.setOrientation(ForgeDirection.EAST, ForgeDirection.UP, ForgeDirection.SOUTH);
        renderer.field_147873_r = 0;
        renderer.field_147867_u = 0;
        this.getRenderer().field_147871_s = 0;
        renderer.field_147869_t = 0;
        renderer.field_147875_q = 0;
        renderer.field_147865_v = 0;
        renderer.field_147844_c = false;
        renderer.field_147840_d = null;
        Item item2 = item.func_77973_b();
        if (item2 instanceof IFacadeItem) {
            IFacadeItem fi = (IFacadeItem)item2;
            FacadePart fp = fi.createPartFromItemStack(item, ForgeDirection.SOUTH);
            if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
                GL11.glRotatef((float)160.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslated((double)-0.4, (double)0.1, (double)-1.6);
            }
            if (fp != null) {
                fp.renderInventory(busRenderer, renderer);
            }
        } else {
            IPart ip = this.getRenderer(item, (IPartItem)item.func_77973_b());
            if (ip != null) {
                if (type == IItemRenderer.ItemRenderType.ENTITY) {
                    int depth = ip.cableConnectionRenderTo();
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-0.04f * (float)(8 - depth) - 0.06f));
                }
                ip.renderInventory(busRenderer, renderer);
            }
        }
        renderer.field_147873_r = 0;
        renderer.field_147867_u = 0;
        this.getRenderer().field_147871_s = 0;
        renderer.field_147869_t = 0;
        renderer.field_147875_q = 0;
        renderer.field_147865_v = 0;
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    @Nullable
    private IPart getRenderer(ItemStack is, IPartItem c) {
        int id = Item.func_150891_b((Item)is.func_77973_b()) << 16 | is.func_77960_j();
        IPart part = RENDER_PART.get(id);
        if (part == null && (part = c.createPartFromItemStack(is)) != null) {
            RENDER_PART.put(id, part);
        }
        return part;
    }

    public RenderBlocksWorkaround getRenderer() {
        return this.renderer.get();
    }
}

